/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.python.indexer.Def;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.Util;
import org.python.indexer.ast.NAssign;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NBody;
import org.python.indexer.ast.NList;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NStr;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;

public class NModule
extends NNode {
    static final long serialVersionUID = -7737089963380450802L;
    public String name;
    public NBody body;
    private String file;
    private String md5;

    public NModule() {
    }

    public NModule(String name) {
        this.name = name;
    }

    public NModule(NBlock body, int start, int end) {
        super(start, end);
        this.body = new NBody(body);
        this.addChildren(this.body);
    }

    public void setFile(String file) throws Exception {
        this.file = file;
        this.name = Util.moduleNameFor(file);
        this.md5 = Util.getMD5(new File(file));
    }

    public void setFile(File path) throws Exception {
        this.file = path.getCanonicalPath();
        this.name = Util.moduleNameFor(this.file);
        this.md5 = Util.getMD5(path);
    }

    public void setFileAndMD5(String path, String md5) throws Exception {
        this.file = path;
        this.name = Util.moduleNameFor(this.file);
        this.md5 = md5;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    public String getMD5() {
        return this.md5;
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        NBinding mb = Indexer.idx.moduleTable.lookupLocal(this.file);
        if (mb == null) {
            Indexer.idx.reportFailedAssertion("No module for " + this.name + ": " + this.file);
            this.setType(new NModuleType(this.name, this.file, s2));
        } else {
            this.setType(mb.getType());
        }
        NModule.resolveExpr(this.body, this.getTable());
        this.resolveExportedNames();
        return this.getType();
    }

    private void resolveExportedNames() throws Exception {
        NModuleType mtype = null;
        NType thisType = this.getType();
        if (thisType.isModuleType()) {
            mtype = thisType.asModuleType();
        } else if (thisType.isUnionType()) {
            for (NType u2 : thisType.asUnionType().getTypes()) {
                if (!u2.isModuleType()) continue;
                mtype = u2.asModuleType();
                break;
            }
        }
        if (mtype == null) {
            Indexer.idx.reportFailedAssertion("Found non-module type for " + this + " in " + this.getFile() + ": " + thisType);
            return;
        }
        Scope table = mtype.getTable();
        for (NStr nstr : this.getExportedNameNodes()) {
            String name = nstr.n.toString();
            NBinding b2 = table.lookupLocal(name);
            if (b2 == null) continue;
            Indexer.idx.putLocation(nstr, b2);
        }
    }

    public List<String> getExportedNames() throws Exception {
        ArrayList<String> exports = new ArrayList<String>();
        if (!this.getType().isModuleType()) {
            return exports;
        }
        for (NStr nstr : this.getExportedNameNodes()) {
            exports.add(nstr.n.toString());
        }
        return exports;
    }

    public List<NStr> getExportedNameNodes() throws Exception {
        ArrayList<NStr> exports = new ArrayList<NStr>();
        if (!this.getType().isModuleType()) {
            return exports;
        }
        NBinding all = this.getTable().lookupLocal("__all__");
        if (all == null) {
            return exports;
        }
        Def def = all.getSignatureNode();
        if (def == null) {
            return exports;
        }
        NNode __all__ = this.getDeepestNodeAtOffset(def.start());
        if (!(__all__ instanceof NName)) {
            return exports;
        }
        NNode assign = __all__.getParent();
        if (!(assign instanceof NAssign)) {
            return exports;
        }
        NNode rvalue = ((NAssign)assign).rvalue;
        if (!(rvalue instanceof NList)) {
            return exports;
        }
        for (NNode elt : ((NList)rvalue).elts) {
            if (!(elt instanceof NStr)) continue;
            NStr nstr = (NStr)elt;
            if (nstr.n == null) continue;
            exports.add(nstr);
        }
        return exports;
    }

    public String toLongString() {
        return "<Module:" + this.body + ">";
    }

    public String toString() {
        return "<Module:" + this.getFile() + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNode(this.body, v2);
        }
    }
}

