/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;

public class NExec
extends NNode {
    static final long serialVersionUID = -1840017898177850339L;
    public NNode body;
    public NNode globals;
    public NNode locals;

    public NExec(NNode body, NNode globals, NNode locals) {
        this(body, globals, locals, 0, 1);
    }

    public NExec(NNode body, NNode globals, NNode locals, int start, int end) {
        super(start, end);
        this.body = body;
        this.globals = globals;
        this.locals = locals;
        this.addChildren(body, globals, locals);
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        NExec.resolveExpr(this.body, s2);
        NExec.resolveExpr(this.globals, s2);
        NExec.resolveExpr(this.locals, s2);
        return this.getType();
    }

    public String toString() {
        return "<Exec:" + this.start() + ":" + this.end() + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNode(this.body, v2);
            this.visitNode(this.globals, v2);
            this.visitNode(this.locals, v2);
        }
    }
}

