/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.python.indexer.AstCache;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.TestBase;
import org.python.indexer.ast.NAlias;
import org.python.indexer.ast.NAssert;
import org.python.indexer.ast.NAssign;
import org.python.indexer.ast.NAttribute;
import org.python.indexer.ast.NAugAssign;
import org.python.indexer.ast.NBinOp;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NBody;
import org.python.indexer.ast.NBoolOp;
import org.python.indexer.ast.NBreak;
import org.python.indexer.ast.NCall;
import org.python.indexer.ast.NClassDef;
import org.python.indexer.ast.NCompare;
import org.python.indexer.ast.NComprehension;
import org.python.indexer.ast.NContinue;
import org.python.indexer.ast.NDelete;
import org.python.indexer.ast.NDict;
import org.python.indexer.ast.NEllipsis;
import org.python.indexer.ast.NExceptHandler;
import org.python.indexer.ast.NExec;
import org.python.indexer.ast.NExprStmt;
import org.python.indexer.ast.NFor;
import org.python.indexer.ast.NFunctionDef;
import org.python.indexer.ast.NGeneratorExp;
import org.python.indexer.ast.NGlobal;
import org.python.indexer.ast.NIf;
import org.python.indexer.ast.NIfExp;
import org.python.indexer.ast.NImport;
import org.python.indexer.ast.NImportFrom;
import org.python.indexer.ast.NIndex;
import org.python.indexer.ast.NKeyword;
import org.python.indexer.ast.NLambda;
import org.python.indexer.ast.NList;
import org.python.indexer.ast.NListComp;
import org.python.indexer.ast.NModule;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNum;
import org.python.indexer.ast.NPass;
import org.python.indexer.ast.NPlaceHolder;
import org.python.indexer.ast.NPrint;
import org.python.indexer.ast.NQname;
import org.python.indexer.ast.NRaise;
import org.python.indexer.ast.NRepr;
import org.python.indexer.ast.NReturn;
import org.python.indexer.ast.NSlice;
import org.python.indexer.ast.NStr;
import org.python.indexer.ast.NSubscript;
import org.python.indexer.ast.NTryExcept;
import org.python.indexer.ast.NTryFinally;
import org.python.indexer.ast.NTuple;
import org.python.indexer.ast.NUnaryOp;
import org.python.indexer.ast.NUrl;
import org.python.indexer.ast.NWhile;
import org.python.indexer.ast.NWith;
import org.python.indexer.ast.NYield;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;

public class IndexerTest
extends TestBase {
    public void testBuiltinModulePresent() throws Exception {
        NType mod2 = this.idx.moduleTable.lookupType("__builtin__");
        IndexerTest.assertNotNull((String)"missing __builtin__ module", (Object)mod2);
        IndexerTest.assertTrue((String)("wrong type: " + mod2.getClass()), (boolean)(mod2 instanceof NModuleType));
    }

    public void testLazyModuleLoad() throws Exception {
        IndexerTest.assertNull((String)"'array' module should not yet be loaded", (Object)this.idx.moduleTable.lookupType("array"));
        this.assertNoBinding("array");
        IndexerTest.assertNotNull((Object)this.idx.loadModule("array"));
        IndexerTest.assertNotNull((String)"'array' module should have been loaded", (Object)this.idx.moduleTable.lookupType("array"));
        this.assertModuleBinding("array");
    }

    public void testNativeModulesAvailable() throws Exception {
        for (String name : new String[]{"array", "ctypes", "errno", "math", "operator", "os", "signal", "sys", "thread", "time"}) {
            this.assertNoBinding(name);
            IndexerTest.assertNotNull((String)name, (Object)this.idx.loadModule(name));
            this.assertModuleBinding(name);
        }
    }

    public void testBuiltinObject() throws Exception {
        this.assertClassBinding("__builtin__.object");
        this.assertClassBinding("__builtin__.object.__class__");
    }

    public void testBuiltinTuple() throws Exception {
        this.assertClassBinding("__builtin__.tuple");
        this.assertMethodBinding("__builtin__.tuple.__rmul__");
        this.assertMethodBinding("__builtin__.tuple.__iter__");
    }

    public void testBuiltinList() throws Exception {
        this.assertClassBinding("__builtin__.list");
        this.assertMethodBinding("__builtin__.list.append");
        this.assertMethodBinding("__builtin__.list.count");
    }

    public void testBuiltinNum() throws Exception {
        this.assertClassBinding("__builtin__.float");
        NBinding b2 = this.assertMethodBinding("__builtin__.float.fromhex");
        IndexerTest.assertTrue((boolean)b2.isBuiltin());
    }

    public void testBuiltinStr() throws Exception {
        this.assertClassBinding("__builtin__.str");
        this.assertMethodBinding("__builtin__.str.encode");
        this.assertMethodBinding("__builtin__.str.startswith");
        this.assertMethodBinding("__builtin__.str.split");
        this.assertMethodBinding("__builtin__.str.partition");
    }

    public void testBuiltinDict() throws Exception {
        this.assertClassBinding("__builtin__.dict");
        this.assertMethodBinding("__builtin__.dict.__getitem__");
        this.assertMethodBinding("__builtin__.dict.keys");
        this.assertMethodBinding("__builtin__.dict.clear");
    }

    public void testBuiltinFile() throws Exception {
        this.assertClassBinding("__builtin__.file");
        this.assertMethodBinding("__builtin__.file.__enter__");
        this.assertMethodBinding("__builtin__.file.readline");
        this.assertMethodBinding("__builtin__.file.readlines");
        this.assertMethodBinding("__builtin__.file.isatty");
    }

    public void testBuiltinFuncs() throws Exception {
        this.assertFunctionBinding("__builtin__.apply");
        this.assertFunctionBinding("__builtin__.abs");
        this.assertFunctionBinding("__builtin__.hex");
        this.assertFunctionBinding("__builtin__.range");
        this.assertFunctionBinding("__builtin__.globals");
        this.assertFunctionBinding("__builtin__.open");
    }

    public void testBuiltinTypes() throws Exception {
        this.assertClassBinding("__builtin__.ArithmeticError");
        this.assertClassBinding("__builtin__.ZeroDivisionError");
        this.assertAttributeBinding("__builtin__.True");
        this.assertAttributeBinding("__builtin__.False");
        this.assertAttributeBinding("__builtin__.None");
        this.assertAttributeBinding("__builtin__.Ellipsis");
    }

    public void testStrConstructor() throws Exception {
        String src = this.index("newstr.py", "x = str([])");
        this.assertStringType("newstr.x");
    }

    public void testListSubscript() throws Exception {
        String src = this.index("test.py", "x = [1, 2, 3]", "y = x[2]");
        this.assertNumType("test.y");
    }

    public void testBuiltinSys() throws Exception {
        this.idx.loadModule("sys");
        this.assertModuleBinding("sys");
        this.assertAttributeBinding("sys.__stderr__");
        NBinding b2 = this.assertFunctionBinding("sys.exit");
        IndexerTest.assertTrue((boolean)b2.isBuiltin());
        this.assertFunctionBinding("sys.getprofile");
        this.assertFunctionBinding("sys.getdefaultencoding");
        this.assertAttributeBinding("sys.api_version");
        this.assertNumType("sys.api_version");
        this.assertAttributeBinding("sys.argv");
        this.assertBindingType("sys.argv", NListType.class);
        this.assertAttributeBinding("sys.byteorder");
        this.assertStringType("sys.byteorder");
        this.assertAttributeBinding("sys.flags");
        this.assertBindingType("sys.flags", NDictType.class);
    }

    public void testFetchAst() throws Exception {
        NModule ast = this.idx.getAstForFile(this.abspath("hello.py"));
        IndexerTest.assertNotNull((String)"failed to load file", (Object)ast);
        IndexerTest.assertEquals((String)"module has wrong name", (String)"hello", (String)ast.name);
        IndexerTest.assertNotNull((String)"AST has no body", (Object)ast.body);
        IndexerTest.assertNotNull((String)"AST body has no children", (Object)ast.body.seq);
        IndexerTest.assertEquals((String)"wrong number of children", (int)1, (int)ast.body.seq.size());
        NNode e2 = (NNode)ast.body.seq.get(0);
        IndexerTest.assertTrue((String)("Incorrect AST: " + e2.getClass()), (boolean)(e2 instanceof NExprStmt));
        e2 = ((NExprStmt)e2).value;
        IndexerTest.assertTrue((String)("Incorrect AST: " + e2.getClass()), (boolean)(e2 instanceof NStr));
        IndexerTest.assertEquals((String)"Wrong string content", (String)"Hello", (String)((NStr)e2).n.toString());
    }

    public void testFileLoad() throws Exception {
        this.idx.loadFile(this.abspath("testfileload.py"), true);
        this.idx.ready();
        IndexerTest.assertEquals((String)"loaded more than 1 file", (int)1, (int)this.idx.numFilesLoaded());
    }

    public void testAstCacheTmpDir() throws Exception {
        AstCache cache = AstCache.get();
        File f2 = new File(AstCache.CACHE_DIR);
        IndexerTest.assertTrue((boolean)f2.exists());
        IndexerTest.assertTrue((boolean)f2.canRead());
        IndexerTest.assertTrue((boolean)f2.canWrite());
        IndexerTest.assertTrue((boolean)f2.isDirectory());
    }

    public void testAstCacheNames() throws Exception {
        AstCache cache = AstCache.get();
        String sourcePath = this.abspath("hello.py");
        String cachePath = cache.getCachePath(new File(sourcePath));
        String cachedName = new File(cachePath).getName();
        IndexerTest.assertTrue((String)("Invalid cache name: " + cachedName), (boolean)cachedName.matches("^hello.py[A-Za-z0-9]{32}.ast$"));
    }

    public void testAstCache() throws Exception {
        AstCache cache = AstCache.get();
        String sourcePath = this.abspath("hello.py");
        NModule ast = cache.getSerializedModule(sourcePath);
        IndexerTest.assertNull((Object)ast);
        cache.getAST(sourcePath);
        ast = cache.getSerializedModule(sourcePath);
        IndexerTest.assertNotNull((Object)ast);
        IndexerTest.assertEquals((String)sourcePath, (String)ast.getFile());
    }

    public void testAstCacheEmptyFile() throws Exception {
        AstCache cache = AstCache.get();
        NModule mod2 = cache.getAST(this.abspath("empty_file.py"));
        IndexerTest.assertNotNull((Object)mod2);
        NBody seq = mod2.body;
        IndexerTest.assertNotNull((Object)seq);
        IndexerTest.assertTrue((boolean)seq.seq.isEmpty());
    }

    public void testConstructedTypes() throws Exception {
        this.assertNoneType(new NAlias(null, null, null));
        this.assertNoneType(new NAssert(null, null));
        this.assertNoneType(new NAssign(null, null));
        this.assertNoneType(new NAttribute(new NStr(), new NName("")));
        this.assertNoneType(new NAugAssign(null, null, null));
        this.assertNoneType(new NBinOp(null, null, null));
        this.assertNoneType(new NBlock(null));
        this.assertNoneType(new NBody((List<NNode>)null));
        this.assertNoneType(new NBoolOp(null, null));
        this.assertNoneType(new NBreak());
        this.assertNoneType(new NCall(null, null, null, null, null));
        this.assertNoneType(new NClassDef(null, null, null));
        this.assertNoneType(new NCompare(null, null, null));
        this.assertNoneType(new NComprehension(null, null, null));
        this.assertNoneType(new NContinue());
        this.assertNoneType(new NDelete(null));
        this.assertNoneType(new NDict(null, null));
        this.assertNoneType(new NEllipsis());
        this.assertNoneType(new NExceptHandler(null, null, null));
        this.assertNoneType(new NExec(null, null, null));
        this.assertNoneType(new NExprStmt(null));
        this.assertNoneType(new NFor(null, null, null, null));
        this.assertNoneType(new NFunctionDef(null, null, null, null, null, null));
        this.assertNoneType(new NGeneratorExp(null, null));
        this.assertNoneType(new NGlobal(null));
        this.assertNoneType(new NIf(null, null, null));
        this.assertNoneType(new NIfExp(null, null, null));
        this.assertNoneType(new NImport(null));
        this.assertNoneType(new NImportFrom(null, null, null));
        this.assertNoneType(new NIndex(null));
        this.assertNoneType(new NKeyword(null, null));
        this.assertNoneType(new NLambda(null, null, null, null, null));
        this.assertNoneType(new NList(null));
        this.assertNoneType(new NListComp(null, null));
        this.assertNoneType(new NModule(null, 0, 1));
        this.assertNoneType(new NName(""));
        this.assertNoneType(new NNum(-1));
        this.assertNoneType(new NPass());
        this.assertNoneType(new NPlaceHolder());
        this.assertNoneType(new NPrint(null, null));
        this.assertNoneType(new NQname(null, new NName("")));
        this.assertNoneType(new NRaise(null, null, null));
        this.assertNoneType(new NRepr(null));
        this.assertNoneType(new NReturn(null));
        this.assertNoneType(new NSlice(null, null, null));
        this.assertNoneType(new NStr());
        this.assertNoneType(new NSubscript(null, null));
        this.assertNoneType(new NTryExcept(null, null, null));
        this.assertNoneType(new NTryFinally(null, null));
        this.assertNoneType(new NTuple(null));
        this.assertNoneType(new NUnaryOp(null, null));
        this.assertNoneType(new NUrl(""));
        this.assertNoneType(new NWhile(null, null, null));
        this.assertNoneType(new NWith(null, null, null));
        this.assertNoneType(new NYield(null));
    }

    private void assertNoneType(NNode n2) {
        IndexerTest.assertEquals((Object)n2.getType(), (Object)Indexer.idx.builtins.None);
    }

    public void testClassTypeBuiltinAttrs() throws Exception {
        String file = "classtype_builtins.py";
        this.buildIndex(file);
        NModuleType module = (NModuleType)this.idx.moduleTable.lookupType(this.abspath(file));
        Scope mtable = module.getTable();
        IndexerTest.assertTrue((boolean)mtable.lookupType("MyClass").isClassType());
        IndexerTest.assertTrue((boolean)mtable.lookupType("MyClassNoDoc").isClassType());
        IndexerTest.assertTrue((mtable.lookupType("MyClass").getTable().getParent() == mtable ? 1 : 0) != 0);
        IndexerTest.assertEquals((Object)((Object)NBinding.Kind.CLASS), (Object)((Object)mtable.lookup("MyClass").getKind()));
        Scope t2 = mtable.lookupType("MyClass").getTable();
        IndexerTest.assertTrue((boolean)t2.lookupType("__bases__").isTupleType());
        IndexerTest.assertTrue((boolean)t2.lookupType("__dict__").isDictType());
        IndexerTest.assertEquals((Object)this.idx.builtins.BaseStr, (Object)t2.lookupType("__name__"));
        IndexerTest.assertEquals((Object)this.idx.builtins.BaseStr, (Object)t2.lookupType("__module__"));
        IndexerTest.assertEquals((Object)this.idx.builtins.BaseStr, (Object)t2.lookupType("__doc__"));
        t2 = mtable.lookupType("MyClassNoDoc").getTable();
        IndexerTest.assertEquals((Object)this.idx.builtins.BaseStr, (Object)t2.lookupType("__doc__"));
    }

    public void testMethodBuiltinAttrs() throws Exception {
        String file = "classtype_builtins.py";
        this.buildIndex(file);
        Scope mtable = this.idx.moduleTable.lookupType(this.abspath(file)).getTable();
        NBinding method = mtable.lookupType("MyClass").getTable().lookup("__init__");
        IndexerTest.assertNotNull((Object)method);
        IndexerTest.assertEquals((Object)((Object)NBinding.Kind.CONSTRUCTOR), (Object)((Object)method.getKind()));
        IndexerTest.assertEquals((String)"classtype_builtins.MyClass.__init__", (String)method.getQname());
        NType ftype = mtable.lookupType("MyClass").getTable().lookupType("__init__");
        IndexerTest.assertTrue((boolean)ftype.isFuncType());
        NBinding c2 = mtable.lookup("MyClass");
        for (String special : new String[]{"im_class", "__class__", "im_self", "__self__"}) {
            NBinding attr = ftype.getTable().lookup(special);
            IndexerTest.assertNotNull((String)("missing binding for " + special), (Object)attr);
            IndexerTest.assertEquals((Object)c2.getType(), (Object)attr.getType());
        }
    }

    public void testModulePaths() throws Exception {
        this.idx.loadModule("pkg");
        this.idx.loadModule("pkg.animal");
        this.idx.loadModule("pkg.mineral.stone.lapis");
        this.idx.ready();
        this.assertModuleBinding("pkg");
        this.assertModuleBinding("pkg.animal");
        this.assertModuleBinding("pkg.mineral.stone.lapis");
    }

    public void testCircularImport() throws Exception {
        this.idx.loadModule("pkg.animal.mammal.cat");
        this.idx.ready();
    }

    public void testBasicDefsAndRefs() throws Exception {
        this.idx.loadModule("refs");
        this.idx.ready();
        this.assertScopeBinding("refs.foo");
        String src = this.getSource("refs.py");
        this.assertDefinition("refs.foo", "foo", this.nthIndexOf(src, "foo", 1));
        this.assertNoReference("Definition site should not produce a reference", "refs.foo", this.nthIndexOf(src, "foo", 1), "foo".length());
        this.assertReference("refs.foo", this.nthIndexOf(src, "foo", 2));
        this.assertReference("refs.foo", this.nthIndexOf(src, "foo", 3));
        this.assertReference("refs.foo", this.nthIndexOf(src, "foo", 4));
        this.assertReference("refs.foo", this.nthIndexOf(src, "foo", 5));
        this.assertNoReference("Should not have been a reference inside a string", "refs.foo", this.nthIndexOf(src, "foo", 6), "foo".length());
        this.assertReference("refs.foo", this.nthIndexOf(src, "foo", 7));
        this.assertReference("refs.foo", this.nthIndexOf(src, "foo", 8));
        this.assertReference("refs.foo", this.nthIndexOf(src, "foo", 9));
        this.assertReference("refs.foo", this.nthIndexOf(src, "foo", 10));
        this.assertReference("refs.foo", this.nthIndexOf(src, "foo", 11));
        this.assertReference("refs.foo", this.nthIndexOf(src, "foo", 12));
        this.assertNoReference("Function param cannot refer to outer scope", "refs.foo", this.nthIndexOf(src, "foo", 13), "foo".length());
        this.assertNoReference("Function param 'foo' should hide outer foo", "refs.foo", this.nthIndexOf(src, "foo", 14), "foo".length());
        this.assertReference("refs.foo", this.nthIndexOf(src, "foo", 15));
        this.assertReference("refs.foo", this.nthIndexOf(src, "foo", 16));
    }

    public void testAutoClassBindings() throws Exception {
        this.idx.loadModule("class1");
        this.idx.ready();
        this.assertModuleBinding("class1");
        this.assertClassBinding("class1.A");
        NBinding b2 = this.assertAttributeBinding("class1.A.__bases__");
        this.assertStaticSynthetic(b2);
        IndexerTest.assertTrue((boolean)b2.getType().isTupleType());
        IndexerTest.assertTrue((boolean)((NTupleType)b2.getType()).getElementTypes().isEmpty());
        b2 = this.assertAttributeBinding("class1.A.__name__");
        this.assertStaticSynthetic(b2);
        IndexerTest.assertEquals((Object)b2.getType(), (Object)this.idx.builtins.BaseStr);
        b2 = this.assertAttributeBinding("class1.A.__module__");
        this.assertStaticSynthetic(b2);
        IndexerTest.assertEquals((Object)b2.getType(), (Object)this.idx.builtins.BaseStr);
        b2 = this.assertAttributeBinding("class1.A.__doc__");
        this.assertStaticSynthetic(b2);
        IndexerTest.assertEquals((Object)b2.getType(), (Object)this.idx.builtins.BaseStr);
        b2 = this.assertAttributeBinding("class1.A.__dict__");
        this.assertStaticSynthetic(b2);
        IndexerTest.assertTrue((boolean)b2.getType().isDictType());
        IndexerTest.assertEquals((Object)((NDictType)b2.getType()).getKeyType(), (Object)this.idx.builtins.BaseStr);
        IndexerTest.assertTrue((boolean)((NDictType)b2.getType()).getValueType().isUnknownType());
    }

    public void testLocalVarRef() throws Exception {
        this.idx.loadModule("class2");
        this.idx.ready();
        this.assertFunctionBinding("class2.hi");
        this.assertParamBinding("class2.hi@msg");
        String src = this.getSource("class2.py");
        this.assertReference("class2.hi@msg", this.nthIndexOf(src, "msg", 2));
    }

    public void testClassMemberBindings() throws Exception {
        this.idx.loadModule("class1");
        this.idx.ready();
        this.assertScopeBinding("class1.A.a");
        this.assertConstructorBinding("class1.A.__init__");
        this.assertMethodBinding("class1.A.hi");
        this.assertParamBinding("class1.A.__init__@self");
        this.assertParamBinding("class1.A.hi@self");
        this.assertParamBinding("class1.A.hi@msg");
        String src = this.getSource("class1.py");
        this.assertReference("class1.A.hi@msg", this.nthIndexOf(src, "msg", 2));
        this.assertReference("class1.A", src.indexOf("A.a"), 1);
        this.assertReference("class1.A.a", src.indexOf("A.a") + 2, 1);
        this.assertScopeBinding("class1.x");
        this.assertScopeBinding("class1.y");
        this.assertScopeBinding("class1.z");
        this.assertReference("class1.A", src.indexOf("= A") + 2, 1);
        this.assertConstructed("class1.A", src.indexOf("A()"), 1);
        this.assertReference("class1.y", src.indexOf("y.b"), 1);
        this.assertInstanceType("class1.y", "class1.A");
        this.assertReference("class1.A.b", src.indexOf("y.b") + 2, 1);
        this.assertScopeBinding("class1.z");
        this.assertNumType("class1.z");
    }

    public void testCallNewRef() throws Exception {
        this.idx.loadModule("callnewref");
        this.idx.ready();
        String src = this.getSource("callnewref.py");
        String fsig = "callnewref.myfunc";
        this.assertFunctionBinding(fsig);
        this.assertDefinition(fsig, "myfunc", src.indexOf("myfunc"));
        this.assertReference(fsig, this.nthIndexOf(src, "myfunc", 2));
        this.assertCall(fsig, this.nthIndexOf(src, "myfunc", 3));
        String csig = "callnewref.MyClass";
        this.assertClassBinding(csig);
        this.assertDefinition(csig, "MyClass", src.indexOf("MyClass"));
        this.assertReference(csig, this.nthIndexOf(src, "MyClass", 2));
        this.assertConstructed(csig, this.nthIndexOf(src, "MyClass", 3));
        String msig = "callnewref.MyClass.mymethod";
        this.assertMethodBinding(msig);
        this.assertDefinition(msig, "mymethod", src.indexOf("mymethod"));
        this.assertReference(msig, this.nthIndexOf(src, "mymethod", 2));
        this.assertCall(msig, this.nthIndexOf(src, "mymethod", 3));
    }

    public void testPackageLoad() throws Exception {
        this.idx.loadModule("pkgload");
        this.idx.ready();
        this.assertModuleBinding("pkgload");
        this.assertModuleBinding("pkg");
        this.assertScopeBinding("pkg.myvalue");
    }

    public void testUnqualifiedSamePkgImport() throws Exception {
        this.idx.loadModule("pkg.animal.reptile.snake");
        this.idx.ready();
        this.assertModuleBinding("pkg.animal.reptile.snake");
        this.assertModuleBinding("pkg.animal.reptile.croc");
        this.assertClassBinding("pkg.animal.reptile.snake.Snake");
        this.assertClassBinding("pkg.animal.reptile.snake.Python");
        this.assertClassBinding("pkg.animal.reptile.croc.Crocodilian");
        this.assertClassBinding("pkg.animal.reptile.croc.Gavial");
        String snakeSrc = this.getSource("pkg/animal/reptile/snake.py");
        this.assertReference("pkg.animal.reptile.croc", snakeSrc.indexOf("croc"));
        this.assertReference("pkg.animal.reptile.croc", this.nthIndexOf(snakeSrc, "croc", 2));
        this.assertReference("pkg.animal.reptile.croc.Gavial", snakeSrc.indexOf("Gavial"));
    }

    public void testAbsoluteImport() throws Exception {
        this.idx.loadModule("pkg.mineral.metal.lead");
        this.idx.ready();
        this.assertModuleBinding("pkg");
        this.assertModuleBinding("pkg.plant");
        this.assertModuleBinding("pkg.plant.poison");
        this.assertModuleBinding("pkg.plant.poison.eggplant");
        String src = this.getSource("pkg/mineral/metal/lead.py");
        this.assertReference("pkg", this.nthIndexOf(src, "pkg", 1));
        this.assertReference("pkg", this.nthIndexOf(src, "pkg", 2));
        this.assertReference("pkg.plant", this.nthIndexOf(src, "plant", 1));
        this.assertReference("pkg.plant", this.nthIndexOf(src, ".plant", 2) + 1);
        this.assertReference("pkg.plant.poison", this.nthIndexOf(src, "poison", 1));
        this.assertReference("pkg.plant.poison", this.nthIndexOf(src, ".poison", 2) + 1);
        this.assertReference("pkg.plant.poison.eggplant", this.nthIndexOf(src, "eggplant", 1));
        this.assertReference("pkg.plant.poison.eggplant", this.nthIndexOf(src, ".eggplant", 2) + 1);
    }

    public void testAbsoluteImportAs() throws Exception {
        this.idx.loadModule("pkg.mineral.metal.iron");
        this.idx.ready();
        this.assertModuleBinding("pkg");
        this.assertModuleBinding("pkg.mineral");
        this.assertModuleBinding("pkg.mineral.metal");
        this.assertModuleBinding("pkg.mineral.metal.iron");
        this.assertModuleBinding("pkg.plant");
        this.assertModuleBinding("pkg.plant.poison");
        this.assertModuleBinding("pkg.plant.poison.eggplant");
        String adjectives = "pkg.plant.poison.eggplant.adjectives";
        this.assertScopeBinding(adjectives);
        String aubergine = "pkg.mineral.metal.iron.aubergine";
        this.assertScopeBinding(aubergine);
        this.assertBindingType(aubergine, "pkg.plant.poison.eggplant");
        String src = this.getSource("pkg/mineral/metal/iron.py");
        this.assertReference("pkg", src.indexOf("pkg"));
        this.assertReference("pkg.plant", src.indexOf("plant"));
        this.assertReference("pkg.plant.poison", src.indexOf("poison"));
        this.assertReference("pkg.plant.poison.eggplant", src.indexOf("eggplant"));
        this.assertReference(aubergine, this.nthIndexOf(src, "aubergine", 2));
        this.assertReference(adjectives, src.indexOf("adjectives"));
    }

    public void testImportFrom() throws Exception {
        this.idx.loadModule("pkg.other.color.white");
        this.idx.ready();
        String src = this.getSource("pkg/other/color/white.py");
        this.assertReference("pkg.other.color.red", src.indexOf("red"));
        this.assertReference("pkg.other.color.green", src.indexOf("green"));
        this.assertReference("pkg.other.color.blue", src.indexOf("blue"));
        this.assertReference("pkg.other.color.red.r", src.indexOf("r as"), 1);
        this.assertReference("pkg.other.color.blue.b", src.indexOf("b as"), 1);
        this.assertReference("pkg.other.color.red.r", src.indexOf("= R") + 2, 1);
        this.assertReference("pkg.other.color.green.g", src.indexOf("g #"), 1);
        this.assertReference("pkg.other.color.blue.b", src.indexOf("= B") + 2, 1);
    }

    public void testImportStar() throws Exception {
        this.idx.loadModule("pkg.other.color.crimson");
        this.idx.ready();
        String src = this.getSource("pkg/other/color/crimson.py");
        this.assertReference("pkg.other.color.red.r", src.indexOf("r,"), 1);
        this.assertReference("pkg.other.color.red.g", src.indexOf("g,"), 1);
        this.assertReference("pkg.other.color.red.b", src.indexOf("b"), 1);
    }

    public void testImportStarAll() throws Exception {
        this.idx.loadModule("pkg.misc.moduleB");
        this.idx.ready();
        String src = this.getSource("pkg/misc/moduleB.py");
        this.assertReference("pkg.misc.moduleA.a", src.indexOf("a #"), 1);
        this.assertReference("pkg.misc.moduleA.b", src.indexOf("b #"), 1);
        this.assertReference("pkg.misc.moduleA.c", src.indexOf("c #"), 1);
        this.assertNoReference("Should not have imported 'd'", "pkg.misc.moduleA.d", src.indexOf("d #"), 1);
    }

    public void testImportFromInitPy() throws Exception {
        this.idx.loadModule("pkg.animal");
        this.idx.ready();
        this.assertModuleBinding("pkg");
        this.assertModuleBinding("pkg.animal");
        this.assertModuleBinding("pkg.animal.animaltest");
        this.assertScopeBinding("pkg.animal.success");
        this.assertScopeBinding("pkg.animal.animaltest.living");
    }

    public void testTempName() throws Exception {
        String src = this.index("tmpname.py", "def purge():", "  cache.clear()", "cache = {}");
        this.assertScopeBinding("tmpname.cache");
        this.assertBindingType("tmpname.cache", NDictType.class);
        this.assertDefinition("tmpname.cache", "cache", src.lastIndexOf("cache"));
        this.assertReference("tmpname.cache", src.indexOf("cache"));
        this.assertNoDefinition("Temp-def should have been replaced", "tmpname.cache", src.indexOf("cache"), "cache".length());
        this.assertCall("__builtin__.dict.clear", src.lastIndexOf("clear"));
    }

    public void testTempAttr() throws Exception {
        String src = this.index("tmpattr.py", "x = app.usage", "app.usage = 'hi'");
        this.assertScopeBinding("tmpattr.x");
        this.assertScopeBinding("tmpattr.app");
        this.assertAttributeBinding("tmpattr.app.usage");
        this.assertStringType("tmpattr.app.usage");
        this.assertStringType("tmpattr.x");
        this.assertDefinition("tmpattr.app.usage", src.lastIndexOf("usage"));
        this.assertReference("tmpattr.app.usage", src.indexOf("usage"));
    }

    public void testTempAttrOnParam() throws Exception {
        String src = this.index("tmpattr_param.py", "def foo(x):", "  x.hello = 'hi'", "def bar(y=None):", "  y.hello = 'hola'");
        this.assertFunctionBinding("tmpattr_param.foo");
        this.assertParamBinding("tmpattr_param.foo@x");
        this.assertAttributeBinding("tmpattr_param.foo@x.hello");
        this.assertStringType("tmpattr_param.foo@x.hello");
        this.assertReference("tmpattr_param.foo@x", src.indexOf("x.hello"), 1);
        this.assertFunctionBinding("tmpattr_param.bar");
        this.assertParamBinding("tmpattr_param.bar@y");
        this.assertAttributeBinding("tmpattr_param.bar@y.hello");
        this.assertStringType("tmpattr_param.bar@y.hello");
        this.assertReference("tmpattr_param.bar@y", src.indexOf("y.hello"), 1);
    }

    public void testParamDefaultLambdaBinding() throws Exception {
        String src = this.index("test.py", "def foo(arg=lambda name: name + '!'):", "  x = arg('hi')");
        this.assertFunctionBinding("test.foo");
        this.assertParamBinding("test.foo@arg");
        this.assertFunctionBinding("test.lambda%1");
        this.assertParamBinding("test.lambda%1@name");
        this.assertReference("test.lambda%1@name", src.lastIndexOf("name"));
        this.assertCall("test.foo@arg", src.lastIndexOf("arg"));
        this.assertStringType("test.foo&x");
    }

    public void testNestedLambdaParam() throws Exception {
        String src = this.index("test.py", "def util(create):", "  return create()", "z = lambda:util(create=lambda: str())", "y = z()()");
        this.assertScopeBinding("test.z");
        this.assertFunctionBinding("test.lambda%1&lambda%1");
    }

    public void testReassignAttrOfUnknown() throws Exception {
        String src = this.index("reassign.py", "app.foo = 'hello'", "app.foo = 2");
        this.assertScopeBinding("reassign.app");
        NBinding nb = this.assertAttributeBinding("reassign.app.foo");
        NType type = nb.getType();
        IndexerTest.assertTrue((boolean)type.isUnionType());
        Set<NType> types = ((NUnionType)type).getTypes();
        IndexerTest.assertEquals((int)2, (int)types.size());
        IndexerTest.assertTrue((boolean)types.contains(this.idx.builtins.BaseStr));
        IndexerTest.assertTrue((boolean)types.contains(this.idx.builtins.BaseNum));
    }

    public void testRefToProvisionalBinding() throws Exception {
        String src = this.index("provisional.py", "for a in []:", "  a.dump()", "for a in []:", "  a.dump()");
        this.assertModuleBinding("provisional");
        this.assertScopeBinding("provisional.a");
        this.assertNoBinding("provisional.a.dump");
    }

    public void testRefToProvisionalBindingNewType() throws Exception {
        String src = this.index("provisional.py", "for b in []:", "  b.dump()", "for b in ():", "  b.dump()");
        this.assertModuleBinding("provisional");
        this.assertScopeBinding("provisional.b");
        this.assertNoBinding("provisional.b.dump");
    }

    public void testSkipClassScope() throws Exception {
        String src = this.index("skipclass.py", "def aa():", "  xx = 'foo'", "  class bb:", "    xx = 10", "    def cc(self):", "      print bb.xx", "      print xx");
        this.assertReference("skipclass.aa&bb.xx", this.nthIndexOf(src, "xx", 3));
        this.assertReference("skipclass.aa&xx", this.nthIndexOf(src, "xx", 4));
    }

    public void testLambdaArgs() throws Exception {
        String src = this.index("lambda_args.py", "y = lambda x='hi': x.upper()", "y = lambda x='there': x.lower()");
        this.assertScopeBinding("lambda_args.y");
        this.assertFunctionBinding("lambda_args.lambda%1");
        this.assertParamBinding("lambda_args.lambda%1@x");
        this.assertStringType("lambda_args.lambda%1@x");
        this.assertReference("lambda_args.lambda%1@x", this.nthIndexOf(src, "x", 2));
        this.assertCall("__builtin__.str.upper", src.indexOf("upper"));
        this.assertFunctionBinding("lambda_args.lambda%2");
        this.assertParamBinding("lambda_args.lambda%1@x");
        this.assertReference("lambda_args.lambda%2@x", this.nthIndexOf(src, "x", 4));
        this.assertCall("__builtin__.str.lower", src.indexOf("lower"));
    }

    public void testFunArgs() throws Exception {
        String src = this.index("funargs.py", "def foo(x, y='hi'):", "  z = 9", "  return x + y.upper() + z");
        this.assertFunctionBinding("funargs.foo");
        this.assertParamBinding("funargs.foo@x");
        this.assertReference("funargs.foo@x", this.nthIndexOf(src, "x", 2));
        this.assertParamBinding("funargs.foo@y");
        this.assertStringType("funargs.foo@y");
        this.assertReference("funargs.foo@y", this.nthIndexOf(src, "y", 2));
        this.assertCall("__builtin__.str.upper", src.indexOf("upper"));
        this.assertVariableBinding("funargs.foo&z");
        this.assertReference("funargs.foo&z", this.nthIndexOf(src, "z", 2));
    }

    public void testDatetime() throws Exception {
        String src = this.index("date_time.py", "from datetime import datetime as dt", "import datetime", "now = dt.now()", "d = now.date()", "tz = now.tzinfo");
        this.assertModuleBinding("datetime");
        this.assertClassBinding("datetime.datetime");
        this.assertMethodBinding("datetime.datetime.date");
        this.assertReference("datetime", this.nthIndexOf(src, "datetime", 1));
        this.assertReference("datetime.datetime", this.nthIndexOf(src, "datetime", 2));
        this.assertReference("datetime.datetime", this.nthIndexOf(src, "dt", 1), 2);
        this.assertReference("datetime.datetime", this.nthIndexOf(src, "dt", 2), 2);
        this.assertReference("datetime", this.nthIndexOf(src, "datetime", 3));
        this.assertCall("datetime.datetime.now", this.nthIndexOf(src, "now", 2));
        this.assertCall("datetime.datetime.date", this.nthIndexOf(src, "date()", 1));
        this.assertReference("datetime.time.tzinfo", this.nthIndexOf(src, "tzinfo", 1));
        this.assertBindingType("date_time.tz", "datetime.tzinfo");
    }

    public void testUnpackList() throws Exception {
        this.index("unpacklist.py", "a = [1, 2]", "(b, c) = [3, 4]", "[d, e] = ['hi', 'there']");
        this.assertScopeBinding("unpacklist.a");
        this.assertScopeBinding("unpacklist.b");
        this.assertScopeBinding("unpacklist.c");
        this.assertScopeBinding("unpacklist.d");
        this.assertScopeBinding("unpacklist.e");
        this.assertListType("unpacklist.a", "__builtin__.float");
        this.assertNumType("unpacklist.b");
        this.assertNumType("unpacklist.c");
        this.assertStringType("unpacklist.d");
        this.assertStringType("unpacklist.e");
    }

    public void testStringSlice() throws Exception {
        String src = this.index("slicestring.py", "a = 'hello'[2]", "b = 'hello'[2:4]", "test = 'testing'", "test[-3:].lower()");
        this.assertScopeBinding("slicestring.a");
        this.assertScopeBinding("slicestring.b");
        this.assertStringType("slicestring.a");
        this.assertStringType("slicestring.b");
        this.assertCall("__builtin__.str.lower", src.lastIndexOf("lower"));
    }

    public void testUnionStringSliceTempAttr() throws Exception {
        String src = this.index("tmpattr_slice.py", "def foo(filename):", "  module = filename or '<unknown>'", "  module[-3:].lower()");
        this.assertCall("__builtin__.str.lower", src.lastIndexOf("lower"));
    }

    public void testSelfBinding() throws Exception {
        String src = this.index("selfish.py", "class Foo():", "  def hello(self):", "    print self");
        this.assertClassBinding("selfish.Foo");
        this.assertMethodBinding("selfish.Foo.hello");
        this.assertParamBinding("selfish.Foo.hello@self");
        this.assertDefinition("selfish.Foo.hello@self", this.nthIndexOf(src, "self", 1));
        this.assertReference("selfish.Foo.hello@self", this.nthIndexOf(src, "self", 2));
        this.assertBindingType("selfish.Foo.hello@self", "selfish.Foo");
    }

    public void testInstanceAttrs() throws Exception {
        String src = this.index("attr.py", "class Foo():", "  def __init__(self):", "    self.elts = []", "  def add(self, item):", "    self.elts.append(item)");
        this.assertClassBinding("attr.Foo");
        this.assertConstructorBinding("attr.Foo.__init__");
        this.assertParamBinding("attr.Foo.__init__@self");
        this.assertDefinition("attr.Foo.__init__@self", this.nthIndexOf(src, "self", 1));
        this.assertReference("attr.Foo.__init__@self", this.nthIndexOf(src, "self", 2));
        this.assertBindingType("attr.Foo.__init__@self", "attr.Foo");
        this.assertAttributeBinding("attr.Foo.elts");
        this.assertListType("attr.Foo.elts");
        this.assertMethodBinding("attr.Foo.add");
        this.assertParamBinding("attr.Foo.add@self");
        this.assertBindingType("attr.Foo.add@self", "attr.Foo");
        this.assertParamBinding("attr.Foo.add@item");
        this.assertReference("attr.Foo.add@self", this.nthIndexOf(src, "self", 4));
        this.assertReference("attr.Foo.elts", this.nthIndexOf(src, "elts", 2));
        this.assertCall("__builtin__.list.append", src.indexOf("append"));
        this.assertReference("attr.Foo.add@item", src.lastIndexOf("item"));
    }

    public void testInstanceAttrsWithStdLib() throws Exception {
        this.includeStandardLibrary();
        String src = this.index("dice.py", "import random", "class Dice(object):", "  def __init__(self):", "    self.__random = random.Random()", "  def set_seed(self, seed):", "    self.__random.seed(seed)");
        this.assertModuleBinding("random");
        NBinding r2 = this.assertClassBinding("random.Random");
        IndexerTest.assertFalse((boolean)r2.isBuiltin());
        this.assertReference("random", this.nthIndexOf(src, "random", 3));
        this.assertConstructed("random.Random", src.indexOf("Random"));
        this.assertClassBinding("dice.Dice");
        this.assertReference("__builtin__.object", src.indexOf("object"));
        this.assertConstructorBinding("dice.Dice.__init__");
        this.assertParamBinding("dice.Dice.__init__@self");
        this.assertDefinition("dice.Dice.__init__@self", this.nthIndexOf(src, "self", 1));
        this.assertReference("dice.Dice.__init__@self", this.nthIndexOf(src, "self", 2));
        this.assertBindingType("dice.Dice.__init__@self", "dice.Dice");
        this.assertAttributeBinding("dice.Dice.__random");
        this.assertInstanceType("dice.Dice.__random", "random.Random");
        this.assertMethodBinding("dice.Dice.set_seed");
        this.assertParamBinding("dice.Dice.set_seed@self");
        this.assertBindingType("dice.Dice.set_seed@self", "dice.Dice");
        this.assertParamBinding("dice.Dice.set_seed@seed");
        this.assertReference("dice.Dice.set_seed@self", this.nthIndexOf(src, "self", 4));
        this.assertReference("dice.Dice.__random", this.nthIndexOf(src, "__random", 2));
        this.assertCall("random.Random.seed", this.nthIndexOf(src, "seed", 3));
        this.assertReference("dice.Dice.set_seed@seed", src.lastIndexOf("seed"));
    }

    public void testOsPath() throws Exception {
        String src = this.index("test.py", "from os import path", "print path.devnull", "base, ext = path.split('/foo/bar/baz.py')", "print ext.endswith('py')");
        this.assertReference("os.path.devnull", src.indexOf("devnull"));
        this.assertStringType("os.path.devnull");
        this.assertStringType("test.base");
        this.assertStringType("test.ext");
        this.assertCall("os.path.split", src.indexOf("split"));
        this.assertCall("__builtin__.str.endswith", src.indexOf("endswith"));
    }

    public void testImportOsPath() throws Exception {
        String src = this.index("test.py", "import os.path", "print os.path.devnull");
        this.assertReference("os", this.nthIndexOf(src, "os", 1));
        this.assertReference("os", this.nthIndexOf(src, "os", 2));
        this.assertReference("os.path", this.nthIndexOf(src, "path", 1));
        this.assertReference("os.path", this.nthIndexOf(src, "path", 2));
        this.assertReference("os.path.devnull", src.indexOf("devnull"));
    }

    public void testExceptionsModule() throws Exception {
        String src = this.index("test.py", "import exceptions", "raise exceptions.NotImplementedError");
        this.assertModuleBinding("exceptions");
        this.assertClassBinding("exceptions.NotImplementedError");
        this.assertReference("exceptions.NotImplementedError", src.indexOf("Not"));
    }

    public void testDupFunctionDecl() throws Exception {
        String src = this.index("test.py", "if x:", "  def a(args):", "    print args", "elif y:", "  def a(args):", "    print args");
        this.assertFunctionBinding("test.a");
        this.assertParamBinding("test.a@args");
    }

    public void testResolveExportedNames() throws Exception {
        String src = this.index("test.py", "__all__ = ['foo', 'bar' + 'baz', 'one', 'two']", "def foo(x):", "  return x", "bar = 6", "baz = 7", "barbaz = 8", "one = 'hi'", "two = 'there'");
        this.assertReference("test.foo", src.indexOf("'foo"), 5);
        this.assertReference("test.one", src.indexOf("'one"), 5);
        this.assertReference("test.two", src.indexOf("'two"), 5);
        this.assertNoReference("Should not have referenced 'bar'", "test.bar", src.indexOf("bar"), 3);
    }

    public void testImportFromPlusAssign() throws Exception {
        String src = this.index("test.py", "from os import sep", "os = 10", "print os");
        this.assertModuleBinding("os");
        this.assertReference("os", src.indexOf("os"));
        this.assertNoDefinition("Import-from should not introduce a definition", "test.os", src.indexOf("os"), "os".length());
        this.assertDefinition("test.os", this.nthIndexOf(src, "os", 2));
        this.assertNumType("test.os");
        this.assertReference("test.os", src.lastIndexOf("os"));
    }

    public void testCircularTypeFunAndTuple() throws Exception {
        String src = this.index("test.py", "def foo():", "  return (foo,)");
        this.assertFunctionBinding("test.foo");
        NType ftype = this.idx.lookupQnameType("test.foo");
        IndexerTest.assertTrue((boolean)(ftype instanceof NFuncType));
        NType rtype = ftype.asFuncType().getReturnType();
        IndexerTest.assertTrue((boolean)(rtype instanceof NTupleType));
        IndexerTest.assertEquals((int)1, (int)rtype.asTupleType().getElementTypes().size());
        IndexerTest.assertEquals((Object)ftype, (Object)rtype.asTupleType().getElementTypes().get(0));
        IndexerTest.assertEquals((String)"<FuncType=#1:_:<TupleType:[<#1>]>>", (String)ftype.toString());
    }

    public void testCircularTypeXInOwnList() throws Exception {
        String src = this.index("test.py", "x = (2,)", "y = [x]", "x = y");
        NType xtype = this.idx.lookupQnameType("test.x");
        IndexerTest.assertTrue((boolean)(xtype instanceof NUnionType));
        Set<NType> types = xtype.asUnionType().getTypes();
        IndexerTest.assertEquals((int)2, (int)types.size());
        NType[] array = types.toArray(new NType[2]);
        boolean array0List = array[0] instanceof NListType;
        boolean array1List = array[1] instanceof NListType;
        IndexerTest.assertTrue((array0List || array1List ? 1 : 0) != 0);
        int other = array0List ? 1 : 0;
        IndexerTest.assertTrue((String)("Expected tuple: " + array[other]), (boolean)array[other].isTupleType());
        IndexerTest.assertEquals((int)1, (int)array[other].asTupleType().getElementTypes().size());
        IndexerTest.assertEquals((Object)this.idx.builtins.BaseNum, (Object)array[other].asTupleType().getElementTypes().get(0));
        String s2 = xtype.toString();
        int index = s2.indexOf("<TupleType=#");
        IndexerTest.assertTrue((index != -1 ? 1 : 0) != 0);
        int spot = index + "<TupleType=#".length();
        int num = Integer.parseInt(s2.substring(spot, spot + 1));
        String ttype = "<TupleType=#" + num + ":[<ClassType:float>]>";
        String ref = "<#" + num + ">";
        if (array0List) {
            IndexerTest.assertEquals((String)("<UnionType:[<ListType:" + ttype + ">," + ref + "]>"), (String)s2);
        } else {
            IndexerTest.assertEquals((String)("<UnionType:[" + ttype + ",<ListType:" + ref + ">]>"), (String)s2);
        }
    }

    public void testFunReturn() throws Exception {
        String src = this.index("fret.py", "def foo(x): return x", "a = foo('a')", "b = foo('b')", "c = foo('c')");
        NType ftype = this.idx.lookupQnameType("fret.foo");
        IndexerTest.assertEquals((String)"<FuncType:_:<UnknownType:null>>", (String)ftype.toString());
        NType ctype = this.idx.lookupQnameType("fret.c");
        IndexerTest.assertEquals((Object)ctype.follow(), (Object)ftype.asFuncType().getReturnType());
    }

    public void testListCompForIn() throws Exception {
        String src = this.index("listforin.py", "[line for line in ['foo']]");
        this.assertStringType("listforin.line");
    }

    public void testNoAddToBuiltin() throws Exception {
        String src = this.index("nob.py", "x = [line.rstrip() + '\\n' for line in ['a ']]");
        this.assertStringType("nob.line");
        this.assertCall("__builtin__.str.rstrip", src.indexOf("rstrip"));
        this.assertNoBinding("__builtin__.list.rstrip");
        this.assertListType("nob.x", "__builtin__.str");
    }

    public void testDecoratorSyntax() throws Exception {
        String deco1 = "@deco1";
        String deco2 = "@deco2 ('yargh')";
        String src = this.index("deco.py", deco1, deco2, "def foo(): pass");
        this.assertFunctionBinding("deco.foo");
        NModule m4 = this.idx.getAstForFile("deco.py");
        IndexerTest.assertNotNull((Object)m4);
        NNode obj = (NNode)m4.body.seq.get(0);
        IndexerTest.assertTrue((boolean)(obj instanceof NFunctionDef));
        NFunctionDef f2 = (NFunctionDef)obj;
        List<NNode> decos = f2.getDecoratorList();
        IndexerTest.assertNotNull(decos);
        IndexerTest.assertEquals((int)2, (int)decos.size());
        IndexerTest.assertTrue((boolean)(decos.get(0) instanceof NName));
        NName d1 = (NName)decos.get(0);
        IndexerTest.assertEquals((int)this.nthIndexOf(src, "deco1", 1), (int)d1.start());
        IndexerTest.assertEquals((int)"deco1".length(), (int)d1.length());
        IndexerTest.assertEquals((String)"deco1", (String)d1.id);
        IndexerTest.assertTrue((boolean)(decos.get(1) instanceof NCall));
        NCall d2 = (NCall)decos.get(1);
        IndexerTest.assertTrue((boolean)(d2.func instanceof NName));
        IndexerTest.assertEquals((String)"deco2", (String)((NName)d2.func).id);
    }

    public void testBasicDecoratorSyntax() throws Exception {
        String src = this.index("deco.py", "def deco1(func): print 'hello'; return func", "@deco1()", "def foo(): pass");
        this.assertFunctionBinding("deco.deco1");
        this.assertFunctionBinding("deco.foo");
        this.assertCall("deco.deco1", this.nthIndexOf(src, "deco1", 2));
    }
}

