/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.python.icu.impl.Grego;
import org.python.icu.impl.ICUResource;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.SoftCache;
import org.python.icu.impl.TextTrieMap;
import org.python.icu.impl.ZoneMeta;
import org.python.icu.text.TimeZoneNames;
import org.python.icu.util.TimeZone;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeZoneNamesImpl
extends TimeZoneNames {
    private static final long serialVersionUID = -2179814848495897472L;
    private static final String ZONE_STRINGS_BUNDLE = "zoneStrings";
    private static final String MZ_PREFIX = "meta:";
    private static final TimeZoneNames.NameType[] NAME_TYPE_VALUES = TimeZoneNames.NameType.values();
    private static volatile Set<String> METAZONE_IDS;
    private static final TZ2MZsCache TZ_TO_MZS_CACHE;
    private static final MZ2TZsCache MZ_TO_TZS_CACHE;
    private transient ICUResourceBundle _zoneStrings;
    private transient ConcurrentHashMap<String, ZNames> _mzNamesMap;
    private transient ConcurrentHashMap<String, ZNames> _tzNamesMap;
    private transient boolean _namesFullyLoaded;
    private transient TextTrieMap<NameInfo> _namesTrie;
    private transient boolean _namesTrieFullyLoaded;
    private static final Pattern LOC_EXCLUSION_PATTERN;

    public TimeZoneNamesImpl(ULocale locale) {
        this.initialize(locale);
    }

    @Override
    public Set<String> getAvailableMetaZoneIDs() {
        return TimeZoneNamesImpl._getAvailableMetaZoneIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Set<String> _getAvailableMetaZoneIDs() {
        if (METAZONE_IDS != null) return METAZONE_IDS;
        Class<TimeZoneNamesImpl> clazz = TimeZoneNamesImpl.class;
        synchronized (TimeZoneNamesImpl.class) {
            if (METAZONE_IDS != null) return METAZONE_IDS;
            UResourceBundle bundle = UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt56b", "metaZones");
            UResourceBundle mapTimezones = bundle.get("mapTimezones");
            Set<String> keys = mapTimezones.keySet();
            METAZONE_IDS = Collections.unmodifiableSet(keys);
            // ** MonitorExit[var0] (shouldn't be in output)
            return METAZONE_IDS;
        }
    }

    @Override
    public Set<String> getAvailableMetaZoneIDs(String tzID) {
        return TimeZoneNamesImpl._getAvailableMetaZoneIDs(tzID);
    }

    static Set<String> _getAvailableMetaZoneIDs(String tzID) {
        if (tzID == null || tzID.length() == 0) {
            return Collections.emptySet();
        }
        List maps = (List)TZ_TO_MZS_CACHE.getInstance(tzID, tzID);
        if (maps.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> mzIDs = new HashSet<String>(maps.size());
        for (MZMapEntry map : maps) {
            mzIDs.add(map.mzID());
        }
        return Collections.unmodifiableSet(mzIDs);
    }

    @Override
    public String getMetaZoneID(String tzID, long date) {
        return TimeZoneNamesImpl._getMetaZoneID(tzID, date);
    }

    static String _getMetaZoneID(String tzID, long date) {
        if (tzID == null || tzID.length() == 0) {
            return null;
        }
        String mzID = null;
        List maps = (List)TZ_TO_MZS_CACHE.getInstance(tzID, tzID);
        for (MZMapEntry map : maps) {
            if (date < map.from() || date >= map.to()) continue;
            mzID = map.mzID();
            break;
        }
        return mzID;
    }

    @Override
    public String getReferenceZoneID(String mzID, String region) {
        return TimeZoneNamesImpl._getReferenceZoneID(mzID, region);
    }

    static String _getReferenceZoneID(String mzID, String region) {
        if (mzID == null || mzID.length() == 0) {
            return null;
        }
        String refID = null;
        Map regionTzMap = (Map)MZ_TO_TZS_CACHE.getInstance(mzID, mzID);
        if (!regionTzMap.isEmpty() && (refID = (String)regionTzMap.get(region)) == null) {
            refID = (String)regionTzMap.get("001");
        }
        return refID;
    }

    @Override
    public String getMetaZoneDisplayName(String mzID, TimeZoneNames.NameType type) {
        if (mzID == null || mzID.length() == 0) {
            return null;
        }
        return this.loadMetaZoneNames(null, mzID).getName(type);
    }

    @Override
    public String getTimeZoneDisplayName(String tzID, TimeZoneNames.NameType type) {
        if (tzID == null || tzID.length() == 0) {
            return null;
        }
        return this.loadTimeZoneNames(null, tzID).getName(type);
    }

    @Override
    public String getExemplarLocationName(String tzID) {
        if (tzID == null || tzID.length() == 0) {
            return null;
        }
        String locName = this.loadTimeZoneNames(null, tzID).getName(TimeZoneNames.NameType.EXEMPLAR_LOCATION);
        return locName;
    }

    @Override
    public synchronized Collection<TimeZoneNames.MatchInfo> find(CharSequence text, int start, EnumSet<TimeZoneNames.NameType> nameTypes) {
        if (text == null || text.length() == 0 || start < 0 || start >= text.length()) {
            throw new IllegalArgumentException("bad input text or range");
        }
        NameSearchHandler handler = new NameSearchHandler(nameTypes);
        this._namesTrie.find(text, start, (TextTrieMap.ResultHandler<NameInfo>)handler);
        if (handler.getMaxMatchLen() == text.length() - start || this._namesTrieFullyLoaded) {
            return handler.getMatches();
        }
        this.addAllNamesIntoTrie();
        handler.resetResults();
        this._namesTrie.find(text, start, (TextTrieMap.ResultHandler<NameInfo>)handler);
        if (handler.getMaxMatchLen() == text.length() - start) {
            return handler.getMatches();
        }
        this.internalLoadAllDisplayNames();
        this.addAllNamesIntoTrie();
        Set<String> tzIDs = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL, null, null);
        for (String tzID : tzIDs) {
            if (this._tzNamesMap.containsKey(tzID)) continue;
            tzID = tzID.intern();
            ZNames tznames = ZNames.getInstance(null, tzID);
            tznames.addNamesIntoTrie(null, tzID, this._namesTrie);
            this._tzNamesMap.put(tzID, tznames);
        }
        this._namesTrieFullyLoaded = true;
        handler.resetResults();
        this._namesTrie.find(text, start, (TextTrieMap.ResultHandler<NameInfo>)handler);
        return handler.getMatches();
    }

    @Override
    public synchronized void loadAllDisplayNames() {
        this.internalLoadAllDisplayNames();
    }

    @Override
    public void getDisplayNames(String tzID, TimeZoneNames.NameType[] types, long date, String[] dest, int destOffset) {
        if (tzID == null || tzID.length() == 0) {
            return;
        }
        ZNames tzNames = this.loadTimeZoneNames(null, tzID);
        ZNames mzNames = null;
        for (int i2 = 0; i2 < types.length; ++i2) {
            TimeZoneNames.NameType type = types[i2];
            String name = tzNames.getName(type);
            if (name == null) {
                if (mzNames == null) {
                    String mzID = this.getMetaZoneID(tzID, date);
                    mzNames = mzID == null || mzID.length() == 0 ? ZNames.EMPTY_ZNAMES : this.loadMetaZoneNames(null, mzID);
                }
                name = mzNames.getName(type);
            }
            dest[destOffset + i2] = name;
        }
    }

    private void internalLoadAllDisplayNames() {
        if (!this._namesFullyLoaded) {
            new ZoneStringsLoader().load();
            this._namesFullyLoaded = true;
        }
    }

    private void addAllNamesIntoTrie() {
        for (Map.Entry<String, ZNames> entry : this._tzNamesMap.entrySet()) {
            entry.getValue().addNamesIntoTrie(null, entry.getKey(), this._namesTrie);
        }
        for (Map.Entry<String, ZNames> entry : this._mzNamesMap.entrySet()) {
            entry.getValue().addNamesIntoTrie(entry.getKey(), null, this._namesTrie);
        }
    }

    private void initialize(ULocale locale) {
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt56b/zone", locale);
        this._zoneStrings = (ICUResourceBundle)bundle.get(ZONE_STRINGS_BUNDLE);
        this._tzNamesMap = new ConcurrentHashMap();
        this._mzNamesMap = new ConcurrentHashMap();
        this._namesFullyLoaded = false;
        this._namesTrie = new TextTrieMap(true);
        this._namesTrieFullyLoaded = false;
        TimeZone tz = TimeZone.getDefault();
        String tzCanonicalID = ZoneMeta.getCanonicalCLDRID(tz);
        if (tzCanonicalID != null) {
            this.loadStrings(tzCanonicalID);
        }
    }

    private synchronized void loadStrings(String tzCanonicalID) {
        if (tzCanonicalID == null || tzCanonicalID.length() == 0) {
            return;
        }
        this.loadTimeZoneNames(null, tzCanonicalID);
        ZNamesLoader loader = ZNamesLoader.forMetaZoneNames();
        Set<String> mzIDs = this.getAvailableMetaZoneIDs(tzCanonicalID);
        for (String mzID : mzIDs) {
            this.loadMetaZoneNames(loader, mzID);
        }
        this.addAllNamesIntoTrie();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ULocale locale = this._zoneStrings.getULocale();
        out.writeObject(locale);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ULocale locale = (ULocale)in.readObject();
        this.initialize(locale);
    }

    private synchronized ZNames loadMetaZoneNames(ZNamesLoader loader, String mzID) {
        ZNames znames = this._mzNamesMap.get(mzID);
        if (znames == null) {
            if (loader == null) {
                loader = ZNamesLoader.forMetaZoneNames();
            }
            znames = ZNames.getInstance(loader, this._zoneStrings, MZ_PREFIX + mzID, null);
            mzID = mzID.intern();
            if (this._namesTrieFullyLoaded) {
                znames.addNamesIntoTrie(mzID, null, this._namesTrie);
            }
            this._mzNamesMap.put(mzID, znames);
        }
        return znames;
    }

    private synchronized ZNames loadTimeZoneNames(ZNamesLoader loader, String tzID) {
        ZNames tznames = this._tzNamesMap.get(tzID);
        if (tznames == null) {
            if (loader == null) {
                loader = ZNamesLoader.forTimeZoneNames();
            }
            tznames = ZNames.getInstance(loader, this._zoneStrings, tzID.replace('/', ':'), tzID);
            tzID = tzID.intern();
            if (this._namesTrieFullyLoaded) {
                tznames.addNamesIntoTrie(null, tzID, this._namesTrie);
            }
            this._tzNamesMap.put(tzID, tznames);
        }
        return tznames;
    }

    public static String getDefaultExemplarLocationName(String tzID) {
        if (tzID == null || tzID.length() == 0 || LOC_EXCLUSION_PATTERN.matcher(tzID).matches()) {
            return null;
        }
        String location = null;
        int sep = tzID.lastIndexOf(47);
        if (sep > 0 && sep + 1 < tzID.length()) {
            location = tzID.substring(sep + 1).replace('_', ' ');
        }
        return location;
    }

    static {
        TZ_TO_MZS_CACHE = new TZ2MZsCache();
        MZ_TO_TZS_CACHE = new MZ2TZsCache();
        LOC_EXCLUSION_PATTERN = Pattern.compile("Etc/.*|SystemV/.*|.*/Riyadh8[7-9]");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MZ2TZsCache
    extends SoftCache<String, Map<String, String>, String> {
        private MZ2TZsCache() {
        }

        @Override
        protected Map<String, String> createInstance(String key, String data) {
            Map<String, String> map = null;
            UResourceBundle bundle = UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt56b", "metaZones");
            UResourceBundle mapTimezones = bundle.get("mapTimezones");
            try {
                UResourceBundle regionMap = mapTimezones.get(key);
                Set<String> regions = regionMap.keySet();
                map = new HashMap<String, String>(regions.size());
                for (String region : regions) {
                    String tzID = regionMap.getString(region).intern();
                    map.put(region.intern(), tzID);
                }
            }
            catch (MissingResourceException e2) {
                map = Collections.emptyMap();
            }
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TZ2MZsCache
    extends SoftCache<String, List<MZMapEntry>, String> {
        private TZ2MZsCache() {
        }

        @Override
        protected List<MZMapEntry> createInstance(String key, String data) {
            List<MZMapEntry> mzMaps = null;
            UResourceBundle bundle = UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt56b", "metaZones");
            UResourceBundle metazoneInfoBundle = bundle.get("metazoneInfo");
            String tzkey = data.replace('/', ':');
            try {
                UResourceBundle zoneBundle = metazoneInfoBundle.get(tzkey);
                mzMaps = new ArrayList<MZMapEntry>(zoneBundle.getSize());
                for (int idx = 0; idx < zoneBundle.getSize(); ++idx) {
                    UResourceBundle mz = zoneBundle.get(idx);
                    String mzid = mz.getString(0);
                    String fromStr = "1970-01-01 00:00";
                    String toStr = "9999-12-31 23:59";
                    if (mz.getSize() == 3) {
                        fromStr = mz.getString(1);
                        toStr = mz.getString(2);
                    }
                    long from = TZ2MZsCache.parseDate(fromStr);
                    long to = TZ2MZsCache.parseDate(toStr);
                    mzMaps.add(new MZMapEntry(mzid, from, to));
                }
            }
            catch (MissingResourceException mre) {
                mzMaps = Collections.emptyList();
            }
            return mzMaps;
        }

        private static long parseDate(String text) {
            int n2;
            int idx;
            int year = 0;
            int month = 0;
            int day = 0;
            int hour = 0;
            int min2 = 0;
            for (idx = 0; idx <= 3; ++idx) {
                n2 = text.charAt(idx) - 48;
                if (n2 < 0 || n2 >= 10) {
                    throw new IllegalArgumentException("Bad year");
                }
                year = 10 * year + n2;
            }
            for (idx = 5; idx <= 6; ++idx) {
                n2 = text.charAt(idx) - 48;
                if (n2 < 0 || n2 >= 10) {
                    throw new IllegalArgumentException("Bad month");
                }
                month = 10 * month + n2;
            }
            for (idx = 8; idx <= 9; ++idx) {
                n2 = text.charAt(idx) - 48;
                if (n2 < 0 || n2 >= 10) {
                    throw new IllegalArgumentException("Bad day");
                }
                day = 10 * day + n2;
            }
            for (idx = 11; idx <= 12; ++idx) {
                n2 = text.charAt(idx) - 48;
                if (n2 < 0 || n2 >= 10) {
                    throw new IllegalArgumentException("Bad hour");
                }
                hour = 10 * hour + n2;
            }
            for (idx = 14; idx <= 15; ++idx) {
                n2 = text.charAt(idx) - 48;
                if (n2 < 0 || n2 >= 10) {
                    throw new IllegalArgumentException("Bad minute");
                }
                min2 = 10 * min2 + n2;
            }
            long date = Grego.fieldsToDay(year, month - 1, day) * 86400000L + (long)hour * 3600000L + (long)min2 * 60000L;
            return date;
        }
    }

    private static class MZMapEntry {
        private String _mzID;
        private long _from;
        private long _to;

        MZMapEntry(String mzID, long from, long to) {
            this._mzID = mzID;
            this._from = from;
            this._to = to;
        }

        String mzID() {
            return this._mzID;
        }

        long from() {
            return this._from;
        }

        long to() {
            return this._to;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZNames {
        private static final ZNames EMPTY_ZNAMES = new ZNames(null);
        private static final int EX_LOC_INDEX = TimeZoneNames.NameType.EXEMPLAR_LOCATION.ordinal();
        private String[] _names;
        private boolean didAddIntoTrie;

        protected ZNames(String[] names) {
            this._names = names;
            this.didAddIntoTrie = names == null;
        }

        public static ZNames getInstance(String[] names, String tzID) {
            String locationName;
            if (tzID != null && (names == null || names[EX_LOC_INDEX] == null) && (locationName = TimeZoneNamesImpl.getDefaultExemplarLocationName(tzID)) != null) {
                if (names == null) {
                    names = new String[EX_LOC_INDEX + 1];
                }
                names[ZNames.EX_LOC_INDEX] = locationName;
            }
            if (names == null) {
                return EMPTY_ZNAMES;
            }
            return new ZNames(names);
        }

        public static ZNames getInstance(ZNamesLoader loader, ICUResourceBundle zoneStrings, String key, String tzID) {
            return ZNames.getInstance(loader.load(zoneStrings, key), tzID);
        }

        public String getName(TimeZoneNames.NameType type) {
            if (this._names != null && type.ordinal() < this._names.length) {
                return this._names[type.ordinal()];
            }
            return null;
        }

        public void addNamesIntoTrie(String mzID, String tzID, TextTrieMap<NameInfo> trie) {
            if (this._names == null || this.didAddIntoTrie) {
                return;
            }
            for (int i2 = 0; i2 < this._names.length; ++i2) {
                String name = this._names[i2];
                if (name == null) continue;
                NameInfo info = new NameInfo();
                info.mzID = mzID;
                info.tzID = tzID;
                info.type = NAME_TYPE_VALUES[i2];
                trie.put(name, info);
            }
            this.didAddIntoTrie = true;
        }
    }

    private static final class ZNamesLoader
    extends ICUResource.TableSink {
        private static int NUM_META_ZONE_NAMES = 6;
        private static int NUM_TIME_ZONE_NAMES = 7;
        private static String NO_NAME = "";
        private static ZNamesLoader DUMMY_LOADER = new ZNamesLoader(0);
        private String[] names;
        private int numNames;

        private ZNamesLoader(int numNames) {
            this.numNames = numNames;
        }

        static ZNamesLoader forMetaZoneNames() {
            return new ZNamesLoader(NUM_META_ZONE_NAMES);
        }

        static ZNamesLoader forTimeZoneNames() {
            return new ZNamesLoader(NUM_TIME_ZONE_NAMES);
        }

        String[] load(ICUResourceBundle zoneStrings, String key) {
            if (zoneStrings == null || key == null || key.length() == 0) {
                return null;
            }
            try {
                zoneStrings.getAllTableItemsWithFallback(key, this);
            }
            catch (MissingResourceException e2) {
                return null;
            }
            return this.getNames();
        }

        private static TimeZoneNames.NameType nameTypeFromKey(ICUResource.Key key) {
            if (key.length() != 2) {
                return null;
            }
            char c0 = key.charAt(0);
            char c1 = key.charAt(1);
            if (c0 == 'l') {
                return c1 == 'g' ? TimeZoneNames.NameType.LONG_GENERIC : (c1 == 's' ? TimeZoneNames.NameType.LONG_STANDARD : (c1 == 'd' ? TimeZoneNames.NameType.LONG_DAYLIGHT : null));
            }
            if (c0 == 's') {
                return c1 == 'g' ? TimeZoneNames.NameType.SHORT_GENERIC : (c1 == 's' ? TimeZoneNames.NameType.SHORT_STANDARD : (c1 == 'd' ? TimeZoneNames.NameType.SHORT_DAYLIGHT : null));
            }
            if (c0 == 'e' && c1 == 'c') {
                return TimeZoneNames.NameType.EXEMPLAR_LOCATION;
            }
            return null;
        }

        public void put(ICUResource.Key key, ICUResource.Value value) {
            if (value.getType() == 0) {
                TimeZoneNames.NameType type;
                if (this.names == null) {
                    this.names = new String[this.numNames];
                }
                if ((type = ZNamesLoader.nameTypeFromKey(key)) != null && type.ordinal() < this.numNames && this.names[type.ordinal()] == null) {
                    this.names[type.ordinal()] = value.getString();
                }
            }
        }

        public void putNoFallback(ICUResource.Key key) {
            TimeZoneNames.NameType type;
            if (this.names == null) {
                this.names = new String[this.numNames];
            }
            if ((type = ZNamesLoader.nameTypeFromKey(key)) != null && type.ordinal() < this.numNames && this.names[type.ordinal()] == null) {
                this.names[type.ordinal()] = NO_NAME;
            }
        }

        private String[] getNames() {
            if (this.names == null) {
                return null;
            }
            int length = 0;
            for (int i2 = 0; i2 < this.numNames; ++i2) {
                String name = this.names[i2];
                if (name == null) continue;
                if (name == NO_NAME) {
                    this.names[i2] = null;
                    continue;
                }
                length = i2 + 1;
            }
            if (length == 0) {
                return null;
            }
            if (length == this.numNames || this.numNames == NUM_TIME_ZONE_NAMES) {
                String[] result = this.names;
                this.names = null;
                return result;
            }
            String[] result = new String[length];
            do {
                result[--length] = this.names[length];
                this.names[length] = null;
            } while (length > 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameSearchHandler
    implements TextTrieMap.ResultHandler<NameInfo> {
        private EnumSet<TimeZoneNames.NameType> _nameTypes;
        private Collection<TimeZoneNames.MatchInfo> _matches;
        private int _maxMatchLen;

        NameSearchHandler(EnumSet<TimeZoneNames.NameType> nameTypes) {
            this._nameTypes = nameTypes;
        }

        @Override
        public boolean handlePrefixMatch(int matchLength, Iterator<NameInfo> values) {
            while (values.hasNext()) {
                TimeZoneNames.MatchInfo minfo;
                NameInfo ninfo = values.next();
                if (this._nameTypes != null && !this._nameTypes.contains((Object)ninfo.type)) continue;
                if (ninfo.tzID != null) {
                    minfo = new TimeZoneNames.MatchInfo(ninfo.type, ninfo.tzID, null, matchLength);
                } else {
                    assert (ninfo.mzID != null);
                    minfo = new TimeZoneNames.MatchInfo(ninfo.type, null, ninfo.mzID, matchLength);
                }
                if (this._matches == null) {
                    this._matches = new LinkedList<TimeZoneNames.MatchInfo>();
                }
                this._matches.add(minfo);
                if (matchLength <= this._maxMatchLen) continue;
                this._maxMatchLen = matchLength;
            }
            return true;
        }

        public Collection<TimeZoneNames.MatchInfo> getMatches() {
            if (this._matches == null) {
                return Collections.emptyList();
            }
            return this._matches;
        }

        public int getMaxMatchLen() {
            return this._maxMatchLen;
        }

        public void resetResults() {
            this._matches = null;
            this._maxMatchLen = 0;
        }
    }

    private static class NameInfo {
        String tzID;
        String mzID;
        TimeZoneNames.NameType type;

        private NameInfo() {
        }
    }

    private final class ZoneStringsLoader
    extends ICUResource.TableSink {
        private static final int INITIAL_NUM_ZONES = 300;
        private HashMap<ICUResource.Key, ZNamesLoader> keyToLoader = new HashMap(300);
        private StringBuilder sb = new StringBuilder(32);

        private ZoneStringsLoader() {
        }

        void load() {
            TimeZoneNamesImpl.this._zoneStrings.getAllTableItemsWithFallback("", this);
            for (Map.Entry<ICUResource.Key, ZNamesLoader> entry : this.keyToLoader.entrySet()) {
                ICUResource.Key key = entry.getKey();
                ZNamesLoader loader = entry.getValue();
                if (loader == ZNamesLoader.DUMMY_LOADER) continue;
                if (key.startsWith(TimeZoneNamesImpl.MZ_PREFIX)) {
                    String mzID = this.mzIDFromKey(key).intern();
                    ZNames mzNames = ZNames.getInstance(loader.getNames(), null);
                    TimeZoneNamesImpl.this._mzNamesMap.put(mzID, mzNames);
                    continue;
                }
                String tzID = this.tzIDFromKey(key).intern();
                ZNames tzNames = ZNames.getInstance(loader.getNames(), tzID);
                TimeZoneNamesImpl.this._tzNamesMap.put(tzID, tzNames);
            }
        }

        public ICUResource.TableSink getOrCreateTableSink(ICUResource.Key key, int initialSize) {
            ZNamesLoader loader = this.keyToLoader.get(key);
            if (loader != null) {
                if (loader == ZNamesLoader.DUMMY_LOADER) {
                    return null;
                }
                return loader;
            }
            ZNamesLoader result = null;
            if (key.startsWith(TimeZoneNamesImpl.MZ_PREFIX)) {
                String mzID = this.mzIDFromKey(key);
                if (TimeZoneNamesImpl.this._mzNamesMap.containsKey(mzID)) {
                    loader = ZNamesLoader.DUMMY_LOADER;
                } else {
                    result = loader = ZNamesLoader.forMetaZoneNames();
                }
            } else {
                String tzID = this.tzIDFromKey(key);
                if (TimeZoneNamesImpl.this._tzNamesMap.containsKey(tzID)) {
                    loader = ZNamesLoader.DUMMY_LOADER;
                } else {
                    result = loader = ZNamesLoader.forTimeZoneNames();
                }
            }
            this.keyToLoader.put(key.clone(), loader);
            return result;
        }

        public void putNoFallback(ICUResource.Key key) {
            if (!this.keyToLoader.containsKey(key)) {
                this.keyToLoader.put(key.clone(), ZNamesLoader.DUMMY_LOADER);
            }
        }

        private String mzIDFromKey(ICUResource.Key key) {
            this.sb.setLength(0);
            for (int i2 = TimeZoneNamesImpl.MZ_PREFIX.length(); i2 < key.length(); ++i2) {
                this.sb.append(key.charAt(i2));
            }
            return this.sb.toString();
        }

        private String tzIDFromKey(ICUResource.Key key) {
            this.sb.setLength(0);
            for (int i2 = 0; i2 < key.length(); ++i2) {
                char c2 = key.charAt(i2);
                if (c2 == ':') {
                    c2 = '/';
                }
                this.sb.append(c2);
            }
            return this.sb.toString();
        }
    }
}

