/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import java.nio.ByteBuffer;

public final class ICUResource {

    public static class TableSink {
        public void put(Key key, Value value) {
        }

        public void putNoFallback(Key key) {
        }

        public ArraySink getOrCreateArraySink(Key key, int size) {
            return null;
        }

        public TableSink getOrCreateTableSink(Key key, int initialSize) {
            return null;
        }
    }

    public static class ArraySink {
        public void put(int index, Value value) {
        }

        public ArraySink getOrCreateArraySink(int index, int size) {
            return null;
        }

        public TableSink getOrCreateTableSink(int index, int initialSize) {
            return null;
        }
    }

    public static abstract class Value {
        protected Value() {
        }

        public abstract int getType();

        public abstract String getString();

        public abstract int getInt();

        public abstract int getUInt();

        public abstract int[] getIntVector();

        public abstract ByteBuffer getBinary();

        public String toString() {
            switch (this.getType()) {
                case 0: {
                    return this.getString();
                }
                case 7: {
                    return Integer.toString(this.getInt());
                }
                case 14: {
                    int[] iv = this.getIntVector();
                    StringBuilder sb = new StringBuilder("[");
                    sb.append(iv.length).append("]{");
                    if (iv.length != 0) {
                        sb.append(iv[0]);
                        for (int i2 = 1; i2 < iv.length; ++i2) {
                            sb.append(", ").append(iv[i2]);
                        }
                    }
                    return sb.append('}').toString();
                }
                case 1: {
                    return "(binary blob)";
                }
                case 8: {
                    return "(array)";
                }
                case 2: {
                    return "(table)";
                }
            }
            return "???";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Key
    implements CharSequence,
    Cloneable,
    Comparable<Key> {
        private byte[] bytes;
        private int offset;
        private int length;
        private String s;

        public Key() {
        }

        private Key(byte[] keyBytes, int keyOffset, int keyLength) {
            this.bytes = keyBytes;
            this.offset = keyOffset;
            this.length = keyLength;
        }

        public void setBytes(byte[] keyBytes, int keyOffset) {
            this.bytes = keyBytes;
            this.offset = keyOffset;
            this.length = 0;
            while (keyBytes[keyOffset + this.length] != 0) {
                ++this.length;
            }
            this.s = null;
        }

        public void setToEmpty() {
            this.bytes = null;
            this.length = 0;
            this.offset = 0;
            this.s = null;
        }

        public Key clone() {
            try {
                return (Key)super.clone();
            }
            catch (CloneNotSupportedException cannotOccur) {
                return null;
            }
        }

        @Override
        public char charAt(int i2) {
            assert (0 <= i2 && i2 < this.length);
            return (char)this.bytes[this.offset + i2];
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public Key subSequence(int start, int end) {
            assert (0 <= start && start < this.length);
            assert (start <= end && end <= this.length);
            return new Key(this.bytes, this.offset + start, end - start);
        }

        @Override
        public String toString() {
            if (this.s == null) {
                this.s = this.internalSubString(0, this.length);
            }
            return this.s;
        }

        private String internalSubString(int start, int end) {
            StringBuilder sb = new StringBuilder(end - start);
            for (int i2 = start; i2 < end; ++i2) {
                sb.append((char)this.bytes[this.offset + i2]);
            }
            return sb.toString();
        }

        public String substring(int start) {
            assert (0 <= start && start < this.length);
            return this.internalSubString(start, this.length);
        }

        public String substring(int start, int end) {
            assert (0 <= start && start < this.length);
            assert (start <= end && end <= this.length);
            return this.internalSubString(start, end);
        }

        private boolean regionMatches(byte[] otherBytes, int otherOffset, int n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.bytes[this.offset + i2] == otherBytes[otherOffset + i2]) continue;
                return false;
            }
            return true;
        }

        private boolean regionMatches(int start, CharSequence cs, int n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.bytes[this.offset + start + i2] == cs.charAt(i2)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (other instanceof Key) {
                Key otherKey = (Key)other;
                return this.length == otherKey.length && this.regionMatches(otherKey.bytes, otherKey.offset, this.length);
            }
            return false;
        }

        public boolean contentEquals(CharSequence cs) {
            if (cs == null) {
                return false;
            }
            return this == cs || cs.length() == this.length && this.regionMatches(0, cs, this.length);
        }

        public boolean startsWith(CharSequence cs) {
            int csLength = cs.length();
            return csLength <= this.length && this.regionMatches(0, cs, csLength);
        }

        public boolean endsWith(CharSequence cs) {
            int csLength = cs.length();
            return csLength <= this.length && this.regionMatches(this.length - csLength, cs, csLength);
        }

        public int hashCode() {
            if (this.length == 0) {
                return 0;
            }
            int h2 = this.bytes[this.offset];
            for (int i2 = 1; i2 < this.length; ++i2) {
                h2 = 37 * h2 + this.bytes[this.offset];
            }
            return h2;
        }

        @Override
        public int compareTo(Key other) {
            return this.compareTo((CharSequence)other);
        }

        @Override
        public int compareTo(CharSequence cs) {
            int csLength = cs.length();
            int minLength = this.length <= csLength ? this.length : csLength;
            for (int i2 = 0; i2 < minLength; ++i2) {
                int diff = this.charAt(i2) - cs.charAt(i2);
                if (diff == 0) continue;
                return diff;
            }
            return this.length - csLength;
        }
    }
}

