/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class ExtraMath {
    public static double EPSILON = Math.pow(2.0, -52.0);
    public static double CLOSE = EPSILON * 2.0;

    public static boolean close(double v2, double w2, double tol) {
        if (v2 == w2) {
            return true;
        }
        double scaled = tol * (Math.abs(v2) + Math.abs(w2)) / 2.0;
        return Math.abs(w2 - v2) < scaled;
    }

    public static boolean close(double v2, double w2) {
        return ExtraMath.close(v2, w2, CLOSE);
    }

    public static double closeFloor(double v2) {
        double floor = Math.floor(v2);
        return ExtraMath.close(v2, floor + 1.0) ? floor + 1.0 : floor;
    }

    public static double round(double x2, int n2) {
        if (Double.isNaN(x2) || Double.isInfinite(x2) || x2 == 0.0) {
            return x2;
        }
        float nlog2_10 = 3.3219f * (float)n2;
        int b2 = Math.getExponent(x2);
        if (nlog2_10 > (float)(52 - b2)) {
            return x2;
        }
        if (nlog2_10 < (float)(-(b2 + 2))) {
            return Math.copySign(0.0, x2);
        }
        BigDecimal xx = new BigDecimal(x2);
        BigDecimal rr = xx.setScale(n2, RoundingMode.HALF_UP);
        return rr.doubleValue();
    }
}

