/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.IOException;
import java.io.InputStream;
import org.python.core.io.TextIOBase;

public class TextIOInputStream
extends InputStream {
    private TextIOBase textIO;

    public TextIOInputStream(TextIOBase textIO) {
        this.textIO = textIO;
    }

    @Override
    public int read() throws IOException {
        String result = this.textIO.read(1);
        if (result.length() == 0) {
            return -1;
        }
        return result.charAt(0);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b2.length || len < 0 || off + len > b2.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        String result = this.textIO.read(len);
        len = result.length();
        for (int i2 = 0; i2 < len; ++i2) {
            b2[off + i2] = (byte)result.charAt(i2);
        }
        return len == 0 ? -1 : len;
    }

    @Override
    public void close() throws IOException {
        this.textIO.close();
    }

    @Override
    public long skip(long n2) throws IOException {
        return this.textIO.seek(n2, 1);
    }
}

