/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.StringSubsequenceIterator;
import org.python.core.exceptions;
import org.python.core.util.StringUtil;

public class codecs {
    public static final String BACKSLASHREPLACE = "backslashreplace";
    public static final String IGNORE = "ignore";
    public static final String REPLACE = "replace";
    public static final String XMLCHARREFREPLACE = "xmlcharrefreplace";
    private static char Py_UNICODE_REPLACEMENT_CHARACTER = (char)65533;
    static char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final byte[] utf7_category = new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 3, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 3, 3};
    private static final String B64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final byte[] BASE64_VALUE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -2, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    private static byte[] utf8_code_length = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 0, 0};
    private static char[] hexdigit = "0123456789ABCDEF".toCharArray();

    public static String getDefaultEncoding() {
        return Py.getSystemState().getCodecState().getDefaultEncoding();
    }

    public static void setDefaultEncoding(String encoding) {
        Py.getSystemState().getCodecState().setDefaultEncoding(encoding);
    }

    public static PyObject lookup_error(String handlerName) {
        return Py.getSystemState().getCodecState().lookup_error(handlerName);
    }

    public static void register_error(String name, PyObject error) {
        Py.getSystemState().getCodecState().register_error(name, error);
    }

    public static void register(PyObject search_function) {
        Py.getSystemState().getCodecState().register(search_function);
    }

    public static PyTuple lookup(String encoding) {
        return Py.getSystemState().getCodecState().lookup(encoding);
    }

    private static String normalizestring(String string) {
        return string.toLowerCase().replace(' ', '-');
    }

    public static PyObject decode(PyString v2, String encoding, String errors) {
        PyObject decoder;
        encoding = encoding == null ? codecs.getDefaultEncoding() : codecs.normalizestring(encoding);
        if (errors != null) {
            errors = errors.intern();
        }
        if (encoding.equals("ascii")) {
            return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeASCII(v2.toString(), v2.__len__(), errors));
        }
        try {
            decoder = codecs.lookup(encoding).__getitem__(1);
        }
        catch (PyException ex) {
            if (ex.match(Py.LookupError)) {
                if (encoding.equals("utf-8")) {
                    return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeUTF8(v2.toString(), errors));
                }
                if (encoding.equals("utf-7")) {
                    return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeUTF7(v2.toString(), errors));
                }
                if (encoding.equals("latin-1")) {
                    return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeLatin1(v2.toString(), v2.__len__(), errors));
                }
            }
            throw ex;
        }
        PyObject result = errors != null ? decoder.__call__(v2, (PyObject)new PyString(errors)) : decoder.__call__(v2);
        if (!(result instanceof PyTuple) || result.__len__() != 2) {
            throw Py.TypeError("decoder must return a tuple (object,integer)");
        }
        return result.__getitem__(0);
    }

    private static PyUnicode wrapDecodeResult(String result) {
        return new PyUnicode(result, true);
    }

    public static String encode(PyString v2, String encoding, String errors) {
        PyObject encoder;
        encoding = encoding == null ? codecs.getDefaultEncoding() : codecs.normalizestring(encoding);
        if (errors != null) {
            errors = errors.intern();
        }
        if (encoding.equals("latin-1")) {
            return codecs.PyUnicode_EncodeLatin1(v2.toString(), v2.__len__(), errors);
        }
        if (encoding.equals("ascii")) {
            return codecs.PyUnicode_EncodeASCII(v2.toString(), v2.__len__(), errors);
        }
        try {
            encoder = codecs.lookup(encoding).__getitem__(0);
        }
        catch (PyException ex) {
            if (ex.match(Py.LookupError)) {
                if (encoding.equals("utf-8")) {
                    return codecs.PyUnicode_EncodeUTF8(v2.toString(), errors);
                }
                if (encoding.equals("utf-7")) {
                    return codecs.PyUnicode_EncodeUTF7(v2.toString(), false, false, errors);
                }
            }
            throw ex;
        }
        PyObject result = errors != null ? encoder.__call__(v2, (PyObject)new PyString(errors)) : encoder.__call__(v2);
        if (!(result instanceof PyTuple) || result.__len__() != 2) {
            throw Py.TypeError("encoder must return a tuple (object,integer)");
        }
        PyObject encoded = result.__getitem__(0);
        if (encoded instanceof PyString) {
            return encoded.toString();
        }
        throw Py.TypeError("encoder did not return a string/unicode object (type=" + encoded.getType().fastGetName() + ")");
    }

    public static PyObject strict_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("strict_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (Py.isInstance(exc, Py.UnicodeDecodeError)) {
            throw new PyException(Py.UnicodeDecodeError, exc);
        }
        if (Py.isInstance(exc, Py.UnicodeEncodeError)) {
            throw new PyException(Py.UnicodeEncodeError, exc);
        }
        if (Py.isInstance(exc, Py.UnicodeTranslateError)) {
            throw new PyException(Py.UnicodeTranslateError, exc);
        }
        throw codecs.wrong_exception_type(exc);
    }

    public static PyObject ignore_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("ignore_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (!codecs.isUnicodeError(exc)) {
            throw codecs.wrong_exception_type(exc);
        }
        PyObject end = exc.__getattr__("end");
        return new PyTuple(Py.EmptyUnicode, end);
    }

    private static boolean isUnicodeError(PyObject exc) {
        return Py.isInstance(exc, Py.UnicodeDecodeError) || Py.isInstance(exc, Py.UnicodeEncodeError) || Py.isInstance(exc, Py.UnicodeTranslateError);
    }

    public static PyObject replace_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("replace_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (Py.isInstance(exc, Py.UnicodeEncodeError)) {
            int end = exceptions.getEnd(exc, true);
            return new PyTuple(new PyUnicode("?"), Py.newInteger(end));
        }
        if (Py.isInstance(exc, Py.UnicodeDecodeError)) {
            int end = exceptions.getEnd(exc, false);
            return new PyTuple(new PyUnicode(Py_UNICODE_REPLACEMENT_CHARACTER), Py.newInteger(end));
        }
        if (Py.isInstance(exc, Py.UnicodeTranslateError)) {
            int end = exceptions.getEnd(exc, true);
            return new PyTuple(new PyUnicode(Py_UNICODE_REPLACEMENT_CHARACTER), Py.newInteger(end));
        }
        throw codecs.wrong_exception_type(exc);
    }

    public static PyObject xmlcharrefreplace_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("xmlcharrefreplace_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (!Py.isInstance(exc, Py.UnicodeEncodeError)) {
            throw codecs.wrong_exception_type(exc);
        }
        int start = ((PyInteger)exc.__getattr__("start")).getValue();
        int end = ((PyInteger)exc.__getattr__("end")).getValue();
        String object = exc.__getattr__("object").toString();
        StringBuilder replacement = new StringBuilder();
        codecs.xmlcharrefreplace_internal(start, end, object, replacement);
        return new PyTuple(Py.java2py(replacement.toString()), exc.__getattr__("end"));
    }

    public static StringBuilder xmlcharrefreplace(int start, int end, String toReplace) {
        StringBuilder replacement = new StringBuilder();
        codecs.xmlcharrefreplace_internal(start, end, toReplace, replacement);
        return replacement;
    }

    private static void xmlcharrefreplace_internal(int start, int end, String object, StringBuilder replacement) {
        for (int i2 = start; i2 < end; ++i2) {
            int base;
            int digits;
            replacement.append("&#");
            char cur = object.charAt(i2);
            if (cur < '\n') {
                digits = 1;
                base = 1;
            } else if (cur < 'd') {
                digits = 2;
                base = 10;
            } else if (cur < '\u03e8') {
                digits = 3;
                base = 100;
            } else if (cur < '\u2710') {
                digits = 4;
                base = 1000;
            } else if (cur < '\u186a0') {
                digits = 5;
                base = 10000;
            } else if (cur < '\uf4240') {
                digits = 6;
                base = 100000;
            } else {
                digits = 7;
                base = 1000000;
            }
            while (digits-- > 0) {
                replacement.append((char)(48 + cur / base));
                cur = (char)(cur % base);
                base /= 10;
            }
            replacement.append(';');
        }
    }

    private static PyException wrong_exception_type(PyObject exc) {
        PyObject excClass = exc.__getattr__("__class__");
        PyObject className = excClass.__getattr__("__name__");
        return new PyException(Py.TypeError, "Don't know how to handle " + className + " in error callback");
    }

    public static PyObject backslashreplace_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("backslashreplace_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (!Py.isInstance(exc, Py.UnicodeEncodeError)) {
            throw codecs.wrong_exception_type(exc);
        }
        int start = ((PyInteger)exc.__getattr__("start")).getValue();
        int end = ((PyInteger)exc.__getattr__("end")).getValue();
        String object = exc.__getattr__("object").toString();
        StringBuilder replacement = new StringBuilder();
        codecs.backslashreplace_internal(start, end, object, replacement);
        return new PyTuple(Py.java2py(replacement.toString()), exc.__getattr__("end"));
    }

    public static StringBuilder backslashreplace(int start, int end, String toReplace) {
        StringBuilder replacement = new StringBuilder();
        codecs.backslashreplace_internal(start, end, toReplace, replacement);
        return replacement;
    }

    private static void backslashreplace_internal(int start, int end, String object, StringBuilder replacement) {
        StringSubsequenceIterator iter2 = new StringSubsequenceIterator(object, start, end, 1);
        while (iter2.hasNext()) {
            int c2 = (Integer)iter2.next();
            replacement.append('\\');
            if (c2 >= 65536) {
                replacement.append('U');
                replacement.append(hexdigits[c2 >> 28 & 0xF]);
                replacement.append(hexdigits[c2 >> 24 & 0xF]);
                replacement.append(hexdigits[c2 >> 20 & 0xF]);
                replacement.append(hexdigits[c2 >> 16 & 0xF]);
                replacement.append(hexdigits[c2 >> 12 & 0xF]);
                replacement.append(hexdigits[c2 >> 8 & 0xF]);
            } else if (c2 >= 256) {
                replacement.append('u');
                replacement.append(hexdigits[c2 >> 12 & 0xF]);
                replacement.append(hexdigits[c2 >> 8 & 0xF]);
            } else {
                replacement.append('x');
            }
            replacement.append(hexdigits[c2 >> 4 & 0xF]);
            replacement.append(hexdigits[c2 & 0xF]);
        }
    }

    private static boolean ENCODE_DIRECT(int c2, boolean directO, boolean directWS) {
        if (c2 >= 128 || c2 < 0) {
            return false;
        }
        switch (utf7_category[c2]) {
            case 0: {
                return true;
            }
            case 1: {
                return directWS;
            }
            case 2: {
                return directO;
            }
        }
        return false;
    }

    private static char TO_BASE64(int n2) {
        return B64_CHARS.charAt(n2 & 0x3F);
    }

    private static int FROM_BASE64(int c2) {
        return c2 >= 128 ? -1 : BASE64_VALUE[c2];
    }

    public static String PyUnicode_DecodeUTF7Stateful(String bytes, String errors, int[] consumed) {
        int s2;
        boolean inBase64 = false;
        long base64buffer = 0L;
        int base64bits = 0;
        int startInBytes = 0;
        int syncInBytes = 0;
        int startInUnicode = 0;
        int size = bytes.length();
        StringBuilder unicode = new StringBuilder(size);
        for (s2 = 0; s2 < size; ++s2) {
            char b2 = bytes.charAt(s2);
            if (b2 >= '\u0080') {
                s2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-7", bytes, s2, s2 + 1, "unexpected special character") - 1;
                continue;
            }
            if (inBase64) {
                UTF7Error error;
                int sixBits;
                if (base64bits == 0) {
                    syncInBytes = s2;
                }
                if ((sixBits = codecs.FROM_BASE64(b2)) >= 0) {
                    base64buffer = base64buffer << 6 | (long)sixBits;
                    if ((base64bits += 6) < 32 || (base64bits = codecs.emitCodePoints(unicode, base64buffer, base64bits)) < 32) continue;
                    error = codecs.emitCodePointsDiagnosis(base64buffer, base64bits);
                    s2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-7", bytes, syncInBytes, s2 + 1, error.msg) - 1;
                    base64bits -= 16;
                    continue;
                }
                inBase64 = false;
                if (base64bits > 0) {
                    error = codecs.emitCodePointsDiagnosis(base64buffer, base64bits = codecs.emitCodePoints(unicode, base64buffer, base64bits));
                    if (error != UTF7Error.NONE) {
                        s2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-7", bytes, s2, s2 + 1, error.msg) - 1;
                    }
                    base64bits = 0;
                }
                if (b2 == '-') {
                    if (s2 != startInBytes + 1) continue;
                    unicode.append('+');
                    continue;
                }
                unicode.appendCodePoint(b2);
                continue;
            }
            if (b2 == '+') {
                startInBytes = s2;
                startInUnicode = unicode.length();
                base64bits = 0;
                inBase64 = true;
                continue;
            }
            unicode.appendCodePoint(b2);
        }
        if (inBase64) {
            s2 = startInBytes;
            unicode.setLength(startInUnicode);
        }
        if (consumed != null) {
            consumed[0] = s2;
        } else if (s2 < size) {
            s2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-7", bytes, startInBytes, size, "unterminated shift sequence");
        }
        return unicode.toString();
    }

    public static String PyUnicode_DecodeUTF7(String bytes, String errors) {
        return codecs.PyUnicode_DecodeUTF7Stateful(bytes, errors, null);
    }

    private static int emitCodePoints(StringBuilder v2, long buffer, int n2) {
        while (n2 >= 16) {
            boolean unitIsSurrogate;
            int unit = (int)(buffer >>> n2 - 16);
            boolean bl = unitIsSurrogate = (unit & 0xF800) == 55296;
            if (!unitIsSurrogate) {
                v2.append((char)unit);
                n2 -= 16;
                continue;
            }
            if (n2 >= 32) {
                if ((unit & 0x400) == 0) {
                    int unit2 = (int)(buffer >>> n2 - 32);
                    if ((unit2 & 0xFC00) == 56320) {
                        v2.appendCodePoint(65536 + ((unit & 0x3FF) << 10) + (unit2 & 0x3FF));
                        n2 -= 32;
                        continue;
                    }
                    return n2;
                }
                return n2;
            }
            return n2;
        }
        return n2;
    }

    private static UTF7Error emitCodePointsDiagnosis(long buffer, int n2) {
        if (n2 >= 16) {
            boolean unitIsSurrogate;
            int unit = (int)(buffer >>> n2 - 16);
            boolean bl = unitIsSurrogate = (unit & 0xF800) == 55296;
            if (!unitIsSurrogate) {
                return UTF7Error.NONE;
            }
            if (n2 >= 32) {
                if ((unit & 0x400) == 0) {
                    int unit2 = (int)(buffer >>> n2 - 32) & 0xFFFF;
                    if ((unit2 & 0xFC00) == 56320) {
                        return UTF7Error.NONE;
                    }
                    return UTF7Error.MISSING;
                }
                return UTF7Error.TRAIL;
            }
            if ((unit & 0x400) == 0) {
                return UTF7Error.TRUNCATED;
            }
            return UTF7Error.TRAIL;
        }
        if (n2 >= 6) {
            return UTF7Error.PARTIAL;
        }
        int validBits = (1 << n2) - 1;
        int padding = (int)buffer & validBits;
        if (padding != 0) {
            return UTF7Error.PADDING;
        }
        return UTF7Error.NONE;
    }

    public static String PyUnicode_EncodeUTF7(String unicode, boolean base64SetO, boolean base64WhiteSpace, String errors) {
        boolean inBase64 = false;
        int base64bits = 0;
        long base64buffer = 0L;
        int size = unicode.length();
        StringBuilder v2 = new StringBuilder(size + size / 8 + 10);
        for (int i2 = 0; i2 < size; ++i2) {
            int ch = unicode.charAt(i2);
            if (inBase64) {
                if (codecs.ENCODE_DIRECT(ch, !base64SetO, !base64WhiteSpace)) {
                    codecs.emitBase64Padded(v2, base64buffer, base64bits);
                    inBase64 = false;
                    if (codecs.FROM_BASE64(ch) != -1) {
                        v2.append('-');
                    }
                }
            } else if (ch == 43) {
                v2.append('+');
                ch = 45;
            } else if (!codecs.ENCODE_DIRECT(ch, !base64SetO, !base64WhiteSpace)) {
                v2.append('+');
                inBase64 = true;
                base64bits = 0;
            }
            if (!inBase64) {
                v2.append((char)ch);
                continue;
            }
            if (base64bits > 48) {
                base64bits = codecs.emitBase64(v2, base64buffer, base64bits);
            }
            base64bits += 16;
            base64buffer = (base64buffer << 16) + (long)ch;
        }
        if (inBase64) {
            codecs.emitBase64Padded(v2, base64buffer, base64bits);
            v2.append('-');
        }
        return v2.toString();
    }

    private static int emitBase64(StringBuilder v2, long buffer, int n2) {
        while (n2 >= 6) {
            long sixBits = buffer >>> (n2 -= 6);
            char b64byte = codecs.TO_BASE64((int)sixBits);
            v2.append(b64byte);
        }
        return n2;
    }

    private static void emitBase64Padded(StringBuilder v2, long buffer, int n2) {
        if (n2 > 0) {
            int npad = 5 - (n2 + 5) % 6;
            codecs.emitBase64(v2, buffer << npad, n2 + npad);
        }
    }

    public static String PyUnicode_DecodeUTF8(String str, String errors) {
        return codecs.PyUnicode_DecodeUTF8Stateful(str, errors, null);
    }

    public static String PyUnicode_DecodeUTF8Stateful(String str, String errors, int[] consumed) {
        int size = str.length();
        StringBuilder unicode = new StringBuilder(size);
        int i2 = 0;
        block7: while (i2 < size) {
            int ch = str.charAt(i2);
            if (ch < 128) {
                unicode.append((char)ch);
                ++i2;
                continue;
            }
            if (ch > 255) {
                i2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i2, i2 + 1, "ordinal not in range(255)");
                continue;
            }
            byte n2 = utf8_code_length[ch];
            if (i2 + n2 > size) {
                if (consumed != null) break;
                i2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i2, i2 + 1, "unexpected end of data");
                continue;
            }
            switch (n2) {
                case 0: {
                    i2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i2, i2 + 1, "unexpected code byte");
                    continue block7;
                }
                case 1: {
                    i2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i2, i2 + 1, "internal error");
                    continue block7;
                }
                case 2: {
                    char ch1 = str.charAt(i2 + 1);
                    if ((ch1 & 0xC0) != 128) {
                        i2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i2, i2 + 2, "invalid data");
                        continue block7;
                    }
                    if ((ch = ((ch & 0x1F) << 6) + (ch1 & 0x3F)) < 128) {
                        i2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i2, i2 + 2, "illegal encoding");
                        continue block7;
                    }
                    unicode.appendCodePoint(ch);
                    break;
                }
                case 3: {
                    char ch1 = str.charAt(i2 + 1);
                    char ch2 = str.charAt(i2 + 2);
                    if ((ch1 & 0xC0) != 128 || (ch2 & 0xC0) != 128) {
                        i2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i2, i2 + 3, "invalid data");
                        continue block7;
                    }
                    if ((ch = ((ch & 0xF) << 12) + ((ch1 & 0x3F) << 6) + (ch2 & 0x3F)) < 2048 || ch >= 55296 && ch < 57344) {
                        i2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i2, i2 + 3, "illegal encoding");
                        continue block7;
                    }
                    unicode.appendCodePoint(ch);
                    break;
                }
                case 4: {
                    char ch1 = str.charAt(i2 + 1);
                    char ch2 = str.charAt(i2 + 2);
                    char ch3 = str.charAt(i2 + 3);
                    if ((ch1 & 0xC0) != 128 || (ch2 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                        i2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i2, i2 + 4, "invalid data");
                        continue block7;
                    }
                    if ((ch = ((ch & 7) << 18) + ((ch1 & 0x3F) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F)) < 65536 || ch > 0x10FFFF) {
                        i2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i2, i2 + 4, "illegal encoding");
                        continue block7;
                    }
                    unicode.appendCodePoint(ch);
                    break;
                }
                default: {
                    i2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i2, i2 + n2, "unsupported Unicode code range");
                    continue block7;
                }
            }
            i2 += n2;
        }
        if (consumed != null) {
            consumed[0] = i2;
        }
        return unicode.toString();
    }

    public static String PyUnicode_EncodeUTF8(String str, String errors) {
        return StringUtil.fromBytes(Charset.forName("UTF-8").encode(str));
    }

    public static String PyUnicode_DecodeASCII(String str, int size, String errors) {
        return codecs.PyUnicode_DecodeIntLimited(str, size, errors, "ascii", 128);
    }

    public static String PyUnicode_DecodeLatin1(String str, int size, String errors) {
        return codecs.PyUnicode_DecodeIntLimited(str, size, errors, "latin-1", 256);
    }

    private static String PyUnicode_DecodeIntLimited(String str, int size, String errors, String encoding, int limit) {
        StringBuilder v2 = new StringBuilder(size);
        String reason = "ordinal not in range(" + limit + ")";
        for (int i2 = 0; i2 < size; ++i2) {
            char ch = str.charAt(i2);
            if (ch < limit) {
                v2.append(ch);
                continue;
            }
            i2 = codecs.insertReplacementAndGetResume(v2, errors, encoding, str, i2, i2 + 1, reason) - 1;
        }
        return v2.toString();
    }

    public static String PyUnicode_EncodeASCII(String str, int size, String errors) {
        return codecs.PyUnicode_EncodeIntLimited(str, size, errors, "ascii", 128);
    }

    public static String PyUnicode_EncodeLatin1(String str, int size, String errors) {
        return codecs.PyUnicode_EncodeIntLimited(str, size, errors, "latin-1", 256);
    }

    private static String PyUnicode_EncodeIntLimited(String str, int size, String errors, String encoding, int limit) {
        String reason = "ordinal not in range(" + limit + ")";
        StringBuilder v2 = new StringBuilder(size);
        for (int i2 = 0; i2 < size; ++i2) {
            char ch = str.charAt(i2);
            if (ch >= limit) {
                int nextGood;
                for (nextGood = i2 + 1; nextGood < size && str.charAt(nextGood) >= limit; ++nextGood) {
                }
                if (errors != null) {
                    if (errors.equals(IGNORE)) {
                        i2 = nextGood - 1;
                        continue;
                    }
                    if (errors.equals(REPLACE)) {
                        for (int j2 = i2; j2 < nextGood; ++j2) {
                            v2.append('?');
                        }
                        i2 = nextGood - 1;
                        continue;
                    }
                    if (errors.equals(XMLCHARREFREPLACE)) {
                        v2.append((CharSequence)codecs.xmlcharrefreplace(i2, nextGood, str));
                        i2 = nextGood - 1;
                        continue;
                    }
                    if (errors.equals(BACKSLASHREPLACE)) {
                        v2.append((CharSequence)codecs.backslashreplace(i2, nextGood, str));
                        i2 = nextGood - 1;
                        continue;
                    }
                }
                PyObject replacement = codecs.encoding_error(errors, encoding, str, i2, nextGood, reason);
                String replStr = replacement.__getitem__(0).toString();
                for (int j3 = 0; j3 < replStr.length(); ++j3) {
                    if (replStr.charAt(j3) < limit) continue;
                    throw Py.UnicodeEncodeError(encoding, str, i2 + j3, i2 + j3 + 1, reason);
                }
                v2.append(replStr);
                i2 = codecs.calcNewPosition(size, replacement) - 1;
                continue;
            }
            v2.append(ch);
        }
        return v2.toString();
    }

    public static String PyUnicode_EncodeRawUnicodeEscape(String str, String errors, boolean modifed) {
        StringBuilder v2 = new StringBuilder(str.length());
        Iterator<Integer> iter2 = new PyUnicode(str).newSubsequenceIterator();
        while (iter2.hasNext()) {
            int codePoint = iter2.next();
            if (codePoint >= 65536) {
                v2.append("\\U");
                v2.append(hexdigit[codePoint >> 28 & 0xF]);
                v2.append(hexdigit[codePoint >> 24 & 0xF]);
                v2.append(hexdigit[codePoint >> 20 & 0xF]);
                v2.append(hexdigit[codePoint >> 16 & 0xF]);
                v2.append(hexdigit[codePoint >> 12 & 0xF]);
                v2.append(hexdigit[codePoint >> 8 & 0xF]);
                v2.append(hexdigit[codePoint >> 4 & 0xF]);
                v2.append(hexdigit[codePoint & 0xF]);
                continue;
            }
            if (codePoint >= 256 || modifed && (codePoint == 92 || codePoint == 10)) {
                v2.append("\\u");
                v2.append(hexdigit[codePoint >> 12 & 0xF]);
                v2.append(hexdigit[codePoint >> 8 & 0xF]);
                v2.append(hexdigit[codePoint >> 4 & 0xF]);
                v2.append(hexdigit[codePoint & 0xF]);
                continue;
            }
            v2.append((char)codePoint);
        }
        return v2.toString();
    }

    public static String PyUnicode_DecodeRawUnicodeEscape(String str, String errors) {
        int size = str.length();
        StringBuilder v2 = new StringBuilder(size);
        int i2 = 0;
        while (i2 < size) {
            char ch = str.charAt(i2);
            if (ch != '\\') {
                v2.append(ch);
                ++i2;
                continue;
            }
            int bs = i2;
            while (i2 < size && (ch = str.charAt(i2)) == '\\') {
                v2.append(ch);
                ++i2;
            }
            if ((i2 - bs & 1) == 0 || i2 >= size || ch != 'u' && ch != 'U') continue;
            v2.setLength(v2.length() - 1);
            int count2 = ch == 'u' ? 4 : 8;
            ++i2;
            int codePoint = 0;
            int asDigit = -1;
            for (int j2 = 0; j2 < count2; ++j2) {
                if (i2 == size) {
                    asDigit = -1;
                    break;
                }
                ch = str.charAt(i2);
                asDigit = Character.digit(ch, 16);
                if (asDigit == -1) break;
                codePoint = (codePoint << 4 & 0xFFFFFFF0) + asDigit;
                ++i2;
            }
            if (asDigit == -1) {
                i2 = codecs.insertReplacementAndGetResume(v2, errors, "rawunicodeescape", str, bs, i2, "truncated \\uXXXX");
                continue;
            }
            v2.appendCodePoint(codePoint);
        }
        return v2.toString();
    }

    public static String PyUnicode_EncodePunycode(PyUnicode input, String errors) {
        int n2 = 128;
        int delta = 0;
        int bias = 72;
        int b2 = 0;
        StringBuilder buffer = new StringBuilder();
        for (int c2 : input) {
            if (!Punycode.isBasic(c2)) continue;
            buffer.appendCodePoint(c2);
            ++b2;
        }
        if (b2 > 0) {
            buffer.appendCodePoint(45);
        }
        int h2 = b2;
        int size = input.getCodePointCount();
        while (h2 < size) {
            int m4 = Integer.MAX_VALUE;
            int i2 = 0;
            int codePointIndex = 0;
            for (int c3 : input) {
                if (c3 > n2 && c3 < m4) {
                    m4 = c3;
                    codePointIndex = i2;
                }
                ++i2;
            }
            long guard_delta = delta + (m4 - n2) * (h2 + 1);
            if (guard_delta > Integer.MAX_VALUE) {
                throw Py.UnicodeEncodeError("punycode", input.getString(), codePointIndex, codePointIndex + 1, "overflow");
            }
            delta = (int)guard_delta;
            n2 = m4;
            i2 = 0;
            for (int c3 : input) {
                if (c3 < n2) {
                    guard_delta = delta + 1;
                    if (guard_delta > Integer.MAX_VALUE) {
                        throw Py.UnicodeEncodeError("punycode", input.getString(), i2, i2 + 1, "overflow");
                    }
                    delta = (int)guard_delta;
                }
                if (c3 == n2) {
                    int q2 = delta;
                    int k2 = 36;
                    while (true) {
                        int t2;
                        int n3 = k2 <= bias ? 1 : (t2 = k2 >= bias + 26 ? 26 : k2 - bias);
                        if (q2 < t2) break;
                        buffer.appendCodePoint(t2 + (q2 - t2) % (36 - t2));
                        q2 = (q2 - t2) / (36 - t2);
                        k2 += 36;
                    }
                    buffer.appendCodePoint(q2);
                    bias = Punycode.adapt(delta, h2 + 1, h2 == b2);
                    delta = 0;
                    ++h2;
                }
                ++i2;
            }
            ++delta;
            ++n2;
        }
        return buffer.toString();
    }

    public static PyUnicode PyUnicode_DecodePunycode(String input, String errors) {
        int j2;
        int input_size = input.length();
        int output_size = 0;
        ArrayList<Integer> ucs4 = new ArrayList<Integer>(input_size);
        for (j2 = 0; j2 < input_size; ++j2) {
            char c2 = input.charAt(j2);
            if (!Punycode.isBasic(c2)) {
                throw Py.UnicodeDecodeError("punycode", input, j2, j2 + 1, "not basic");
            }
            if (c2 == '-') break;
            ucs4.add(Integer.valueOf(c2));
            ++output_size;
        }
        int n2 = 128;
        int i2 = 0;
        int bias = 72;
        while (j2 < input_size) {
            int old_i = i2;
            int w2 = 1;
            int k2 = 36;
            while (true) {
                int t2;
                char c3;
                int digit;
                long guard_i;
                if ((guard_i = (long)(i2 + (digit = (c3 = input.charAt(j2++)) - 48) * w2)) > Integer.MAX_VALUE) {
                    throw Py.UnicodeDecodeError("punycode", input, j2, j2 + 1, "overflow");
                }
                i2 = (int)guard_i;
                int n3 = k2 <= bias ? 1 : (t2 = k2 >= bias + 26 ? 26 : k2 - bias);
                if (digit < t2) break;
                long guard_w = w2 * 36 - t2;
                if (guard_w > Integer.MAX_VALUE) {
                    throw Py.UnicodeDecodeError("punycode", input, j2, j2 + 1, "overflow");
                }
                k2 += 36;
            }
            bias = Punycode.adapt(i2 - old_i, output_size + 1, old_i == 0);
            n2 += i2 / (output_size + 1);
            ucs4.add(i2 %= output_size + 1, n2);
        }
        return new PyUnicode(ucs4);
    }

    public static String PyUnicode_EncodeIDNA(PyUnicode input, String errors) {
        throw new UnsupportedOperationException();
    }

    public static PyUnicode PyUnicode_DecodeIDNA(String input, String errors) {
        throw new UnsupportedOperationException();
    }

    public static PyObject encoding_error(String errors, String encoding, String toEncode, int start, int end, String reason) {
        PyObject errorHandler = codecs.lookup_error(errors);
        PyException exc = Py.UnicodeEncodeError(encoding, toEncode, start, end, reason);
        exc.normalize();
        PyObject replacement = errorHandler.__call__(new PyObject[]{exc.value});
        codecs.checkErrorHandlerReturn(errors, replacement);
        return replacement;
    }

    public static int insertReplacementAndGetResume(StringBuilder partialDecode, String errors, String encoding, String toDecode, int start, int end, String reason) {
        if (errors != null) {
            if (errors.equals(IGNORE)) {
                return end;
            }
            if (errors.equals(REPLACE)) {
                partialDecode.appendCodePoint(Py_UNICODE_REPLACEMENT_CHARACTER);
                return end;
            }
        }
        PyObject replacementSpec = codecs.decoding_error(errors, encoding, toDecode, start, end, reason);
        partialDecode.append(replacementSpec.__getitem__(0).toString());
        return codecs.calcNewPosition(toDecode.length(), replacementSpec);
    }

    public static PyObject decoding_error(String errors, String encoding, String toDecode, int start, int end, String reason) {
        PyObject errorHandler = codecs.lookup_error(errors);
        PyException exc = Py.UnicodeDecodeError(encoding, toDecode, start, end, reason);
        exc.normalize();
        PyObject replacementSpec = errorHandler.__call__(new PyObject[]{exc.value});
        codecs.checkErrorHandlerReturn(errors, replacementSpec);
        return replacementSpec;
    }

    private static void checkErrorHandlerReturn(String errors, PyObject replacementSpec) {
        if (!(replacementSpec instanceof PyTuple && replacementSpec.__len__() == 2 && replacementSpec.__getitem__(0) instanceof PyBaseString && replacementSpec.__getitem__(1) instanceof PyInteger)) {
            throw new PyException(Py.TypeError, "error_handler " + errors + " must return a tuple of (replacement, new position)");
        }
    }

    public static int calcNewPosition(int size, PyObject errorTuple) {
        int newPosition = ((PyInteger)errorTuple.__getitem__(1)).getValue();
        if (newPosition < 0) {
            newPosition = size + newPosition;
        }
        if (newPosition > size || newPosition < 0) {
            throw Py.IndexError(newPosition + " out of bounds of encoded string");
        }
        return newPosition;
    }

    public static class CodecState {
        private PyList searchPath = new PyList();
        private PyStringMap searchCache = new PyStringMap();
        private PyStringMap errorHandlers = new PyStringMap();
        private String default_encoding = "ascii";
        public static final String[] BUILTIN_ERROR_HANDLERS = new String[]{"strict", "ignore", "replace", "xmlcharrefreplace", "backslashreplace"};

        public CodecState() {
            for (String builtinErrorHandler : BUILTIN_ERROR_HANDLERS) {
                this.register_error(builtinErrorHandler, Py.newJavaFunc(codecs.class, builtinErrorHandler + "_errors"));
            }
        }

        public String getDefaultEncoding() {
            return this.default_encoding;
        }

        public void setDefaultEncoding(String encoding) {
            this.lookup(encoding);
            this.default_encoding = encoding;
        }

        public void register_error(String name, PyObject error) {
            if (!error.isCallable()) {
                throw Py.TypeError("argument must be callable");
            }
            this.errorHandlers.__setitem__(name.intern(), error);
        }

        public void register(PyObject search_function) {
            if (!search_function.isCallable()) {
                throw Py.TypeError("argument must be callable");
            }
            this.searchPath.append(search_function);
        }

        public PyTuple lookup(String encoding) {
            PyString v2 = new PyString(codecs.normalizestring(encoding));
            PyObject cached = this.searchCache.__finditem__(v2);
            if (cached != null) {
                return (PyTuple)cached;
            }
            if (this.searchPath.__len__() == 0) {
                throw new PyException(Py.LookupError, "no codec search functions registered: can't find encoding '" + encoding + "'");
            }
            for (PyObject func : this.searchPath.asIterable()) {
                PyObject created = func.__call__(v2);
                if (created == Py.None) continue;
                if (!(created instanceof PyTuple) || created.__len__() != 4) {
                    throw Py.TypeError("codec search functions must return 4-tuples");
                }
                this.searchCache.__setitem__(v2, created);
                return (PyTuple)created;
            }
            throw new PyException(Py.LookupError, "unknown encoding '" + encoding + "'");
        }

        public PyObject lookup_error(String handlerName) {
            PyObject handler;
            if (handlerName == null) {
                handlerName = "strict";
            }
            if ((handler = this.errorHandlers.__finditem__(handlerName.intern())) == null) {
                throw new PyException(Py.LookupError, "unknown error handler name '" + handlerName + "'");
            }
            return handler;
        }
    }

    private static class Punycode {
        private static final int BASE = 36;
        private static final int TMIN = 1;
        private static final int TMAX = 26;
        private static final int SKEW = 38;
        private static final int DAMP = 700;
        private static final int INITIAL_BIAS = 72;
        private static final int INITIAL_N = 128;
        private static final int BASIC = 128;

        private Punycode() {
        }

        private static int adapt(int delta, int numpoints, boolean firsttime) {
            delta = firsttime ? delta / 700 : delta >> 1;
            delta += delta / numpoints;
            int k2 = 0;
            while (delta > 455) {
                delta /= 35;
                k2 += 36;
            }
            return k2 + 36 * delta / (delta + 38);
        }

        private static boolean isBasic(int codePoint) {
            return codePoint < 128;
        }
    }

    static enum UTF7Error {
        NONE("No error"),
        PADDING("non-zero padding bits in shift sequence"),
        PARTIAL("partial character in shift sequence"),
        TRUNCATED("second surrogate missing at end of shift sequence"),
        MISSING("second surrogate missing"),
        TRAIL("unexpected second surrogate");

        final String msg;

        private UTF7Error(String msg) {
            this.msg = msg;
        }
    }
}

