/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyFloat;
import org.python.core.PyObject;
import org.python.core.Untraversable;
import org.python.core.util.ExtraMath;

@Untraversable
class RoundFunction
extends PyBuiltinFunction {
    RoundFunction() {
        super("round", "round(number[, ndigits]) -> floating point number\n\nRound a number to a given precision in decimal digits (default 0 digits).\nThis always returns a floating point number.  Precision may be negative.");
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("round", args, kwds, new String[]{"number", "ndigits"}, 0);
        PyObject number = ap.getPyObject(0);
        int ndigits = ap.getIndex(1, 0);
        double x2 = number.asDouble();
        double r2 = ExtraMath.round(x2, ndigits);
        if (Double.isInfinite(r2) && !Double.isInfinite(x2)) {
            throw Py.OverflowError("rounded value too large to represent");
        }
        return new PyFloat(r2);
    }
}

