/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyString;
import org.python.core.ReflectedArgs;
import org.python.core.ReflectedCallData;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.util.Generic;

public class PyReflectedFunction
extends PyObject
implements Traverseproc {
    public String __name__;
    public PyObject __doc__ = Py.None;
    public ReflectedArgs[] argslist = new ReflectedArgs[1];
    public int nargs;
    private boolean calledStatically;

    protected PyReflectedFunction(String name) {
        this.__name__ = name;
    }

    public PyReflectedFunction(Method ... methods) {
        this(methods[0].getName());
        for (Method meth : methods) {
            this.addMethod(meth);
        }
        if (this.nargs == 0) {
            String msg = String.format("Attempted to make Java method visible, but it isn't callable[method=%s, class=%s]", methods[0].getName(), methods[0].getDeclaringClass());
            throw Py.SystemError(msg);
        }
    }

    @Override
    public PyObject _doget(PyObject container) {
        return this._doget(container, null);
    }

    @Override
    public PyObject _doget(PyObject container, PyObject wherefound) {
        if (container == null) {
            return this.calledStatically ? this : this.copyWithCalledStatically(true);
        }
        return new PyMethod(this.calledStatically ? this.copyWithCalledStatically(false) : this, container, wherefound);
    }

    private ReflectedArgs makeArgs(Method m4) {
        return new ReflectedArgs(m4, m4.getParameterTypes(), m4.getDeclaringClass(), Modifier.isStatic(m4.getModifiers()), m4.isVarArgs());
    }

    public PyReflectedFunction copy() {
        PyReflectedFunction func = new PyReflectedFunction(this.__name__);
        func.__doc__ = this.__doc__;
        func.nargs = this.nargs;
        func.argslist = new ReflectedArgs[this.nargs];
        System.arraycopy(this.argslist, 0, func.argslist, 0, this.nargs);
        return func;
    }

    private PyReflectedFunction copyWithCalledStatically(boolean calledStatically) {
        PyReflectedFunction copy = this.copy();
        copy.calledStatically = calledStatically;
        return copy;
    }

    public boolean handles(Method method) {
        return this.handles(this.makeArgs(method));
    }

    protected boolean handles(ReflectedArgs args) {
        for (int i2 = 0; i2 < this.nargs; ++i2) {
            int cmp = args.compareTo(this.argslist[i2]);
            if (cmp == 0) {
                return true;
            }
            if (cmp != 1) continue;
            return false;
        }
        return false;
    }

    public void addMethod(Method m4) {
        if (!Modifier.isPublic(m4.getModifiers()) && Options.respectJavaAccessibility) {
            return;
        }
        if (PyReflectedFunction.isPackagedProtected(m4.getDeclaringClass())) {
            try {
                m4.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.addArgs(this.makeArgs(m4));
    }

    public static boolean isPackagedProtected(Class<?> c2) {
        int mods = c2.getModifiers();
        return !Modifier.isPublic(mods) && !Modifier.isPrivate(mods) && !Modifier.isProtected(mods);
    }

    protected void addArgs(ReflectedArgs args) {
        int nn;
        int i2;
        for (i2 = 0; i2 < this.nargs; ++i2) {
            int cmp = args.compareTo(this.argslist[i2]);
            if (cmp == 0) {
                return;
            }
            if (cmp == 1998) {
                this.argslist[i2] = args;
                return;
            }
            if (cmp == -1) break;
        }
        if ((nn = this.nargs + 1) > this.argslist.length) {
            ReflectedArgs[] newargslist = new ReflectedArgs[nn + 2];
            System.arraycopy(this.argslist, 0, newargslist, 0, this.nargs);
            this.argslist = newargslist;
        }
        for (int j2 = this.nargs; j2 > i2; --j2) {
            this.argslist[j2] = this.argslist[j2 - 1];
        }
        this.argslist[i2] = args;
        this.nargs = nn;
    }

    @Override
    public PyObject __call__(PyObject self, PyObject[] args, String[] keywords) {
        Object o2;
        ReflectedCallData callData = new ReflectedCallData();
        ReflectedArgs match = null;
        for (int i2 = 0; i2 < this.nargs && match == null; ++i2) {
            if (!this.argslist[i2].matches(self, args, keywords, callData)) continue;
            match = this.argslist[i2];
        }
        if (match == null) {
            this.throwError(callData.errArg, args.length, self != null, keywords.length != 0);
        }
        Object cself = callData.self;
        Method m4 = (Method)match.data;
        if (self == null && cself != null && cself instanceof PyProxy && !this.__name__.startsWith("super__") && match.declaringClass != cself.getClass()) {
            String mname = "super__" + this.__name__;
            try {
                m4 = cself.getClass().getMethod(mname, m4.getParameterTypes());
            }
            catch (Exception e2) {
                throw Py.JavaError(e2);
            }
        }
        try {
            o2 = m4.invoke(cself, callData.getArgsArray());
        }
        catch (Throwable t2) {
            throw Py.JavaError(t2);
        }
        return Py.java2py(o2);
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        PyObject self;
        if (this.calledStatically) {
            self = null;
        } else {
            PyObject[] unboundArgs = new PyObject[args.length - 1];
            System.arraycopy(args, 1, unboundArgs, 0, unboundArgs.length);
            self = args[0];
            args = unboundArgs;
        }
        return this.__call__(self, args, keywords);
    }

    protected void throwError(String message) {
        throw Py.TypeError(this.__name__ + "(): " + message);
    }

    private static void addRange(StringBuilder buf, int min2, int max, String sep) {
        if (buf.length() > 0) {
            buf.append(sep);
        }
        if (min2 < max) {
            buf.append(Integer.toString(min2)).append('-').append(max);
        } else {
            buf.append(min2);
        }
    }

    protected void throwArgCountError(int nArgs, boolean self) {
        boolean[] legalArgs = new boolean[40];
        int maxArgs = -1;
        int minArgs = 40;
        for (int i2 = 0; i2 < this.nargs; ++i2) {
            ReflectedArgs rargs = this.argslist[i2];
            int l2 = rargs.args.length;
            if (!self && !rargs.isStatic) {
                ++l2;
            }
            legalArgs[l2] = true;
            if (l2 > maxArgs) {
                maxArgs = l2;
            }
            if (l2 >= minArgs) continue;
            minArgs = l2;
        }
        StringBuilder buf = new StringBuilder();
        int startRange = minArgs;
        int a2 = minArgs + 1;
        block1: while (a2 < maxArgs) {
            if (legalArgs[a2]) {
                ++a2;
                continue;
            }
            PyReflectedFunction.addRange(buf, startRange, a2 - 1, ", ");
            ++a2;
            while (a2 <= maxArgs) {
                if (legalArgs[a2]) {
                    startRange = a2;
                    continue block1;
                }
                ++a2;
            }
        }
        PyReflectedFunction.addRange(buf, startRange, maxArgs, " or ");
        this.throwError("expected " + buf + " args; got " + nArgs);
    }

    private static String ordinal(int n2) {
        switch (n2 + 1) {
            case 0: {
                return "self";
            }
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
            case 3: {
                return "3rd";
            }
        }
        return Integer.toString(n2 + 1) + "th";
    }

    private static String niceName(Class<?> arg) {
        if (arg == String.class || arg == PyString.class) {
            return "String";
        }
        if (arg.isArray()) {
            return PyReflectedFunction.niceName(arg.getComponentType()) + "[]";
        }
        return arg.getName();
    }

    protected void throwBadArgError(int errArg, int nArgs, boolean self) {
        Set<Class<?>> argTypes = Generic.set();
        for (int i2 = 0; i2 < this.nargs; ++i2) {
            if (this.argslist[i2].args.length != nArgs && (this.argslist[i2].isStatic || self || this.argslist[i2].args.length != nArgs - 1)) continue;
            if (errArg == -1) {
                argTypes.add(this.argslist[i2].declaringClass);
                continue;
            }
            argTypes.add(this.argslist[i2].args[errArg]);
        }
        StringBuilder buf = new StringBuilder();
        for (Class clazz : argTypes) {
            buf.append(PyReflectedFunction.niceName(clazz));
            buf.append(", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        this.throwError(PyReflectedFunction.ordinal(errArg) + " arg can't be coerced to " + buf);
    }

    protected void throwError(int errArg, int nArgs, boolean self, boolean keywords) {
        if (keywords) {
            this.throwError("takes no keyword arguments");
        } else if (errArg == -2) {
            this.throwArgCountError(nArgs, self);
        } else {
            this.throwBadArgError(errArg, nArgs, self);
        }
    }

    public void printArgs() {
        System.err.println("nargs: " + this.nargs);
        for (int i2 = 0; i2 < this.nargs; ++i2) {
            ReflectedArgs args = this.argslist[i2];
            System.err.println(args.toString());
        }
    }

    @Override
    public String toString() {
        return "<java function " + this.__name__ + " " + Py.idstr(this) + ">";
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        return this.__doc__ != null ? visit.visit(this.__doc__, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && ob == this.__doc__;
    }
}

