/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import junit.framework.TestCase;
import org.junit.Assert;
import org.python.core.PyArray;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;

public class PyArrayTest
extends TestCase {
    public void testSetSliceNegativeStep() {
        PyArray arrayToModify = new PyArray(PyString.class, new String[]{"a", "b", "c", "d"});
        PyArray arrayOneElement = new PyArray(PyString.class, new String[]{"z"});
        arrayToModify.setslice(0, 0, -1, arrayOneElement);
        PyArrayTest.assertEquals((Object)new PyArray(PyString.class, new String[]{"z", "b", "c", "d"}), (Object)arrayToModify);
        arrayToModify = new PyArray(PyString.class, new String[]{"a", "b", "c", "d"});
        PyArray arrayThreeElements = new PyArray(PyString.class, new String[]{"x", "y", "z"});
        arrayToModify.setslice(2, 0, -1, arrayThreeElements);
        PyArrayTest.assertEquals((Object)new PyArray(PyString.class, new String[]{"z", "y", "x", "d"}), (Object)arrayToModify);
        arrayToModify = new PyArray(PyString.class, new String[]{"a", "b", "c", "d"});
        PyArray arrayTwoElements = new PyArray(PyString.class, new String[]{"x", "y"});
        arrayToModify.setslice(3, 0, -2, arrayTwoElements);
        PyArrayTest.assertEquals((Object)new PyArray(PyString.class, new String[]{"a", "y", "c", "x"}), (Object)arrayToModify);
    }

    public void testSetSlicePositiveStep() {
        PyArray arrayToModify = new PyArray(PyString.class, new String[]{"a", "b", "c", "d"});
        PyArray arrayOneElement = new PyArray(PyString.class, new String[]{"z"});
        arrayToModify.setslice(0, 1, 1, arrayOneElement);
        PyArrayTest.assertEquals((Object)new PyArray(PyString.class, new String[]{"z", "b", "c", "d"}), (Object)arrayToModify);
        arrayToModify = new PyArray(PyString.class, new String[]{"a", "b", "c", "d"});
        PyArray arrayMultipleElements = new PyArray(PyString.class, new String[]{"x", "y"});
        arrayToModify.setslice(1, 3, 1, arrayMultipleElements);
        PyArrayTest.assertEquals((Object)new PyArray(PyString.class, new String[]{"a", "x", "y", "d"}), (Object)arrayToModify);
        arrayToModify = new PyArray(PyString.class, new String[]{"a", "b", "c", "d"});
        arrayMultipleElements = new PyArray(PyString.class, new String[]{"x", "y"});
        arrayToModify.setslice(0, 3, 2, arrayMultipleElements);
        PyArrayTest.assertEquals((Object)new PyArray(PyString.class, new String[]{"x", "b", "y", "d"}), (Object)arrayToModify);
    }

    public void testCompactArray() {
        PythonInterpreter interp = new PythonInterpreter();
        interp.set("arr", new double[3]);
        interp.exec("arr.append(3.0)\n\n");
        Object o2 = interp.get("arr", Object.class);
        double[] a2 = (double[])o2;
        PyArrayTest.assertEquals((int)4, (int)a2.length);
        PyArrayTest.assertEquals((Object)0.0, (Object)a2[0]);
        PyArrayTest.assertEquals((Object)3.0, (Object)a2[3]);
    }

    public void testToJava() {
        PythonInterpreter interp = new PythonInterpreter();
        PyObject pyobj = interp.eval("[i * 2 for i in xrange(5)]");
        Assert.assertArrayEquals((int[])new int[]{0, 2, 4, 6, 8}, (int[])((int[])pyobj.__tojava__(int[].class)));
        Assert.assertArrayEquals((Object[])new Integer[]{0, 2, 4, 6, 8}, (Object[])((Object[])pyobj.__tojava__(Object[].class)));
    }
}

