/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.operator.jcajce;

import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.crypto.Cipher;
import org.python.bouncycastle.asn1.cms.GenericHybridParameters;
import org.python.bouncycastle.asn1.cms.RsaKemParameters;
import org.python.bouncycastle.asn1.iso.ISOIECObjectIdentifiers;
import org.python.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.python.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.python.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.python.bouncycastle.crypto.util.DEROtherInfo;
import org.python.bouncycastle.jcajce.spec.KTSParameterSpec;
import org.python.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.python.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.python.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.python.bouncycastle.operator.AsymmetricKeyWrapper;
import org.python.bouncycastle.operator.GenericKey;
import org.python.bouncycastle.operator.OperatorException;
import org.python.bouncycastle.operator.jcajce.JceSymmetricKeyWrapper;
import org.python.bouncycastle.operator.jcajce.OperatorHelper;
import org.python.bouncycastle.operator.jcajce.OperatorUtils;
import org.python.bouncycastle.util.Arrays;

public class JceKTSKeyWrapper
extends AsymmetricKeyWrapper {
    private final String symmetricWrappingAlg;
    private final int keySizeInBits;
    private final byte[] partyUInfo;
    private final byte[] partyVInfo;
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private PublicKey publicKey;
    private SecureRandom random;

    public JceKTSKeyWrapper(PublicKey publicKey, String string, int n2, byte[] byArray, byte[] byArray2) {
        super(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_rsa_KEM, new GenericHybridParameters(new AlgorithmIdentifier(ISOIECObjectIdentifiers.id_kem_rsa, new RsaKemParameters(new AlgorithmIdentifier(X9ObjectIdentifiers.id_kdf_kdf3, new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256)), (n2 + 7) / 8)), JceSymmetricKeyWrapper.determineKeyEncAlg(string, n2))));
        this.publicKey = publicKey;
        this.symmetricWrappingAlg = string;
        this.keySizeInBits = n2;
        this.partyUInfo = Arrays.clone(byArray);
        this.partyVInfo = Arrays.clone(byArray2);
    }

    public JceKTSKeyWrapper(X509Certificate x509Certificate, String string, int n2, byte[] byArray, byte[] byArray2) {
        this(x509Certificate.getPublicKey(), string, n2, byArray, byArray2);
    }

    public JceKTSKeyWrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKTSKeyWrapper setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public JceKTSKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        Cipher cipher = this.helper.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm(), new HashMap());
        try {
            DEROtherInfo dEROtherInfo = new DEROtherInfo.Builder(JceSymmetricKeyWrapper.determineKeyEncAlg(this.symmetricWrappingAlg, this.keySizeInBits), this.partyUInfo, this.partyVInfo).build();
            KTSParameterSpec kTSParameterSpec = new KTSParameterSpec.Builder(this.symmetricWrappingAlg, this.keySizeInBits, dEROtherInfo.getEncoded()).build();
            cipher.init(3, (Key)this.publicKey, kTSParameterSpec, this.random);
            return cipher.wrap(OperatorUtils.getJceKey(genericKey));
        }
        catch (Exception exception) {
            throw new OperatorException("Unable to wrap contents key: " + exception.getMessage(), exception);
        }
    }
}

