/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.tls;

import java.io.IOException;
import org.python.bouncycastle.crypto.Digest;
import org.python.bouncycastle.crypto.tls.TlsCipher;
import org.python.bouncycastle.crypto.tls.TlsContext;
import org.python.bouncycastle.crypto.tls.TlsFatalAlert;
import org.python.bouncycastle.crypto.tls.TlsMac;
import org.python.bouncycastle.crypto.tls.TlsUtils;
import org.python.bouncycastle.util.Arrays;

public class TlsNullCipher
implements TlsCipher {
    protected TlsContext context;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsNullCipher(TlsContext tlsContext) {
        this.context = tlsContext;
        this.writeMac = null;
        this.readMac = null;
    }

    public TlsNullCipher(TlsContext tlsContext, Digest digest, Digest digest2) throws IOException {
        if (digest == null != (digest2 == null)) {
            throw new TlsFatalAlert(80);
        }
        this.context = tlsContext;
        TlsMac tlsMac = null;
        TlsMac tlsMac2 = null;
        if (digest != null) {
            int n2 = digest.getDigestSize() + digest2.getDigestSize();
            byte[] byArray = TlsUtils.calculateKeyBlock(tlsContext, n2);
            int n3 = 0;
            tlsMac = new TlsMac(tlsContext, digest, byArray, n3, digest.getDigestSize());
            tlsMac2 = new TlsMac(tlsContext, digest2, byArray, n3 += digest.getDigestSize(), digest2.getDigestSize());
            if ((n3 += digest2.getDigestSize()) != n2) {
                throw new TlsFatalAlert(80);
            }
        }
        if (tlsContext.isServer()) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
        }
    }

    public int getPlaintextLimit(int n2) {
        int n3 = n2;
        if (this.writeMac != null) {
            n3 -= this.writeMac.getSize();
        }
        return n3;
    }

    public byte[] encodePlaintext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        if (this.writeMac == null) {
            return Arrays.copyOfRange(byArray, n2, n2 + n3);
        }
        byte[] byArray2 = this.writeMac.calculateMac(l2, s2, byArray, n2, n3);
        byte[] byArray3 = new byte[n3 + byArray2.length];
        System.arraycopy(byArray, n2, byArray3, 0, n3);
        System.arraycopy(byArray2, 0, byArray3, n3, byArray2.length);
        return byArray3;
    }

    public byte[] decodeCiphertext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        byte[] byArray2;
        if (this.readMac == null) {
            return Arrays.copyOfRange(byArray, n2, n2 + n3);
        }
        int n4 = this.readMac.getSize();
        if (n3 < n4) {
            throw new TlsFatalAlert(50);
        }
        int n5 = n3 - n4;
        byte[] byArray3 = Arrays.copyOfRange(byArray, n2 + n5, n2 + n3);
        if (!Arrays.constantTimeAreEqual(byArray3, byArray2 = this.readMac.calculateMac(l2, s2, byArray, n2, n5))) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(byArray, n2, n2 + n5);
    }
}

