/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.tls;

import java.io.IOException;
import org.python.bouncycastle.crypto.Mac;
import org.python.bouncycastle.crypto.engines.ChaChaEngine;
import org.python.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import org.python.bouncycastle.crypto.macs.Poly1305;
import org.python.bouncycastle.crypto.params.KeyParameter;
import org.python.bouncycastle.crypto.params.ParametersWithIV;
import org.python.bouncycastle.crypto.tls.TlsCipher;
import org.python.bouncycastle.crypto.tls.TlsContext;
import org.python.bouncycastle.crypto.tls.TlsFatalAlert;
import org.python.bouncycastle.crypto.tls.TlsUtils;
import org.python.bouncycastle.util.Arrays;
import org.python.bouncycastle.util.Pack;

public class Chacha20Poly1305
implements TlsCipher {
    protected TlsContext context;
    protected ChaChaEngine encryptCipher;
    protected ChaChaEngine decryptCipher;

    public Chacha20Poly1305(TlsContext tlsContext) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        if (!TlsUtils.isTLSv12(tlsContext)) {
            throw new TlsFatalAlert(80);
        }
        this.context = tlsContext;
        byte[] byArray = TlsUtils.calculateKeyBlock(tlsContext, 64);
        KeyParameter keyParameter3 = new KeyParameter(byArray, 0, 32);
        KeyParameter keyParameter4 = new KeyParameter(byArray, 32, 32);
        this.encryptCipher = new ChaChaEngine(20);
        this.decryptCipher = new ChaChaEngine(20);
        if (tlsContext.isServer()) {
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
        } else {
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
        }
        byte[] byArray2 = new byte[8];
        this.encryptCipher.init(true, new ParametersWithIV(keyParameter2, byArray2));
        this.decryptCipher.init(false, new ParametersWithIV(keyParameter, byArray2));
    }

    public int getPlaintextLimit(int n2) {
        return n2 - 16;
    }

    public byte[] encodePlaintext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n3 + 16;
        KeyParameter keyParameter = this.initRecordMAC(this.encryptCipher, true, l2);
        byte[] byArray2 = new byte[n4];
        this.encryptCipher.processBytes(byArray, n2, n3, byArray2, 0);
        byte[] byArray3 = this.getAdditionalData(l2, s2, n3);
        byte[] byArray4 = this.calculateRecordMAC(keyParameter, byArray3, byArray2, 0, n3);
        System.arraycopy(byArray4, 0, byArray2, n3, byArray4.length);
        return byArray2;
    }

    public byte[] decodeCiphertext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        byte[] byArray2;
        if (this.getPlaintextLimit(n3) < 0) {
            throw new TlsFatalAlert(50);
        }
        int n4 = n3 - 16;
        byte[] byArray3 = Arrays.copyOfRange(byArray, n2 + n4, n2 + n3);
        KeyParameter keyParameter = this.initRecordMAC(this.decryptCipher, false, l2);
        byte[] byArray4 = this.calculateRecordMAC(keyParameter, byArray2 = this.getAdditionalData(l2, s2, n4), byArray, n2, n4);
        if (!Arrays.constantTimeAreEqual(byArray4, byArray3)) {
            throw new TlsFatalAlert(20);
        }
        byte[] byArray5 = new byte[n4];
        this.decryptCipher.processBytes(byArray, n2, n4, byArray5, 0);
        return byArray5;
    }

    protected KeyParameter initRecordMAC(ChaChaEngine chaChaEngine, boolean bl, long l2) {
        byte[] byArray = new byte[8];
        TlsUtils.writeUint64(l2, byArray, 0);
        chaChaEngine.init(bl, new ParametersWithIV(null, byArray));
        byte[] byArray2 = new byte[64];
        chaChaEngine.processBytes(byArray2, 0, byArray2.length, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray2, 32, 16);
        KeyParameter keyParameter = new KeyParameter(byArray2, 16, 32);
        Poly1305KeyGenerator.clamp(keyParameter.getKey());
        return keyParameter;
    }

    protected byte[] calculateRecordMAC(KeyParameter keyParameter, byte[] byArray, byte[] byArray2, int n2, int n3) {
        Poly1305 poly1305 = new Poly1305();
        poly1305.init(keyParameter);
        this.updateRecordMAC(poly1305, byArray, 0, byArray.length);
        this.updateRecordMAC(poly1305, byArray2, n2, n3);
        byte[] byArray3 = new byte[poly1305.getMacSize()];
        poly1305.doFinal(byArray3, 0);
        return byArray3;
    }

    protected void updateRecordMAC(Mac mac, byte[] byArray, int n2, int n3) {
        mac.update(byArray, n2, n3);
        byte[] byArray2 = Pack.longToLittleEndian((long)n3 & 0xFFFFFFFFL);
        mac.update(byArray2, 0, byArray2.length);
    }

    protected byte[] getAdditionalData(long l2, short s2, int n2) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64(l2, byArray, 0);
        TlsUtils.writeUint8(s2, byArray, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), byArray, 9);
        TlsUtils.writeUint16(n2, byArray, 11);
        return byArray;
    }
}

