/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import org.python.apache.xerces.impl.io.MalformedByteSequenceException;
import org.python.apache.xerces.util.MessageFormatter;

public final class ASCIIReader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final InputStream fInputStream;
    protected final byte[] fBuffer;
    private final MessageFormatter fFormatter;
    private final Locale fLocale;

    public ASCIIReader(InputStream inputStream, MessageFormatter messageFormatter, Locale locale) {
        this(inputStream, 2048, messageFormatter, locale);
    }

    public ASCIIReader(InputStream inputStream, int n2, MessageFormatter messageFormatter, Locale locale) {
        this(inputStream, new byte[n2], messageFormatter, locale);
    }

    public ASCIIReader(InputStream inputStream, byte[] byArray, MessageFormatter messageFormatter, Locale locale) {
        this.fInputStream = inputStream;
        this.fBuffer = byArray;
        this.fFormatter = messageFormatter;
        this.fLocale = locale;
    }

    public int read() throws IOException {
        int n2 = this.fInputStream.read();
        if (n2 >= 128) {
            throw new MalformedByteSequenceException(this.fFormatter, this.fLocale, "http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidASCII", new Object[]{Integer.toString(n2)});
        }
        return n2;
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        if (n3 > this.fBuffer.length) {
            n3 = this.fBuffer.length;
        }
        int n4 = this.fInputStream.read(this.fBuffer, 0, n3);
        int n5 = 0;
        while (n5 < n4) {
            byte by = this.fBuffer[n5];
            if (by < 0) {
                throw new MalformedByteSequenceException(this.fFormatter, this.fLocale, "http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidASCII", new Object[]{Integer.toString(by & 0xFF)});
            }
            cArray[n2 + n5] = (char)by;
            ++n5;
        }
        return n4;
    }

    public long skip(long l2) throws IOException {
        return this.fInputStream.skip(l2);
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return this.fInputStream.markSupported();
    }

    public void mark(int n2) throws IOException {
        this.fInputStream.mark(n2);
    }

    public void reset() throws IOException {
        this.fInputStream.reset();
    }

    public void close() throws IOException {
        this.fInputStream.close();
    }
}

