/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr.runtime.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class Stats {
    public static final String ANTLRWORKS_DIR = "antlrworks";

    public static double stddev(int[] X) {
        int m4 = X.length;
        if (m4 <= 1) {
            return 0.0;
        }
        double xbar = Stats.avg(X);
        double s2 = 0.0;
        for (int i2 = 0; i2 < m4; ++i2) {
            s2 += ((double)X[i2] - xbar) * ((double)X[i2] - xbar);
        }
        return Math.sqrt(s2 /= (double)(m4 - 1));
    }

    public static double avg(int[] X) {
        double xbar = 0.0;
        int m4 = X.length;
        if (m4 == 0) {
            return 0.0;
        }
        for (int i2 = 0; i2 < m4; ++i2) {
            xbar += (double)X[i2];
        }
        if (xbar >= 0.0) {
            return xbar / (double)m4;
        }
        return 0.0;
    }

    public static int min(int[] X) {
        int min2 = Integer.MAX_VALUE;
        int m4 = X.length;
        if (m4 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m4; ++i2) {
            if (X[i2] >= min2) continue;
            min2 = X[i2];
        }
        return min2;
    }

    public static int max(int[] X) {
        int max = Integer.MIN_VALUE;
        int m4 = X.length;
        if (m4 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m4; ++i2) {
            if (X[i2] <= max) continue;
            max = X[i2];
        }
        return max;
    }

    public static int sum(int[] X) {
        int s2 = 0;
        int m4 = X.length;
        if (m4 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m4; ++i2) {
            s2 += X[i2];
        }
        return s2;
    }

    public static void writeReport(String filename, String data) throws IOException {
        String absoluteFilename = Stats.getAbsoluteFileName(filename);
        File f2 = new File(absoluteFilename);
        File parent = f2.getParentFile();
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(f2, true);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintStream ps = new PrintStream(bos);
        ps.println(data);
        ps.close();
        bos.close();
        fos.close();
    }

    public static String getAbsoluteFileName(String filename) {
        return System.getProperty("user.home") + File.separator + ANTLRWORKS_DIR + File.separator + filename;
    }
}

