/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.File;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.openjdk.jmh.util.TempFile;

public class TempFileManager {
    private final ReferenceQueue<TempFile> rq = new ReferenceQueue();
    private final Set<TempFileReference> refs = new HashSet<TempFileReference>();

    public TempFile create(String suffix) throws IOException {
        this.purge();
        File file = File.createTempFile("jmh", suffix);
        file.deleteOnExit();
        TempFile tf = new TempFile(file);
        this.refs.add(new TempFileReference(tf, this.rq));
        return tf;
    }

    public void purge() {
        TempFileReference ref;
        while ((ref = (TempFileReference)this.rq.poll()) != null) {
            if (ref.file != null) {
                ref.file.delete();
            }
            this.refs.remove(ref);
        }
    }

    private static class TempFileReference
    extends WeakReference<TempFile> {
        final File file;

        TempFileReference(TempFile referent, ReferenceQueue<? super TempFile> q2) {
            super(referent, q2);
            this.file = referent.file();
        }
    }
}

