/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.results.ScalarDerivativeResult;
import org.openjdk.jmh.results.ScalarResult;
import org.openjdk.jmh.util.SampleBuffer;

public class SafepointsProfiler
implements ExternalProfiler {
    private static final long NO_LONG_VALUE = Long.MIN_VALUE;
    private static final Pattern JDK_7_LINE = Pattern.compile("([0-9\\.,]*): (.*) stopped: ([0-9\\.,]*) seconds");
    private static final Pattern JDK_8_LINE = Pattern.compile("([0-9\\.,]*): (.*) stopped: ([0-9\\.,]*) seconds, (.*) took: ([0-9\\.,]*) seconds");
    private static final Pattern JDK_9_LINE = Pattern.compile("\\[([0-9\\.,]*)s\\]\\[info\\]\\[safepoint( *)\\] (.*) stopped: ([0-9\\.,]*) seconds, (.*) took: ([0-9\\.,]*) seconds");

    @Override
    public String getDescription() {
        return "Safepoints profiler";
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Arrays.asList("-XX:+IgnoreUnrecognizedVMOptions", "-Xlog:safepoint=info", "-XX:+PrintGCApplicationStoppedTime", "-XX:+PrintGCTimeStamps");
    }

    @Override
    public void beforeTrial(BenchmarkParams benchmarkParams) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        long measuredTimeMs = ProfilerUtils.measuredTimeMs(br);
        long measuredTimeNs = TimeUnit.MILLISECONDS.toNanos(measuredTimeMs);
        long measureFrom = TimeUnit.MILLISECONDS.toNanos(ProfilerUtils.measurementDelayMs(br));
        long measureTo = measureFrom + measuredTimeNs;
        ArrayList<ParsedData> ds = new ArrayList<ParsedData>();
        try (BufferedReader reader = Files.newBufferedReader(stdOut.toPath(), Charset.defaultCharset());){
            Object line;
            while ((line = reader.readLine()) != null) {
                ParsedData data = SafepointsProfiler.parse((String)line);
                if (data == null) continue;
                ds.add(data);
            }
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
        long maxVer = Long.MIN_VALUE;
        for (ParsedData d2 : ds) {
            maxVer = Math.max(maxVer, (long)d2.ver);
        }
        SampleBuffer pauseBuff = new SampleBuffer();
        SampleBuffer ttspBuff = new SampleBuffer();
        for (ParsedData d3 : ds) {
            if ((long)d3.ver != maxVer || d3.timestamp <= measureFrom || d3.timestamp >= measureTo) continue;
            pauseBuff.add(d3.stopTime);
            if (d3.ttspTime == Long.MIN_VALUE) continue;
            ttspBuff.add(d3.ttspTime);
        }
        ArrayList<Result> results = new ArrayList<Result>();
        results.add(new ScalarResult("\u00b7safepoints.interval", measuredTimeMs, "ms", AggregationPolicy.SUM));
        results.add(new SafepointProfilerResult("pause", pauseBuff));
        if (maxVer > 7L) {
            results.add(new SafepointProfilerResult("ttsp", ttspBuff));
        }
        return results;
    }

    static long parseNs(String str) {
        return (long)(Double.parseDouble(str.replace(',', '.')) * (double)TimeUnit.SECONDS.toNanos(1L));
    }

    @Override
    public boolean allowPrintOut() {
        return false;
    }

    @Override
    public boolean allowPrintErr() {
        return true;
    }

    static ParsedData parse(String line) {
        Matcher m4 = JDK_7_LINE.matcher(line);
        if (m4.matches()) {
            return new ParsedData(7, SafepointsProfiler.parseNs(m4.group(1)), SafepointsProfiler.parseNs(m4.group(3)), Long.MIN_VALUE);
        }
        m4 = JDK_8_LINE.matcher(line);
        if (m4.matches()) {
            return new ParsedData(8, SafepointsProfiler.parseNs(m4.group(1)), SafepointsProfiler.parseNs(m4.group(3)), SafepointsProfiler.parseNs(m4.group(5)));
        }
        m4 = JDK_9_LINE.matcher(line);
        if (m4.matches()) {
            return new ParsedData(9, SafepointsProfiler.parseNs(m4.group(1)), SafepointsProfiler.parseNs(m4.group(4)), SafepointsProfiler.parseNs(m4.group(6)));
        }
        return null;
    }

    static class ParsedData {
        int ver;
        long timestamp;
        long stopTime;
        long ttspTime;

        public ParsedData(int ver, long timestamp, long stopTime, long ttspTime) {
            this.ver = ver;
            this.timestamp = timestamp;
            this.stopTime = stopTime;
            this.ttspTime = ttspTime;
        }
    }

    static class SafepointProfilerResult
    extends Result<SafepointProfilerResult> {
        private final String suffix;
        private final SampleBuffer buffer;

        public SafepointProfilerResult(String suffix, SampleBuffer buffer) {
            super(ResultRole.SECONDARY, "\u00b7safepoints." + suffix, buffer.getStatistics(1.0E-6), "ms", AggregationPolicy.SUM);
            this.suffix = suffix;
            this.buffer = buffer;
        }

        @Override
        protected Aggregator<SafepointProfilerResult> getThreadAggregator() {
            return new JoiningAggregator();
        }

        @Override
        protected Aggregator<SafepointProfilerResult> getIterationAggregator() {
            return new JoiningAggregator();
        }

        @Override
        protected Collection<? extends Result> getDerivativeResults() {
            return Arrays.asList(new ScalarDerivativeResult("\u00b7safepoints." + this.suffix + ".avg", this.statistics.getMean(), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7safepoints." + this.suffix + ".count", this.statistics.getN(), "#", AggregationPolicy.SUM), new ScalarDerivativeResult("\u00b7safepoints." + this.suffix + ".p0.00", this.statistics.getMin(), "ms", AggregationPolicy.MIN), new ScalarDerivativeResult("\u00b7safepoints." + this.suffix + ".p0.50", this.statistics.getPercentile(50.0), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7safepoints." + this.suffix + ".p0.90", this.statistics.getPercentile(90.0), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7safepoints." + this.suffix + ".p0.95", this.statistics.getPercentile(95.0), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7safepoints." + this.suffix + ".p0.99", this.statistics.getPercentile(99.0), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7safepoints." + this.suffix + ".p0.999", this.statistics.getPercentile(99.9), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7safepoints." + this.suffix + ".p0.9999", this.statistics.getPercentile(99.99), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7safepoints." + this.suffix + ".p1.00", this.statistics.getMax(), "ms", AggregationPolicy.MAX));
        }

        private static class JoiningAggregator
        implements Aggregator<SafepointProfilerResult> {
            private JoiningAggregator() {
            }

            @Override
            public SafepointProfilerResult aggregate(Collection<SafepointProfilerResult> results) {
                SampleBuffer buffer = new SampleBuffer();
                String suffix = null;
                for (SafepointProfilerResult r2 : results) {
                    buffer.addAll(r2.buffer);
                    if (suffix == null) {
                        suffix = r2.suffix;
                        continue;
                    }
                    if (suffix.equals(r2.suffix)) continue;
                    throw new IllegalStateException("Trying to aggregate results with different suffixes");
                }
                return new SafepointProfilerResult(suffix, buffer);
            }
        }
    }
}

