/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.IOException;
import java.io.StringWriter;
import java.util.concurrent.TimeUnit;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.BenchmarkResultMetaData;

class ProfilerUtils {
    ProfilerUtils() {
    }

    public static OptionSet parseInitLine(String initLine, OptionParser parser) throws ProfilerException {
        String s2;
        OptionSet set;
        parser.accepts("help", "Display help.");
        NonOptionArgumentSpec<String> nonOptions = parser.nonOptions();
        String[] split = initLine.split(";");
        for (int c2 = 0; c2 < split.length; ++c2) {
            if (split[c2].isEmpty()) continue;
            split[c2] = "-" + split[c2];
        }
        try {
            set = parser.parse(split);
        }
        catch (OptionException e2) {
            try {
                StringWriter sw = new StringWriter();
                sw.append(e2.getMessage());
                sw.append("\n");
                parser.printHelpOn(sw);
                throw new ProfilerException(sw.toString());
            }
            catch (IOException e1) {
                throw new ProfilerException(e1);
            }
        }
        if (set.has("help")) {
            try {
                StringWriter sw = new StringWriter();
                parser.printHelpOn(sw);
                throw new ProfilerException(sw.toString());
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        if ((s2 = set.valueOf(nonOptions)) != null && !s2.isEmpty()) {
            throw new ProfilerException("Unhandled options: " + s2 + " in " + initLine);
        }
        return set;
    }

    public static long measurementDelayMs(BenchmarkResult br) {
        BenchmarkResultMetaData md = br.getMetadata();
        if (md != null) {
            return md.getMeasurementTime() - md.getStartTime();
        }
        IterationParams wp = br.getParams().getWarmup();
        return (long)wp.getCount() * wp.getTime().convertTo(TimeUnit.MILLISECONDS) + TimeUnit.SECONDS.toMillis(1L);
    }

    public static long measuredTimeMs(BenchmarkResult br) {
        BenchmarkResultMetaData md = br.getMetadata();
        if (md != null) {
            return md.getStopTime() - md.getMeasurementTime();
        }
        IterationParams mp = br.getParams().getMeasurement();
        return (long)mp.getCount() * mp.getTime().convertTo(TimeUnit.MILLISECONDS);
    }
}

