/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dst;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jtransforms.dct.DoubleDCT_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;

public class DoubleDST_1D {
    private final int n;
    private final long nl;
    private final DoubleDCT_1D dct;
    private final boolean useLargeArrays;

    public DoubleDST_1D(long n2) {
        this.n = (int)n2;
        this.nl = n2;
        this.useLargeArrays = CommonUtils.isUseLargeArrays() || n2 > (long)LargeArray.getMaxSizeOf32bitArray();
        this.dct = new DoubleDCT_1D(n2);
    }

    public void forward(double[] a2, boolean scale) {
        this.forward(a2, 0, scale);
    }

    public void forward(DoubleLargeArray a2, boolean scale) {
        this.forward(a2, 0L, scale);
    }

    public void forward(final double[] a2, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.forward(new DoubleLargeArray(a2), (long)offa, scale);
        } else {
            int nd2 = this.n / 2;
            int startIdx = 1 + offa;
            int stopIdx = offa + this.n;
            for (int i2 = startIdx; i2 < stopIdx; i2 += 2) {
                a2[i2] = -a2[i2];
            }
            this.dct.forward(a2, offa, scale);
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && (long)nd2 > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                int k2 = nd2 / nthreads;
                Future[] futures = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final int firstIdx = j2 * k2;
                    final int lastIdx = j2 == nthreads - 1 ? nd2 : firstIdx + k2;
                    futures[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx0 = offa + DoubleDST_1D.this.n - 1;
                            for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                                int idx2 = offa + i2;
                                double tmp = a2[idx2];
                                int idx1 = idx0 - i2;
                                a2[idx2] = a2[idx1];
                                a2[idx1] = tmp;
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDST_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDST_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int idx0 = offa + this.n - 1;
                for (int i3 = 0; i3 < nd2; ++i3) {
                    int idx2 = offa + i3;
                    double tmp = a2[idx2];
                    int idx1 = idx0 - i3;
                    a2[idx2] = a2[idx1];
                    a2[idx1] = tmp;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forward(final DoubleLargeArray a2, final long offa, boolean scale) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.forward(a2.getData(), (int)offa, scale);
            return;
        } else {
            long nd2 = this.nl / 2L;
            long startIdx = 1L + offa;
            long stopIdx = offa + this.nl;
            for (long i2 = startIdx; i2 < stopIdx; i2 += 2L) {
                a2.setDouble(i2, -a2.getDouble(i2));
            }
            this.dct.forward(a2, offa, scale);
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && nd2 > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                long k2 = nd2 / (long)nthreads;
                Future[] futures = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? nd2 : firstIdx + k2;
                    futures[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            long idx0 = offa + DoubleDST_1D.this.nl - 1L;
                            for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                                long idx2 = offa + i2;
                                double tmp = a2.getDouble(idx2);
                                long idx1 = idx0 - i2;
                                a2.setDouble(idx2, a2.getDouble(idx1));
                                a2.setDouble(idx1, tmp);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                    return;
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDST_1D.class.getName()).log(Level.SEVERE, null, ex);
                    return;
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDST_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                return;
            } else {
                long idx0 = offa + this.nl - 1L;
                for (long i3 = 0L; i3 < nd2; ++i3) {
                    long idx2 = offa + i3;
                    double tmp = a2.getDouble(idx2);
                    long idx1 = idx0 - i3;
                    a2.setDouble(idx2, a2.getDouble(idx1));
                    a2.setDouble(idx1, tmp);
                }
            }
        }
    }

    public void inverse(double[] a2, boolean scale) {
        this.inverse(a2, 0, scale);
    }

    public void inverse(DoubleLargeArray a2, boolean scale) {
        this.inverse(a2, 0L, scale);
    }

    public void inverse(final double[] a2, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.inverse(new DoubleLargeArray(a2), (long)offa, scale);
        } else {
            int nd2 = this.n / 2;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && (long)nd2 > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                int k2 = nd2 / nthreads;
                Future[] futures = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final int firstIdx = j2 * k2;
                    final int lastIdx = j2 == nthreads - 1 ? nd2 : firstIdx + k2;
                    futures[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx0 = offa + DoubleDST_1D.this.n - 1;
                            for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                                int idx2 = offa + i2;
                                double tmp = a2[idx2];
                                int idx1 = idx0 - i2;
                                a2[idx2] = a2[idx1];
                                a2[idx1] = tmp;
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDST_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDST_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int idx0 = offa + this.n - 1;
                for (int i2 = 0; i2 < nd2; ++i2) {
                    double tmp = a2[offa + i2];
                    a2[offa + i2] = a2[idx0 - i2];
                    a2[idx0 - i2] = tmp;
                }
            }
            this.dct.inverse(a2, offa, scale);
            int startidx = 1 + offa;
            int stopidx = offa + this.n;
            for (int i3 = startidx; i3 < stopidx; i3 += 2) {
                a2[i3] = -a2[i3];
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inverse(final DoubleLargeArray a2, final long offa, boolean scale) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.inverse(a2.getData(), (int)offa, scale);
            return;
        } else {
            long nd2 = this.nl / 2L;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && nd2 > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                long k2 = nd2 / (long)nthreads;
                Future[] futures = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? nd2 : firstIdx + k2;
                    futures[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            long idx0 = offa + DoubleDST_1D.this.nl - 1L;
                            for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                                long idx2 = offa + i2;
                                double tmp = a2.getDouble(idx2);
                                long idx1 = idx0 - i2;
                                a2.setDouble(idx2, a2.getDouble(idx1));
                                a2.setDouble(idx1, tmp);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDST_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDST_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                long idx0 = offa + this.nl - 1L;
                for (long i2 = 0L; i2 < nd2; ++i2) {
                    double tmp = a2.getDouble(offa + i2);
                    a2.setDouble(offa + i2, a2.getDouble(idx0 - i2));
                    a2.setDouble(idx0 - i2, tmp);
                }
            }
            this.dct.inverse(a2, offa, scale);
            long startidx = 1L + offa;
            long stopidx = offa + this.nl;
            for (long i3 = startidx; i3 < stopidx; i3 += 2L) {
                a2.setDouble(i3, -a2.getDouble(i3));
            }
        }
    }
}

