/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;

public class SSOR
implements Preconditioner {
    private double omegaF;
    private double omegaR;
    private final CompRowMatrix F;
    private final int[] diagind;
    private final double[] xx;
    private final boolean reverse;

    public SSOR(CompRowMatrix F2, boolean reverse, double omegaF, double omegaR) {
        if (!F2.isSquare()) {
            throw new IllegalArgumentException("SSOR only applies to square matrices");
        }
        this.F = F2;
        this.reverse = reverse;
        this.setOmega(omegaF, omegaR);
        int n2 = F2.numRows();
        this.diagind = new int[n2];
        this.xx = new double[n2];
    }

    public SSOR(CompRowMatrix F2) {
        this(F2, true, 1.0, 1.0);
    }

    public void setOmega(double omegaF, double omegaR) {
        if (omegaF < 0.0 || omegaF > 2.0) {
            throw new IllegalArgumentException("omegaF must be between 0 and 2");
        }
        if (omegaR < 0.0 || omegaR > 2.0) {
            throw new IllegalArgumentException("omegaR must be between 0 and 2");
        }
        this.omegaF = omegaF;
        this.omegaR = omegaR;
    }

    @Override
    public void setMatrix(Matrix A2) {
        this.F.set(A2);
        int n2 = this.F.numRows();
        int[] rowptr = this.F.getRowPointers();
        int[] colind = this.F.getColumnIndices();
        for (int k2 = 0; k2 < n2; ++k2) {
            this.diagind[k2] = Arrays.binarySearch(colind, k2, rowptr[k2], rowptr[k2 + 1]);
            if (this.diagind[k2] >= 0) continue;
            throw new RuntimeException("Missing diagonal on row " + (k2 + 1));
        }
    }

    @Override
    public Vector apply(Vector b2, Vector x2) {
        int j2;
        double sigma;
        int i2;
        if (!(b2 instanceof DenseVector) || !(x2 instanceof DenseVector)) {
            throw new IllegalArgumentException("Vectors must be a DenseVectors");
        }
        int[] rowptr = this.F.getRowPointers();
        int[] colind = this.F.getColumnIndices();
        double[] data = this.F.getData();
        double[] bd = ((DenseVector)b2).getData();
        double[] xd = ((DenseVector)x2).getData();
        int n2 = this.F.numRows();
        System.arraycopy(xd, 0, this.xx, 0, n2);
        for (i2 = 0; i2 < n2; ++i2) {
            sigma = 0.0;
            for (j2 = rowptr[i2]; j2 < this.diagind[i2]; ++j2) {
                sigma += data[j2] * this.xx[colind[j2]];
            }
            for (j2 = this.diagind[i2] + 1; j2 < rowptr[i2 + 1]; ++j2) {
                sigma += data[j2] * xd[colind[j2]];
            }
            sigma = (bd[i2] - sigma) / data[this.diagind[i2]];
            this.xx[i2] = xd[i2] + this.omegaF * (sigma - xd[i2]);
        }
        if (!this.reverse) {
            System.arraycopy(this.xx, 0, xd, 0, n2);
            return x2;
        }
        for (i2 = n2 - 1; i2 >= 0; --i2) {
            sigma = 0.0;
            for (j2 = rowptr[i2]; j2 < this.diagind[i2]; ++j2) {
                sigma += data[j2] * this.xx[colind[j2]];
            }
            for (j2 = this.diagind[i2] + 1; j2 < rowptr[i2 + 1]; ++j2) {
                sigma += data[j2] * xd[colind[j2]];
            }
            sigma = (bd[i2] - sigma) / data[this.diagind[i2]];
            xd[i2] = this.xx[i2] + this.omegaR * (sigma - this.xx[i2]);
        }
        return x2;
    }

    @Override
    public Vector transApply(Vector b2, Vector x2) {
        return this.apply(b2, x2);
    }
}

