/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;
import no.uib.cipr.matrix.sparse.Preconditioner;

public class QMR
extends AbstractIterativeSolver {
    private Preconditioner M1;
    private Preconditioner M2;
    private Vector r;
    private Vector y;
    private Vector z;
    private Vector v;
    private Vector w;
    private Vector p;
    private Vector q;
    private Vector d;
    private Vector s;
    private Vector v_tld;
    private Vector w_tld;
    private Vector y_tld;
    private Vector z_tld;
    private Vector p_tld;

    public QMR(Vector template) {
        this.M1 = this.M;
        this.M2 = this.M;
        this.r = template.copy();
        this.y = template.copy();
        this.z = template.copy();
        this.v = template.copy();
        this.w = template.copy();
        this.p = template.copy();
        this.q = template.copy();
        this.d = template.copy();
        this.s = template.copy();
        this.v_tld = template.copy();
        this.w_tld = template.copy();
        this.y_tld = template.copy();
        this.z_tld = template.copy();
        this.p_tld = template.copy();
    }

    public QMR(Vector template, Preconditioner M1, Preconditioner M2) {
        this.M1 = M1;
        this.M2 = M2;
        this.r = template.copy();
        this.y = template.copy();
        this.z = template.copy();
        this.v = template.copy();
        this.w = template.copy();
        this.p = template.copy();
        this.q = template.copy();
        this.d = template.copy();
        this.s = template.copy();
        this.v_tld = template.copy();
        this.w_tld = template.copy();
        this.y_tld = template.copy();
        this.z_tld = template.copy();
        this.p_tld = template.copy();
    }

    @Override
    public Vector solve(Matrix A2, Vector b2, Vector x2) throws IterativeSolverNotConvergedException {
        this.checkSizes(A2, b2, x2);
        double rho = 0.0;
        double rho_1 = 0.0;
        double xi = 0.0;
        double gamma = 1.0;
        double gamma_1 = 0.0;
        double theta = 0.0;
        double theta_1 = 0.0;
        double eta = -1.0;
        double delta = 0.0;
        double ep = 0.0;
        double beta = 0.0;
        A2.multAdd(-1.0, x2, this.r.set(b2));
        this.v_tld.set(this.r);
        this.M1.apply(this.v_tld, this.y);
        rho = this.y.norm(Vector.Norm.Two);
        this.w_tld.set(this.r);
        this.M2.transApply(this.w_tld, this.z);
        xi = this.z.norm(Vector.Norm.Two);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x2)) {
            if (rho == 0.0) {
                throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (xi == 0.0) {
                throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Breakdown, "xi", this.iter);
            }
            this.v.set(1.0 / rho, this.v_tld);
            this.y.scale(1.0 / rho);
            this.w.set(1.0 / xi, this.w_tld);
            this.z.scale(1.0 / xi);
            delta = this.z.dot(this.y);
            if (delta == 0.0) {
                throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Breakdown, "delta", this.iter);
            }
            this.M2.apply(this.y, this.y_tld);
            this.M1.transApply(this.z, this.z_tld);
            if (this.iter.isFirst()) {
                this.p.set(this.y_tld);
                this.q.set(this.z_tld);
            } else {
                this.p.scale(-xi * delta / ep).add(this.y_tld);
                this.q.scale(-rho * delta / ep).add(this.z_tld);
            }
            A2.mult(this.p, this.p_tld);
            ep = this.q.dot(this.p_tld);
            if (ep == 0.0) {
                throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Breakdown, "ep", this.iter);
            }
            beta = ep / delta;
            if (beta == 0.0) {
                throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Breakdown, "beta", this.iter);
            }
            this.v_tld.set(-beta, this.v).add(this.p_tld);
            this.M1.apply(this.v_tld, this.y);
            rho_1 = rho;
            rho = this.y.norm(Vector.Norm.Two);
            A2.transMultAdd(this.q, this.w_tld.set(-beta, this.w));
            this.M2.transApply(this.w_tld, this.z);
            xi = this.z.norm(Vector.Norm.Two);
            gamma_1 = gamma;
            theta_1 = theta;
            theta = rho / (gamma_1 * beta);
            gamma = 1.0 / Math.sqrt(1.0 + theta * theta);
            if (gamma == 0.0) {
                throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Breakdown, "gamma", this.iter);
            }
            eta = -eta * rho_1 * gamma * gamma / (beta * gamma_1 * gamma_1);
            if (this.iter.isFirst()) {
                this.d.set(eta, this.p);
                this.s.set(eta, this.p_tld);
            } else {
                double val = theta_1 * theta_1 * gamma * gamma;
                this.d.scale(val).add(eta, this.p);
                this.s.scale(val).add(eta, this.p_tld);
            }
            x2.add(this.d);
            this.r.add(-1.0, this.s);
            this.iter.next();
        }
        return x2;
    }

    @Override
    public void setPreconditioner(Preconditioner M2) {
        super.setPreconditioner(M2);
        this.M1 = M2;
        this.M2 = M2;
    }
}

