/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.UpperCompRowMatrix;

public class ICC
implements Preconditioner {
    private final CompRowMatrix R;
    private Matrix Rt;
    private final Vector y;

    public ICC(CompRowMatrix R) {
        if (!R.isSquare()) {
            throw new IllegalArgumentException("ICC only applies to square matrices");
        }
        this.R = R;
        int n2 = R.numRows();
        this.y = new DenseVector(n2);
    }

    @Override
    public Vector apply(Vector b2, Vector x2) {
        this.Rt.transSolve(b2, this.y);
        return this.Rt.solve(this.y, x2);
    }

    @Override
    public Vector transApply(Vector b2, Vector x2) {
        return this.apply(b2, x2);
    }

    @Override
    public void setMatrix(Matrix A2) {
        this.R.set(A2);
        this.factor();
    }

    private void factor() {
        int n2 = this.R.numRows();
        int[] colind = this.R.getColumnIndices();
        int[] rowptr = this.R.getRowPointers();
        double[] data = this.R.getData();
        double[] Rk = new double[n2];
        int[] diagind = this.findDiagonalIndices(n2, colind, rowptr);
        for (int k2 = 0; k2 < n2; ++k2) {
            int i2;
            java.util.Arrays.fill(Rk, 0.0);
            for (i2 = rowptr[k2]; i2 < rowptr[k2 + 1]; ++i2) {
                Rk[colind[i2]] = data[i2];
            }
            for (i2 = 0; i2 < k2; ++i2) {
                double Rii = data[diagind[i2]];
                if (Rii == 0.0) {
                    throw new RuntimeException("Zero pivot encountered on row " + (i2 + 1) + " during ICC process");
                }
                double Rki = Rk[i2] / Rii;
                if (Rki == 0.0) continue;
                for (int j2 = diagind[i2] + 1; j2 < rowptr[i2 + 1]; ++j2) {
                    int n3 = colind[j2];
                    Rk[n3] = Rk[n3] - Rki * data[j2];
                }
            }
            if (Rk[k2] == 0.0) {
                throw new RuntimeException("Zero diagonal entry encountered on row " + (k2 + 1) + " during ICC process");
            }
            double sqRkk = Math.sqrt(Rk[k2]);
            for (int i3 = diagind[k2]; i3 < rowptr[k2 + 1]; ++i3) {
                data[i3] = Rk[colind[i3]] / sqRkk;
            }
        }
        this.Rt = new UpperCompRowMatrix(this.R, diagind);
    }

    private int[] findDiagonalIndices(int m4, int[] colind, int[] rowptr) {
        int[] diagind = new int[m4];
        for (int k2 = 0; k2 < m4; ++k2) {
            diagind[k2] = Arrays.binarySearch(colind, k2, rowptr[k2], rowptr[k2 + 1]);
            if (diagind[k2] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (k2 + 1));
        }
        return diagind;
    }
}

