/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.GivensRotation;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;

public class GMRES
extends AbstractIterativeSolver {
    private int restart;
    private Vector w;
    private Vector u;
    private Vector r;
    private Vector[] v;
    private DenseVector s;
    private DenseMatrix H;
    private GivensRotation[] rotation;

    public GMRES(Vector template) {
        this(template, 30);
    }

    public GMRES(Vector template, int restart) {
        this.w = template.copy();
        this.u = template.copy();
        this.r = template.copy();
        this.setRestart(restart);
    }

    public void setRestart(int restart) {
        this.restart = restart;
        if (restart <= 0) {
            throw new IllegalArgumentException("restart must be a positive integer");
        }
        this.s = new DenseVector(restart + 1);
        this.H = new DenseMatrix(restart + 1, restart);
        this.rotation = new GivensRotation[restart + 1];
        this.v = new Vector[restart + 1];
        for (int i2 = 0; i2 < this.v.length; ++i2) {
            this.v[i2] = this.r.copy().zero();
        }
    }

    @Override
    public Vector solve(Matrix A2, Vector b2, Vector x2) throws IterativeSolverNotConvergedException {
        this.checkSizes(A2, b2, x2);
        A2.multAdd(-1.0, x2, this.u.set(b2));
        this.M.apply(this.u, this.r);
        double normr = this.r.norm(Vector.Norm.Two);
        this.M.apply(b2, this.u);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x2)) {
            int i2;
            this.v[0].set(1.0 / normr, this.r);
            this.s.zero().set(0, normr);
            for (i2 = 0; i2 < this.restart && !this.iter.converged(Math.abs(this.s.get(i2))); ++i2) {
                int k2;
                A2.mult(this.v[i2], this.u);
                this.M.apply(this.u, this.w);
                for (k2 = 0; k2 <= i2; ++k2) {
                    this.H.set(k2, i2, this.w.dot(this.v[k2]));
                    this.w.add(-this.H.get(k2, i2), this.v[k2]);
                }
                this.H.set(i2 + 1, i2, this.w.norm(Vector.Norm.Two));
                this.v[i2 + 1].set(1.0 / this.H.get(i2 + 1, i2), this.w);
                for (k2 = 0; k2 < i2; ++k2) {
                    this.rotation[k2].apply(this.H, i2, k2, k2 + 1);
                }
                this.rotation[i2] = new GivensRotation(this.H.get(i2, i2), this.H.get(i2 + 1, i2));
                this.rotation[i2].apply(this.H, i2, i2, i2 + 1);
                this.rotation[i2].apply(this.s, i2, i2 + 1);
                this.iter.next();
            }
            new UpperTriangDenseMatrix((Matrix)this.H, i2, false).solve(this.s, this.s);
            for (int j2 = 0; j2 < i2; ++j2) {
                x2.add(this.s.get(j2), this.v[j2]);
            }
            A2.multAdd(-1.0, x2, this.u.set(b2));
            this.M.apply(this.u, this.r);
            normr = this.r.norm(Vector.Norm.Two);
            this.iter.next();
        }
        return x2;
    }
}

