/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.io.MatrixInfo;
import no.uib.cipr.matrix.io.MatrixSize;
import no.uib.cipr.matrix.io.MatrixVectorReader;
import no.uib.cipr.matrix.sparse.Arrays;

public class CompColMatrix
extends AbstractMatrix {
    double[] data;
    int[] columnPointer;
    int[] rowIndex;

    public CompColMatrix(MatrixVectorReader r2) throws IOException {
        block13: {
            int i2;
            double[] entry;
            int[] column;
            int[] row;
            int numEntries;
            MatrixInfo info;
            block12: {
                int i3;
                super(0, 0);
                info = null;
                info = r2.hasInfo() ? r2.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize size = r2.readMatrixSize(info);
                this.numRows = size.numRows();
                this.numColumns = size.numColumns();
                numEntries = size.numEntries();
                row = new int[numEntries];
                column = new int[numEntries];
                entry = new double[numEntries];
                r2.readCoordinate(row, column, entry);
                r2.add(-1, row);
                r2.add(-1, column);
                ArrayList cnz = new ArrayList(this.numColumns);
                for (i3 = 0; i3 < this.numColumns; ++i3) {
                    cnz.add(new HashSet());
                }
                for (i3 = 0; i3 < numEntries; ++i3) {
                    ((Set)cnz.get(column[i3])).add(row[i3]);
                }
                if (info.isSymmetric() || info.isSkewSymmetric()) {
                    for (i3 = 0; i3 < numEntries; ++i3) {
                        if (row[i3] == column[i3]) continue;
                        ((Set)cnz.get(row[i3])).add(column[i3]);
                    }
                }
                int[][] nz = new int[this.numColumns][];
                for (i2 = 0; i2 < this.numColumns; ++i2) {
                    nz[i2] = new int[((Set)cnz.get(i2)).size()];
                    int j2 = 0;
                    for (Integer rowind : (Set)cnz.get(i2)) {
                        nz[i2][j2++] = rowind;
                    }
                }
                this.construct(nz);
                for (i2 = 0; i2 < size.numEntries(); ++i2) {
                    this.set(row[i2], column[i2], entry[i2]);
                }
                if (!info.isSymmetric()) break block12;
                for (i2 = 0; i2 < numEntries; ++i2) {
                    if (row[i2] == column[i2]) continue;
                    this.set(column[i2], row[i2], entry[i2]);
                }
                break block13;
            }
            if (!info.isSkewSymmetric()) break block13;
            for (i2 = 0; i2 < numEntries; ++i2) {
                if (row[i2] == column[i2]) continue;
                this.set(column[i2], row[i2], -entry[i2]);
            }
        }
    }

    public CompColMatrix(int numRows, int numColumns, int[][] nz) {
        super(numRows, numColumns);
        this.construct(nz);
    }

    private void construct(int[][] nz) {
        int i2;
        int nnz = 0;
        for (i2 = 0; i2 < nz.length; ++i2) {
            nnz += nz[i2].length;
        }
        this.columnPointer = new int[this.numColumns + 1];
        this.rowIndex = new int[nnz];
        this.data = new double[nnz];
        if (nz.length != this.numColumns) {
            throw new IllegalArgumentException("nz.length != numColumns");
        }
        for (i2 = 1; i2 <= this.numColumns; ++i2) {
            this.columnPointer[i2] = this.columnPointer[i2 - 1] + nz[i2 - 1].length;
            int j2 = this.columnPointer[i2 - 1];
            int k2 = 0;
            while (j2 < this.columnPointer[i2]) {
                this.rowIndex[j2] = nz[i2 - 1][k2];
                if (nz[i2 - 1][k2] < 0 || nz[i2 - 1][k2] >= this.numRows) {
                    throw new IllegalArgumentException("nz[" + (i2 - 1) + "][" + k2 + "]=" + nz[i2 - 1][k2] + ", which is not a valid row index");
                }
                ++j2;
                ++k2;
            }
            java.util.Arrays.sort(this.rowIndex, this.columnPointer[i2 - 1], this.columnPointer[i2]);
        }
    }

    private void construct(Matrix A2, boolean deep) {
        if (deep) {
            if (A2 instanceof CompColMatrix) {
                CompColMatrix Ac = (CompColMatrix)A2;
                this.data = new double[Ac.data.length];
                this.columnPointer = new int[Ac.columnPointer.length];
                this.rowIndex = new int[Ac.rowIndex.length];
                System.arraycopy(Ac.data, 0, this.data, 0, this.data.length);
                System.arraycopy(Ac.columnPointer, 0, this.columnPointer, 0, this.columnPointer.length);
                System.arraycopy(Ac.rowIndex, 0, this.rowIndex, 0, this.rowIndex.length);
            } else {
                ArrayList cnz = new ArrayList(this.numColumns);
                for (int i2 = 0; i2 < this.numColumns; ++i2) {
                    cnz.add(new HashSet());
                }
                for (MatrixEntry e2 : A2) {
                    ((Set)cnz.get(e2.column())).add(e2.row());
                }
                int[][] nz = new int[this.numColumns][];
                for (int i3 = 0; i3 < this.numColumns; ++i3) {
                    nz[i3] = new int[((Set)cnz.get(i3)).size()];
                    int j2 = 0;
                    for (Integer rowind : (Set)cnz.get(i3)) {
                        nz[i3][j2++] = rowind;
                    }
                }
                this.construct(nz);
                this.set(A2);
            }
        } else {
            CompColMatrix Ac = (CompColMatrix)A2;
            this.columnPointer = Ac.getColumnPointers();
            this.rowIndex = Ac.getRowIndices();
            this.data = Ac.getData();
        }
    }

    public CompColMatrix(Matrix A2, boolean deep) {
        super(A2);
        this.construct(A2, deep);
    }

    public CompColMatrix(Matrix A2) {
        this(A2, true);
    }

    public int[] getColumnPointers() {
        return this.columnPointer;
    }

    public int[] getRowIndices() {
        return this.rowIndex;
    }

    public double[] getData() {
        return this.data;
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.multAdd(alpha, x2, y2);
        }
        this.checkMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        y2.scale(1.0 / alpha);
        for (int i2 = 0; i2 < this.numColumns; ++i2) {
            for (int j2 = this.columnPointer[i2]; j2 < this.columnPointer[i2 + 1]; ++j2) {
                int n2 = this.rowIndex[j2];
                yd[n2] = yd[n2] + this.data[j2] * xd[i2];
            }
        }
        return y2.scale(alpha);
    }

    @Override
    public Vector transMult(Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.transMult(x2, y2);
        }
        this.checkTransMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        for (int i2 = 0; i2 < this.numColumns; ++i2) {
            double dot = 0.0;
            for (int j2 = this.columnPointer[i2]; j2 < this.columnPointer[i2 + 1]; ++j2) {
                dot += this.data[j2] * xd[this.rowIndex[j2]];
            }
            yd[i2] = dot;
        }
        return y2;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.transMultAdd(alpha, x2, y2);
        }
        this.checkTransMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        int i2 = 0;
        while (i2 < this.numColumns) {
            double dot = 0.0;
            for (int j2 = this.columnPointer[i2]; j2 < this.columnPointer[i2 + 1]; ++j2) {
                dot += this.data[j2] * xd[this.rowIndex[j2]];
            }
            int n2 = i2++;
            yd[n2] = yd[n2] + alpha * dot;
        }
        return y2;
    }

    @Override
    public void set(int row, int column, double value) {
        this.check(row, column);
        int index = this.getIndex(row, column);
        this.data[index] = value;
    }

    @Override
    public void add(int row, int column, double value) {
        int index;
        this.check(row, column);
        int n2 = index = this.getIndex(row, column);
        this.data[n2] = this.data[n2] + value;
    }

    @Override
    public double get(int row, int column) {
        this.check(row, column);
        int index = Arrays.binarySearch(this.rowIndex, row, this.columnPointer[column], this.columnPointer[column + 1]);
        if (index >= 0) {
            return this.data[index];
        }
        return 0.0;
    }

    private int getIndex(int row, int column) {
        int i2 = Arrays.binarySearch(this.rowIndex, row, this.columnPointer[column], this.columnPointer[column + 1]);
        if (i2 != -1 && this.rowIndex[i2] == row) {
            return i2;
        }
        throw new IndexOutOfBoundsException("Entry (" + (row + 1) + ", " + (column + 1) + ") is not in the matrix structure");
    }

    @Override
    public CompColMatrix copy() {
        return new CompColMatrix(this);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new CompColMatrixIterator();
    }

    @Override
    public CompColMatrix zero() {
        java.util.Arrays.fill(this.data, 0.0);
        return this;
    }

    private class CompColMatrixEntry
    implements MatrixEntry {
        private int column;
        private int cursor;

        private CompColMatrixEntry() {
        }

        public void update(int column, int cursor) {
            this.column = column;
            this.cursor = cursor;
        }

        @Override
        public int row() {
            return CompColMatrix.this.rowIndex[this.cursor];
        }

        @Override
        public int column() {
            return this.column;
        }

        @Override
        public double get() {
            return CompColMatrix.this.data[this.cursor];
        }

        @Override
        public void set(double value) {
            CompColMatrix.this.data[this.cursor] = value;
        }
    }

    private class CompColMatrixIterator
    implements Iterator<MatrixEntry> {
        private int column;
        private int cursor;
        private CompColMatrixEntry entry;

        public CompColMatrixIterator() {
            this.entry = new CompColMatrixEntry();
            this.nextNonEmptyColumn();
        }

        private void nextNonEmptyColumn() {
            while (this.column < CompColMatrix.this.numColumns() && CompColMatrix.this.columnPointer[this.column] == CompColMatrix.this.columnPointer[this.column + 1]) {
                ++this.column;
            }
            this.cursor = CompColMatrix.this.columnPointer[this.column];
        }

        @Override
        public boolean hasNext() {
            return this.cursor < CompColMatrix.this.data.length;
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.column, this.cursor);
            if (this.cursor < CompColMatrix.this.columnPointer[this.column + 1] - 1) {
                ++this.cursor;
            } else {
                ++this.column;
                this.nextNonEmptyColumn();
            }
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

