/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;

public class CG
extends AbstractIterativeSolver {
    private Vector p;
    private Vector z;
    private Vector q;
    private Vector r;

    public CG(Vector template) {
        this.p = template.copy();
        this.z = template.copy();
        this.q = template.copy();
        this.r = template.copy();
    }

    @Override
    public Vector solve(Matrix A2, Vector b2, Vector x2) throws IterativeSolverNotConvergedException {
        this.checkSizes(A2, b2, x2);
        double alpha = 0.0;
        double beta = 0.0;
        double rho = 0.0;
        double rho_1 = 0.0;
        A2.multAdd(-1.0, x2, this.r.set(b2));
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x2)) {
            this.M.apply(this.r, this.z);
            rho = this.r.dot(this.z);
            if (this.iter.isFirst()) {
                this.p.set(this.z);
            } else {
                beta = rho / rho_1;
                this.p.scale(beta).add(this.z);
            }
            A2.mult(this.p, this.q);
            alpha = rho / this.p.dot(this.q);
            x2.add(alpha, this.p);
            this.r.add(-alpha, this.q);
            rho_1 = rho;
            this.iter.next();
        }
        return x2;
    }
}

