/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractTriangDenseMatrix;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpLo;

public class UpperTriangDenseMatrix
extends AbstractTriangDenseMatrix {
    public UpperTriangDenseMatrix(int n2) {
        super(n2, UpLo.Upper, Diag.NonUnit);
    }

    UpperTriangDenseMatrix(int n2, Diag diag) {
        super(n2, UpLo.Upper, diag);
    }

    public UpperTriangDenseMatrix(Matrix A2) {
        this(A2, Math.min(A2.numRows(), A2.numColumns()));
    }

    public UpperTriangDenseMatrix(Matrix A2, boolean deep) {
        this(A2, Math.min(A2.numRows(), A2.numColumns()), deep);
    }

    UpperTriangDenseMatrix(Matrix A2, boolean deep, Diag diag) {
        this(A2, Math.min(A2.numRows(), A2.numColumns()), deep, diag);
    }

    public UpperTriangDenseMatrix(Matrix A2, int k2) {
        this(A2, k2, true);
    }

    public UpperTriangDenseMatrix(Matrix A2, int k2, boolean deep) {
        super(A2, k2, deep, UpLo.Upper, Diag.NonUnit);
    }

    UpperTriangDenseMatrix(Matrix A2, int k2, boolean deep, Diag diag) {
        super(A2, k2, deep, UpLo.Upper, diag);
    }

    @Override
    public void add(int row, int column, double value) {
        if (row > column) {
            throw new IllegalArgumentException("row > column");
        }
        super.add(row, column, value);
    }

    @Override
    public double get(int row, int column) {
        if (row > column) {
            return 0.0;
        }
        return super.get(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        if (row > column) {
            throw new IllegalArgumentException("row > column");
        }
        super.set(row, column, value);
    }

    @Override
    void copy(Matrix A2) {
        for (MatrixEntry e2 : A2) {
            if (e2.row() > e2.column()) continue;
            this.set(e2.row(), e2.column(), e2.get());
        }
    }

    @Override
    public Matrix set(Matrix A2) {
        this.zero();
        this.copy(A2);
        return this;
    }

    @Override
    public UpperTriangDenseMatrix copy() {
        return new UpperTriangDenseMatrix(this);
    }
}

