/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpperTriangPackMatrix;

public class UnitUpperTriangPackMatrix
extends UpperTriangPackMatrix {
    public UnitUpperTriangPackMatrix(int n2) {
        super(n2, Diag.Unit);
    }

    public UnitUpperTriangPackMatrix(Matrix A2) {
        this(A2, true);
    }

    public UnitUpperTriangPackMatrix(Matrix A2, boolean deep) {
        super(A2, deep, Diag.Unit);
    }

    @Override
    public void add(int row, int column, double value) {
        if (row == column) {
            throw new IllegalArgumentException("row == column");
        }
        super.add(row, column, value);
    }

    @Override
    public double get(int row, int column) {
        if (row == column) {
            return 1.0;
        }
        return super.get(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        if (row == column) {
            throw new IllegalArgumentException("row == column");
        }
        super.set(row, column, value);
    }

    @Override
    void copy(Matrix A2) {
        for (MatrixEntry e2 : A2) {
            if (e2.row() >= e2.column()) continue;
            this.set(e2.row(), e2.column(), e2.get());
        }
    }

    @Override
    public UnitUpperTriangPackMatrix copy() {
        return new UnitUpperTriangPackMatrix(this);
    }
}

