/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.LowerTriangPackMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;

public class UnitLowerTriangPackMatrix
extends LowerTriangPackMatrix {
    public UnitLowerTriangPackMatrix(int n2) {
        super(n2, Diag.Unit);
    }

    public UnitLowerTriangPackMatrix(Matrix A2) {
        this(A2, true);
    }

    public UnitLowerTriangPackMatrix(Matrix A2, boolean deep) {
        super(A2, deep, Diag.Unit);
    }

    @Override
    public void add(int row, int column, double value) {
        if (column == row) {
            throw new IllegalArgumentException("column == row");
        }
        super.add(row, column, value);
    }

    @Override
    public double get(int row, int column) {
        if (column == row) {
            return 1.0;
        }
        return super.get(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        if (column == row) {
            throw new IllegalArgumentException("column == row");
        }
        super.set(row, column, value);
    }

    @Override
    void copy(Matrix A2) {
        for (MatrixEntry e2 : A2) {
            if (e2.row() <= e2.column()) continue;
            this.set(e2.row(), e2.column(), e2.get());
        }
    }

    @Override
    public UnitLowerTriangPackMatrix copy() {
        return new UnitLowerTriangPackMatrix(this);
    }
}

