/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.JobEig;
import no.uib.cipr.matrix.LowerSymmPackMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmEVD;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.netlib.util.intW;

public class SymmPackEVD
extends SymmEVD {
    private final double[] work;
    private final int[] iwork;
    private final UpLo uplo;

    public SymmPackEVD(int n2, boolean upper) {
        this(n2, upper, true);
    }

    public SymmPackEVD(int n2, boolean upper, boolean vectors) {
        super(n2, vectors);
        this.uplo = upper ? UpLo.Upper : UpLo.Lower;
        double[] worksize = new double[1];
        int[] iworksize = new int[1];
        intW info = new intW(0);
        LAPACK.getInstance().dspevd(this.job.netlib(), this.uplo.netlib(), n2, new double[0], new double[0], new double[0], Matrices.ld(n2), worksize, -1, iworksize, -1, info);
        int lwork = 0;
        int liwork = 0;
        if (info.val != 0) {
            if (this.job == JobEig.All) {
                lwork = 1 + 6 * n2 + n2 * n2;
                liwork = 3 + 5 * n2;
            } else {
                lwork = 2 * n2;
                liwork = 1;
            }
        } else {
            lwork = (int)worksize[0];
            liwork = iworksize[0];
        }
        lwork = Math.max(1, lwork);
        liwork = Math.max(1, liwork);
        this.work = new double[lwork];
        this.iwork = new int[liwork];
    }

    public static SymmPackEVD factorize(Matrix A2) throws NotConvergedException {
        return new SymmPackEVD(A2.numRows(), true).factor(new UpperSymmPackMatrix(A2));
    }

    public SymmPackEVD factor(LowerSymmPackMatrix A2) throws NotConvergedException {
        if (this.uplo != UpLo.Lower) {
            throw new IllegalArgumentException("Eigenvalue computer configured for lower-symmetrical matrices");
        }
        return this.factor(A2, A2.getData());
    }

    public SymmPackEVD factor(UpperSymmPackMatrix A2) throws NotConvergedException {
        if (this.uplo != UpLo.Upper) {
            throw new IllegalArgumentException("Eigenvalue computer configured for upper-symmetrical matrices");
        }
        return this.factor(A2, A2.getData());
    }

    private SymmPackEVD factor(Matrix A2, double[] data) throws NotConvergedException {
        if (A2.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dspevd(this.job.netlib(), this.uplo.netlib(), this.n, data, this.w, this.job == JobEig.All ? this.Z.getData() : new double[]{}, Matrices.ld(this.n), this.work, this.work.length, this.iwork, this.iwork.length, info);
        if (info.val > 0) {
            throw new NotConvergedException(NotConvergedException.Reason.Iterations);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return this;
    }
}

