/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.JobEig;

abstract class SymmEVD {
    final int n;
    final double[] w;
    final DenseMatrix Z;
    final JobEig job;

    public SymmEVD(int n2, boolean vectors) {
        this.n = n2;
        this.w = new double[n2];
        this.job = vectors ? JobEig.All : JobEig.Eigenvalues;
        this.Z = vectors ? new DenseMatrix(n2, n2) : null;
    }

    public SymmEVD(int n2) {
        this(n2, true);
    }

    public double[] getEigenvalues() {
        return this.w;
    }

    public DenseMatrix getEigenvectors() {
        return this.Z;
    }

    public boolean hasEigenvectors() {
        return this.Z != null;
    }
}

