/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.SymmTridiagMatrix;
import org.netlib.util.intW;

public class SPDTridiagMatrix
extends SymmTridiagMatrix {
    public SPDTridiagMatrix(int n2) {
        super(n2);
    }

    public SPDTridiagMatrix(Matrix A2) {
        super(A2);
    }

    public SPDTridiagMatrix(Matrix A2, boolean deep) {
        super(A2, deep);
    }

    @Override
    public SPDTridiagMatrix copy() {
        return new SPDTridiagMatrix(this);
    }

    @Override
    public Matrix solve(Matrix B2, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B2, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B2);
        intW info = new intW(0);
        LAPACK.getInstance().dptsv(this.numRows, X.numColumns(), (double[])this.diag.clone(), (double[])this.offDiag.clone(), Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixNotSPDException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }
}

