/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import org.netlib.util.intW;

public class QRP {
    int[] jpvt;
    final double[] tau;
    final int m;
    final int n;
    final int k;
    int rank;
    double[] work;
    final DenseMatrix Afact;
    final DenseMatrix Q;
    final DenseMatrix R;

    public QRP(int m4, int n2) {
        this.m = m4;
        this.n = n2;
        this.k = Math.min(m4, n2);
        this.rank = 0;
        this.jpvt = new int[n2];
        this.tau = new double[this.k];
        this.Q = new DenseMatrix(m4, m4);
        this.R = new DenseMatrix(m4, n2);
        this.Afact = new DenseMatrix(m4, Math.max(m4, n2));
        intW info = new intW(0);
        double[] dummy = new double[1];
        double[] ret = new double[1];
        LAPACK lapack = LAPACK.getInstance();
        lapack.dgeqrf(m4, n2, dummy, Matrices.ld(m4), dummy, ret, -1, info);
        int lwork1 = info.val != 0 ? n2 : (int)ret[0];
        lapack.dorgqr(m4, m4, this.k, dummy, Matrices.ld(m4), dummy, ret, -1, info);
        int lwork2 = info.val != 0 ? n2 : (int)ret[0];
        this.work = new double[Math.max(lwork1, lwork2)];
    }

    public static QRP factorize(Matrix A2) {
        return new QRP(A2.numRows(), A2.numColumns()).factor(A2);
    }

    public QRP factor(Matrix A2) {
        if (this.Q.numRows() != A2.numRows()) {
            throw new IllegalArgumentException("Q.numRows() != A.numRows()");
        }
        if (this.R.numColumns() != A2.numColumns()) {
            throw new IllegalArgumentException("R.numColumns() != A.numColumns()");
        }
        this.Afact.zero();
        for (MatrixEntry e2 : A2) {
            this.Afact.set(e2.row(), e2.column(), e2.get());
        }
        intW info = new intW(0);
        LAPACK lapack = LAPACK.getInstance();
        double[] factorWorkOptimalSize = new double[]{0.0};
        lapack.dgeqp3(this.m, this.n, this.Afact.getData(), Matrices.ld(this.m), this.jpvt, this.tau, factorWorkOptimalSize, -1, info);
        double[] factorWork = new double[(int)factorWorkOptimalSize[0]];
        lapack.dgeqp3(this.m, this.n, this.Afact.getData(), Matrices.ld(this.m), this.jpvt, this.tau, factorWork, factorWork.length, info);
        if (info.val < 0) {
            throw new IllegalArgumentException("DGEQP3 was " + info.val);
        }
        this.R.zero();
        for (MatrixEntry e3 : this.Afact) {
            if (e3.row() > e3.column() || e3.column() >= this.R.numColumns()) continue;
            this.R.set(e3.row(), e3.column(), e3.get());
        }
        double EPS = 1.0E-12;
        this.rank = 0;
        while (this.rank < this.k && !(Math.abs(this.R.get(this.rank, this.rank)) < 1.0E-12)) {
            ++this.rank;
        }
        lapack.dorgqr(this.m, this.m, this.k, this.Afact.getData(), Matrices.ld(this.m), this.tau, this.work, this.work.length, info);
        for (MatrixEntry e4 : this.Afact) {
            if (e4.column() >= this.Q.numColumns()) continue;
            this.Q.set(e4.row(), e4.column(), e4.get());
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        int i2 = 0;
        while (i2 < this.jpvt.length) {
            int n2 = i2++;
            this.jpvt[n2] = this.jpvt[n2] - 1;
        }
        return this;
    }

    public DenseMatrix getR() {
        return this.R;
    }

    public DenseMatrix getQ() {
        return this.Q;
    }

    public int[] getPVector() {
        return this.jpvt;
    }

    public Matrix getP() {
        DenseMatrix P2 = new DenseMatrix(this.jpvt.length, this.jpvt.length);
        for (int i2 = 0; i2 < this.jpvt.length; ++i2) {
            P2.set(this.jpvt[i2], i2, 1.0);
        }
        return P2;
    }

    public int getRank() {
        return this.rank;
    }
}

