/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Arrays;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.Matrix;

abstract class AbstractPackMatrix
extends AbstractMatrix {
    double[] data;
    int n;

    public AbstractPackMatrix(int n2) {
        super(n2, n2);
        this.n = this.numRows;
        this.data = new double[(n2 * n2 + n2) / 2];
    }

    public AbstractPackMatrix(Matrix A2) {
        this(A2, true);
    }

    public AbstractPackMatrix(Matrix A2, boolean deep) {
        super(A2);
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Packed matrix must be square");
        }
        this.n = A2.numRows();
        if (deep) {
            this.data = new double[(this.n * this.n + this.n) / 2];
            this.copy(A2);
        } else {
            this.data = ((AbstractPackMatrix)A2).getData();
        }
    }

    abstract void copy(Matrix var1);

    public double[] getData() {
        return this.data;
    }

    @Override
    public Matrix set(Matrix B2) {
        if (!(B2 instanceof AbstractPackMatrix)) {
            return super.set(B2);
        }
        this.checkSize(B2);
        double[] Bd = ((AbstractPackMatrix)B2).getData();
        if (Bd == this.data) {
            return this;
        }
        System.arraycopy(Bd, 0, this.data, 0, this.data.length);
        return this;
    }

    @Override
    public Matrix zero() {
        Arrays.fill(this.data, 0.0);
        return this;
    }
}

