/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Formatter;
import java.util.Iterator;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;

public abstract class AbstractMatrix
implements Matrix {
    protected int numRows;
    protected int numColumns;

    protected AbstractMatrix(int numRows, int numColumns) {
        if (numRows < 0 || numColumns < 0) {
            throw new IndexOutOfBoundsException("Matrix size cannot be negative");
        }
        this.numRows = numRows;
        this.numColumns = numColumns;
    }

    protected AbstractMatrix(Matrix A2) {
        this(A2.numRows(), A2.numColumns());
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public boolean isSquare() {
        return this.numRows == this.numColumns;
    }

    @Override
    public void set(int row, int column, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int row, int column, double value) {
        this.set(row, column, value + this.get(row, column));
    }

    @Override
    public double get(int row, int column) {
        throw new UnsupportedOperationException();
    }

    protected void check(int row, int column) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("row index is negative (" + row + ")");
        }
        if (column < 0) {
            throw new IndexOutOfBoundsException("column index is negative (" + column + ")");
        }
        if (row >= this.numRows) {
            throw new IndexOutOfBoundsException("row index >= numRows (" + row + " >= " + this.numRows + ")");
        }
        if (column >= this.numColumns) {
            throw new IndexOutOfBoundsException("column index >= numColumns (" + column + " >= " + this.numColumns + ")");
        }
    }

    @Override
    public Matrix copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix zero() {
        for (MatrixEntry e2 : this) {
            e2.set(0.0);
        }
        return this;
    }

    @Override
    public Vector mult(Vector x2, Vector y2) {
        return this.mult(1.0, x2, y2);
    }

    @Override
    public Vector mult(double alpha, Vector x2, Vector y2) {
        return this.multAdd(alpha, x2, y2.zero());
    }

    @Override
    public Vector multAdd(Vector x2, Vector y2) {
        return this.multAdd(1.0, x2, y2);
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y2) {
        this.checkMultAdd(x2, y2);
        if (alpha != 0.0) {
            for (MatrixEntry e2 : this) {
                y2.add(e2.row(), alpha * e2.get() * x2.get(e2.column()));
            }
        }
        return y2;
    }

    protected void checkMultAdd(Vector x2, Vector y2) {
        if (this.numColumns != x2.size()) {
            throw new IndexOutOfBoundsException("A.numColumns != x.size (" + this.numColumns + " != " + x2.size() + ")");
        }
        if (this.numRows != y2.size()) {
            throw new IndexOutOfBoundsException("A.numRows != y.size (" + this.numRows + " != " + y2.size() + ")");
        }
    }

    @Override
    public Vector transMult(Vector x2, Vector y2) {
        return this.transMult(1.0, x2, y2);
    }

    @Override
    public Vector transMult(double alpha, Vector x2, Vector y2) {
        return this.transMultAdd(alpha, x2, y2.zero());
    }

    @Override
    public Vector transMultAdd(Vector x2, Vector y2) {
        return this.transMultAdd(1.0, x2, y2);
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y2) {
        this.checkTransMultAdd(x2, y2);
        if (alpha != 0.0) {
            for (MatrixEntry e2 : this) {
                y2.add(e2.column(), alpha * e2.get() * x2.get(e2.row()));
            }
        }
        return y2;
    }

    protected void checkTransMultAdd(Vector x2, Vector y2) {
        if (this.numRows != x2.size()) {
            throw new IndexOutOfBoundsException("A.numRows != x.size (" + this.numRows + " != " + x2.size() + ")");
        }
        if (this.numColumns != y2.size()) {
            throw new IndexOutOfBoundsException("A.numColumns != y.size (" + this.numColumns + " != " + y2.size() + ")");
        }
    }

    @Override
    public Vector solve(Vector b2, Vector x2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector transSolve(Vector b2, Vector x2) {
        throw new UnsupportedOperationException();
    }

    protected void checkSolve(Vector b2, Vector x2) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (this.numRows != b2.size()) {
            throw new IndexOutOfBoundsException("numRows != b.size (" + this.numRows + " != " + b2.size() + ")");
        }
        if (this.numColumns != x2.size()) {
            throw new IndexOutOfBoundsException("numColumns != x.size (" + this.numColumns + " != " + x2.size() + ")");
        }
    }

    @Override
    public Matrix rank1(Vector x2) {
        return this.rank1(1.0, x2);
    }

    @Override
    public Matrix rank1(double alpha, Vector x2) {
        return this.rank1(alpha, x2, x2);
    }

    @Override
    public Matrix rank1(Vector x2, Vector y2) {
        return this.rank1(1.0, x2, y2);
    }

    @Override
    public Matrix rank1(double alpha, Vector x2, Vector y2) {
        this.checkRank1(x2, y2);
        if (alpha == 0.0) {
            return this;
        }
        for (VectorEntry ei : x2) {
            if (ei.get() == 0.0) continue;
            for (VectorEntry ej : y2) {
                if (ej.get() == 0.0) continue;
                this.add(ei.index(), ej.index(), alpha * ei.get() * ej.get());
            }
        }
        return this;
    }

    protected void checkRank1(Vector x2, Vector y2) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (x2.size() != this.numRows) {
            throw new IndexOutOfBoundsException("x.size != A.numRows (" + x2.size() + " != " + this.numRows + ")");
        }
        if (y2.size() != this.numColumns) {
            throw new IndexOutOfBoundsException("y.size != A.numColumns (" + y2.size() + " != " + this.numColumns + ")");
        }
    }

    @Override
    public Matrix rank2(Vector x2, Vector y2) {
        return this.rank2(1.0, x2, y2);
    }

    @Override
    public Matrix rank2(double alpha, Vector x2, Vector y2) {
        this.checkRank2(x2, y2);
        if (alpha == 0.0) {
            return this;
        }
        for (VectorEntry ei : x2) {
            for (VectorEntry ej : y2) {
                this.add(ei.index(), ej.index(), alpha * ei.get() * ej.get());
                this.add(ej.index(), ei.index(), alpha * ei.get() * ej.get());
            }
        }
        return this;
    }

    protected void checkRank2(Vector x2, Vector y2) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (x2.size() != this.numRows) {
            throw new IndexOutOfBoundsException("x.size != A.numRows (" + x2.size() + " != " + this.numRows + ")");
        }
        if (y2.size() != this.numRows) {
            throw new IndexOutOfBoundsException("y.size != A.numRows (" + y2.size() + " != " + this.numRows + ")");
        }
    }

    @Override
    public Matrix mult(Matrix B2, Matrix C2) {
        return this.mult(1.0, B2, C2);
    }

    @Override
    public Matrix mult(double alpha, Matrix B2, Matrix C2) {
        return this.multAdd(alpha, B2, C2.zero());
    }

    @Override
    public Matrix multAdd(Matrix B2, Matrix C2) {
        return this.multAdd(1.0, B2, C2);
    }

    @Override
    public Matrix multAdd(double alpha, Matrix B2, Matrix C2) {
        this.checkMultAdd(B2, C2);
        if (alpha != 0.0) {
            for (int i2 = 0; i2 < this.numRows; ++i2) {
                for (int j2 = 0; j2 < C2.numColumns(); ++j2) {
                    double dot = 0.0;
                    for (int k2 = 0; k2 < this.numColumns; ++k2) {
                        dot += this.get(i2, k2) * B2.get(k2, j2);
                    }
                    C2.add(i2, j2, alpha * dot);
                }
            }
        }
        return C2;
    }

    protected void checkMultAdd(Matrix B2, Matrix C2) {
        if (this.numRows != C2.numRows()) {
            throw new IndexOutOfBoundsException("A.numRows != C.numRows (" + this.numRows + " != " + C2.numRows() + ")");
        }
        if (this.numColumns != B2.numRows()) {
            throw new IndexOutOfBoundsException("A.numColumns != B.numRows (" + this.numColumns + " != " + B2.numRows() + ")");
        }
        if (B2.numColumns() != C2.numColumns()) {
            throw new IndexOutOfBoundsException("B.numColumns != C.numColumns (" + B2.numRows() + " != " + C2.numColumns() + ")");
        }
    }

    @Override
    public Matrix transAmult(Matrix B2, Matrix C2) {
        return this.transAmult(1.0, B2, C2);
    }

    @Override
    public Matrix transAmult(double alpha, Matrix B2, Matrix C2) {
        return this.transAmultAdd(alpha, B2, C2.zero());
    }

    @Override
    public Matrix transAmultAdd(Matrix B2, Matrix C2) {
        return this.transAmultAdd(1.0, B2, C2);
    }

    @Override
    public Matrix transAmultAdd(double alpha, Matrix B2, Matrix C2) {
        this.checkTransAmultAdd(B2, C2);
        if (alpha != 0.0) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                for (int j2 = 0; j2 < C2.numColumns(); ++j2) {
                    double dot = 0.0;
                    for (int k2 = 0; k2 < this.numRows; ++k2) {
                        dot += this.get(k2, i2) * B2.get(k2, j2);
                    }
                    C2.add(i2, j2, alpha * dot);
                }
            }
        }
        return C2;
    }

    protected void checkTransAmultAdd(Matrix B2, Matrix C2) {
        if (this.numRows != B2.numRows()) {
            throw new IndexOutOfBoundsException("A.numRows != B.numRows (" + this.numRows + " != " + B2.numRows() + ")");
        }
        if (this.numColumns != C2.numRows()) {
            throw new IndexOutOfBoundsException("A.numColumns != C.numRows (" + this.numColumns + " != " + C2.numRows() + ")");
        }
        if (B2.numColumns() != C2.numColumns()) {
            throw new IndexOutOfBoundsException("B.numColumns != C.numColumns (" + B2.numColumns() + " != " + C2.numColumns() + ")");
        }
    }

    @Override
    public Matrix transBmult(Matrix B2, Matrix C2) {
        return this.transBmult(1.0, B2, C2);
    }

    @Override
    public Matrix transBmult(double alpha, Matrix B2, Matrix C2) {
        return this.transBmultAdd(alpha, B2, C2.zero());
    }

    @Override
    public Matrix transBmultAdd(Matrix B2, Matrix C2) {
        return this.transBmultAdd(1.0, B2, C2);
    }

    @Override
    public Matrix transBmultAdd(double alpha, Matrix B2, Matrix C2) {
        this.checkTransBmultAdd(B2, C2);
        if (alpha != 0.0) {
            for (int i2 = 0; i2 < this.numRows; ++i2) {
                for (int j2 = 0; j2 < C2.numColumns(); ++j2) {
                    double dot = 0.0;
                    for (int k2 = 0; k2 < this.numColumns; ++k2) {
                        dot += this.get(i2, k2) * B2.get(j2, k2);
                    }
                    C2.add(i2, j2, alpha * dot);
                }
            }
        }
        return C2;
    }

    protected void checkTransBmultAdd(Matrix B2, Matrix C2) {
        if (this.numColumns != B2.numColumns()) {
            throw new IndexOutOfBoundsException("A.numColumns != B.numColumns (" + this.numColumns + " != " + B2.numColumns() + ")");
        }
        if (this.numRows != C2.numRows()) {
            throw new IndexOutOfBoundsException("A.numRows != C.numRows (" + this.numRows + " != " + C2.numRows() + ")");
        }
        if (B2.numRows() != C2.numColumns()) {
            throw new IndexOutOfBoundsException("B.numRows != C.numColumns (" + B2.numRows() + " != " + C2.numColumns() + ")");
        }
    }

    @Override
    public Matrix transABmult(Matrix B2, Matrix C2) {
        return this.transABmult(1.0, B2, C2);
    }

    @Override
    public Matrix transABmult(double alpha, Matrix B2, Matrix C2) {
        return this.transABmultAdd(alpha, B2, C2.zero());
    }

    @Override
    public Matrix transABmultAdd(Matrix B2, Matrix C2) {
        return this.transABmultAdd(1.0, B2, C2);
    }

    @Override
    public Matrix transABmultAdd(double alpha, Matrix B2, Matrix C2) {
        this.checkTransABmultAdd(B2, C2);
        if (alpha != 0.0) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                for (int j2 = 0; j2 < C2.numColumns(); ++j2) {
                    double dot = 0.0;
                    for (int k2 = 0; k2 < this.numRows; ++k2) {
                        dot += this.get(k2, i2) * B2.get(j2, k2);
                    }
                    C2.add(i2, j2, alpha * dot);
                }
            }
        }
        return C2;
    }

    protected void checkTransABmultAdd(Matrix B2, Matrix C2) {
        if (this.numRows != B2.numColumns()) {
            throw new IndexOutOfBoundsException("A.numRows != B.numColumns (" + this.numRows + " != " + B2.numColumns() + ")");
        }
        if (this.numColumns != C2.numRows()) {
            throw new IndexOutOfBoundsException("A.numColumns != C.numRows (" + this.numColumns + " != " + C2.numRows() + ")");
        }
        if (B2.numRows() != C2.numColumns()) {
            throw new IndexOutOfBoundsException("B.numRows != C.numColumns (" + B2.numRows() + " != " + C2.numColumns() + ")");
        }
    }

    @Override
    public Matrix solve(Matrix B2, Matrix X) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix transSolve(Matrix B2, Matrix X) {
        throw new UnsupportedOperationException();
    }

    protected void checkSolve(Matrix B2, Matrix X) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (B2.numRows() != this.numRows) {
            throw new IndexOutOfBoundsException("B.numRows != A.numRows (" + B2.numRows() + " != " + this.numRows + ")");
        }
        if (B2.numColumns() != X.numColumns()) {
            throw new IndexOutOfBoundsException("B.numColumns != X.numColumns (" + B2.numColumns() + " != " + X.numColumns() + ")");
        }
        if (X.numRows() != this.numColumns) {
            throw new IndexOutOfBoundsException("X.numRows != A.numColumns (" + X.numRows() + " != " + this.numColumns + ")");
        }
    }

    @Override
    public Matrix rank1(Matrix C2) {
        return this.rank1(1.0, C2);
    }

    @Override
    public Matrix rank1(double alpha, Matrix C2) {
        this.checkRank1(C2);
        if (alpha == 0.0) {
            return this;
        }
        return C2.transBmultAdd(alpha, C2, this);
    }

    protected void checkRank1(Matrix C2) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (this.numRows != C2.numRows()) {
            throw new IndexOutOfBoundsException("A.numRows != C.numRows (" + this.numRows + " != " + C2.numRows() + ")");
        }
    }

    @Override
    public Matrix transRank1(Matrix C2) {
        return this.transRank1(1.0, C2);
    }

    @Override
    public Matrix transRank1(double alpha, Matrix C2) {
        this.checkTransRank1(C2);
        if (alpha == 0.0) {
            return this;
        }
        return C2.transAmultAdd(alpha, C2, this);
    }

    protected void checkTransRank1(Matrix C2) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (this.numRows != C2.numColumns()) {
            throw new IndexOutOfBoundsException("A.numRows != C.numColumns (" + this.numRows + " != " + C2.numColumns() + ")");
        }
    }

    @Override
    public Matrix rank2(Matrix B2, Matrix C2) {
        return this.rank2(1.0, B2, C2);
    }

    @Override
    public Matrix rank2(double alpha, Matrix B2, Matrix C2) {
        this.checkRank2(B2, C2);
        if (alpha == 0.0) {
            return this;
        }
        return B2.transBmultAdd(alpha, C2, C2.transBmultAdd(alpha, B2, this));
    }

    protected void checkRank2(Matrix B2, Matrix C2) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (B2.numRows() != C2.numRows()) {
            throw new IndexOutOfBoundsException("B.numRows != C.numRows (" + B2.numRows() + " != " + C2.numRows() + ")");
        }
        if (B2.numColumns() != C2.numColumns()) {
            throw new IndexOutOfBoundsException("B.numColumns != C.numColumns (" + B2.numColumns() + " != " + C2.numColumns() + ")");
        }
    }

    @Override
    public Matrix transRank2(Matrix B2, Matrix C2) {
        return this.transRank2(1.0, B2, C2);
    }

    @Override
    public Matrix transRank2(double alpha, Matrix B2, Matrix C2) {
        this.checkTransRank2(B2, C2);
        if (alpha == 0.0) {
            return this;
        }
        return B2.transAmultAdd(alpha, C2, C2.transAmultAdd(alpha, B2, this));
    }

    protected void checkTransRank2(Matrix B2, Matrix C2) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (this.numRows != B2.numColumns()) {
            throw new IndexOutOfBoundsException("A.numRows != B.numColumns (" + this.numRows + " != " + B2.numColumns() + ")");
        }
        if (B2.numRows() != C2.numRows()) {
            throw new IndexOutOfBoundsException("B.numRows != C.numRows (" + B2.numRows() + " != " + C2.numRows() + ")");
        }
        if (B2.numColumns() != C2.numColumns()) {
            throw new IndexOutOfBoundsException("B.numColumns != C.numColumns (" + B2.numColumns() + " != " + C2.numColumns() + ")");
        }
    }

    @Override
    public Matrix scale(double alpha) {
        if (alpha == 1.0) {
            return this;
        }
        if (alpha == 0.0) {
            return this.zero();
        }
        for (MatrixEntry e2 : this) {
            e2.set(alpha * e2.get());
        }
        return this;
    }

    @Override
    public Matrix set(Matrix B2) {
        return this.set(1.0, B2);
    }

    @Override
    public Matrix set(double alpha, Matrix B2) {
        this.checkSize(B2);
        if (alpha == 0.0) {
            return this.zero();
        }
        if (B2 == this) {
            return this.scale(alpha);
        }
        this.zero();
        for (MatrixEntry e2 : B2) {
            if (e2.get() == 0.0) continue;
            this.set(e2.row(), e2.column(), alpha * e2.get());
        }
        return this;
    }

    @Override
    public Matrix add(Matrix B2) {
        return this.add(1.0, B2);
    }

    @Override
    public Matrix add(double alpha, Matrix B2) {
        this.checkSize(B2);
        if (alpha != 0.0) {
            for (MatrixEntry e2 : B2) {
                this.add(e2.row(), e2.column(), alpha * e2.get());
            }
        }
        return this;
    }

    protected void checkSize(Matrix B2) {
        if (this.numRows != B2.numRows()) {
            throw new IndexOutOfBoundsException("A.numRows != B.numRows (" + this.numRows + " != " + B2.numRows() + ")");
        }
        if (this.numColumns != B2.numColumns()) {
            throw new IndexOutOfBoundsException("A.numColumns != B.numColumns (" + this.numColumns + " != " + B2.numColumns() + ")");
        }
    }

    @Override
    public Matrix transpose() {
        this.checkTranspose();
        for (int j2 = 0; j2 < this.numColumns; ++j2) {
            for (int i2 = j2 + 1; i2 < this.numRows; ++i2) {
                double value = this.get(i2, j2);
                this.set(i2, j2, this.get(j2, i2));
                this.set(j2, i2, value);
            }
        }
        return this;
    }

    protected void checkTranspose() {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
    }

    @Override
    public Matrix transpose(Matrix B2) {
        this.checkTranspose(B2);
        if (B2 == this) {
            return this.transpose();
        }
        B2.zero();
        for (MatrixEntry e2 : this) {
            B2.set(e2.column(), e2.row(), e2.get());
        }
        return B2;
    }

    protected void checkTranspose(Matrix B2) {
        if (this.numRows != B2.numColumns()) {
            throw new IndexOutOfBoundsException("A.numRows != B.numColumns (" + this.numRows + " != " + B2.numColumns() + ")");
        }
        if (this.numColumns != B2.numRows()) {
            throw new IndexOutOfBoundsException("A.numColumns != B.numRows (" + this.numColumns + " != " + B2.numRows() + ")");
        }
    }

    @Override
    public double norm(Matrix.Norm type) {
        if (type == Matrix.Norm.One) {
            return this.norm1();
        }
        if (type == Matrix.Norm.Frobenius) {
            return this.normF();
        }
        if (type == Matrix.Norm.Infinity) {
            return this.normInf();
        }
        return this.max();
    }

    protected double norm1() {
        double[] rowSum = new double[this.numRows];
        for (MatrixEntry e2 : this) {
            int n2 = e2.row();
            rowSum[n2] = rowSum[n2] + Math.abs(e2.get());
        }
        return this.max(rowSum);
    }

    protected double normF() {
        double scale = 0.0;
        double ssq = 1.0;
        for (MatrixEntry e2 : this) {
            double Aval = e2.get();
            if (Aval == 0.0) continue;
            double absxi = Math.abs(Aval);
            if (scale < absxi) {
                ssq = 1.0 + ssq * Math.pow(scale / absxi, 2.0);
                scale = absxi;
                continue;
            }
            ssq += Math.pow(absxi / scale, 2.0);
        }
        return scale * Math.sqrt(ssq);
    }

    protected double normInf() {
        double[] columnSum = new double[this.numColumns];
        for (MatrixEntry e2 : this) {
            int n2 = e2.column();
            columnSum[n2] = columnSum[n2] + Math.abs(e2.get());
        }
        return this.max(columnSum);
    }

    protected double max() {
        double max = 0.0;
        for (MatrixEntry e2 : this) {
            max = Math.max(Math.abs(e2.get()), max);
        }
        return max;
    }

    protected double max(double[] x2) {
        double max = 0.0;
        for (int i2 = 0; i2 < x2.length; ++i2) {
            max = Math.max(x2[i2], max);
        }
        return max;
    }

    public String toString() {
        Formatter out = new Formatter();
        out.format("%10d %10d %19d\n", this.numRows, this.numColumns, Matrices.cardinality(this));
        int i2 = 0;
        for (MatrixEntry e2 : this) {
            if (e2.get() != 0.0) {
                out.format("%10d %10d % .12e\n", e2.row() + 1, e2.column() + 1, e2.get());
            }
            if (++i2 != 100) continue;
            out.format("...\n", new Object[0]);
            break;
        }
        return out.toString();
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new RefMatrixIterator();
    }

    class RefMatrixEntry
    implements MatrixEntry {
        private int row;
        private int column;

        RefMatrixEntry() {
        }

        public void update(int row, int column) {
            this.row = row;
            this.column = column;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return this.column;
        }

        @Override
        public double get() {
            return AbstractMatrix.this.get(this.row, this.column);
        }

        @Override
        public void set(double value) {
            AbstractMatrix.this.set(this.row, this.column, value);
        }
    }

    class RefMatrixIterator
    implements Iterator<MatrixEntry> {
        int row;
        int column;
        final RefMatrixEntry entry;

        RefMatrixIterator() {
            this.entry = new RefMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.row < AbstractMatrix.this.numRows && this.column < AbstractMatrix.this.numColumns;
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.row, this.column);
            if (this.row < AbstractMatrix.this.numRows - 1) {
                ++this.row;
            } else {
                ++this.column;
                this.row = 0;
            }
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

