/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Arrays;
import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;

abstract class AbstractBandMatrix
extends AbstractMatrix {
    double[] data;
    int kl;
    int ku;
    int n;

    public AbstractBandMatrix(int n2, int kl, int ku) {
        super(n2, n2);
        this.n = n2;
        if (kl < 0 || ku < 0) {
            throw new IllegalArgumentException("kl < 0 || ku < 0");
        }
        this.kl = kl;
        this.ku = ku;
        this.data = new double[this.numColumns * (1 + kl + ku)];
    }

    public AbstractBandMatrix(Matrix A2, int kl, int ku) {
        this(A2, kl, ku, true);
    }

    public AbstractBandMatrix(Matrix A2, int kl, int ku, boolean deep) {
        super(A2);
        if (kl < 0 || ku < 0) {
            throw new IllegalArgumentException("kl < 0 || ku < 0");
        }
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Band matrix must be square");
        }
        this.n = this.numRows;
        this.kl = kl;
        this.ku = ku;
        if (deep) {
            this.data = new double[this.numColumns * (1 + kl + ku)];
            this.copy(A2);
        } else {
            this.data = ((AbstractBandMatrix)A2).getData();
        }
    }

    public double[] getData() {
        return this.data;
    }

    @Override
    public void add(int row, int column, double value) {
        this.checkBand(row, column);
        int n2 = this.getIndex(row, column);
        this.data[n2] = this.data[n2] + value;
    }

    @Override
    public void set(int row, int column, double value) {
        this.checkBand(row, column);
        this.data[this.getIndex((int)row, (int)column)] = value;
    }

    @Override
    public double get(int row, int column) {
        if (!this.inBand(row, column)) {
            return 0.0;
        }
        return this.data[this.getIndex(row, column)];
    }

    public int numSubDiagonals() {
        return this.kl;
    }

    public int numSuperDiagonals() {
        return this.ku;
    }

    boolean inBand(int row, int column) {
        return column - this.ku <= row && row <= column + this.kl;
    }

    void checkBand(int row, int column) {
        if (!this.inBand(row, column)) {
            throw new IndexOutOfBoundsException("Insertion index out of band");
        }
    }

    int getIndex(int row, int column) {
        this.check(row, column);
        return this.ku + row - column + column * (this.kl + this.ku + 1);
    }

    void copy(Matrix A2) {
        for (MatrixEntry e2 : A2) {
            if (!this.inBand(e2.row(), e2.column())) continue;
            this.set(e2.row(), e2.column(), e2.get());
        }
    }

    @Override
    public Matrix set(Matrix B2) {
        if (!(B2 instanceof AbstractBandMatrix)) {
            return super.set(B2);
        }
        this.checkSize(B2);
        AbstractBandMatrix Bb = (AbstractBandMatrix)B2;
        if (Bb.kl != this.kl) {
            throw new IllegalArgumentException("B.kl != kl");
        }
        if (Bb.ku != this.ku) {
            throw new IllegalArgumentException("B.ku != ku");
        }
        double[] Bd = Bb.getData();
        if (Bd == this.data) {
            return this;
        }
        System.arraycopy(Bd, 0, this.data, 0, this.data.length);
        return this;
    }

    @Override
    public Matrix zero() {
        Arrays.fill(this.data, 0.0);
        return this;
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new BandMatrixIterator();
    }

    class BandMatrixIterator
    extends AbstractMatrix.RefMatrixIterator {
        private final int lkl;
        private final int lku;

        public BandMatrixIterator(int lkl, int lku) {
            this.lkl = lkl;
            this.lku = lku;
        }

        public BandMatrixIterator() {
            this(this$0.kl, this$0.ku);
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.row, this.column);
            if (this.row < Math.min(this.column + this.lkl, AbstractBandMatrix.this.n - 1) && this.row >= Math.max(this.column - this.lku, 0)) {
                ++this.row;
            } else {
                ++this.column;
                this.row = Math.max(this.column - this.lku, 0);
            }
            return this.entry;
        }
    }
}

