/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.server;

import java.util.Properties;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.server.DukeController;
import no.priv.garshol.duke.server.DukeTimer;

public class BasicTimer
implements DukeTimer,
Runnable {
    private DukeController controller;
    private int check_interval;
    private int sleep_interval = 100;
    private boolean keep_running;

    @Override
    public void init(Properties props) {
    }

    @Override
    public void spawnThread(DukeController controller, int check_interval) {
        if (this.controller != null) {
            throw new DukeException("Timer thread already running!");
        }
        this.controller = controller;
        this.check_interval = check_interval * 1000;
        this.keep_running = true;
        Thread thread2 = new Thread(this);
        thread2.setDaemon(true);
        thread2.start();
    }

    @Override
    public boolean isRunning() {
        return this.keep_running;
    }

    @Override
    public void stop() {
        this.controller = null;
        this.keep_running = false;
    }

    @Override
    public void run() {
        block4: while (this.keep_running) {
            try {
                this.controller.process();
                long wait_start = System.currentTimeMillis();
                do {
                    Thread.sleep(this.sleep_interval);
                    if (!this.keep_running) continue block4;
                } while (System.currentTimeMillis() - wait_start < (long)this.check_interval);
            }
            catch (Throwable e2) {
                this.controller.reportError(e2);
                try {
                    Thread.sleep(this.getErrorWaitInteral());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.controller.reportStopped();
    }

    private int getErrorWaitInteral() {
        return this.check_interval * 6;
    }
}

