/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.matchers;

import java.util.Iterator;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.EquivalenceClassDatabase;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.matchers.AbstractMatchListener;
import no.priv.garshol.duke.matchers.PrintMatchListener;

public class ClassDatabaseMatchListener
extends AbstractMatchListener {
    private Configuration config;
    protected EquivalenceClassDatabase classdb;

    public ClassDatabaseMatchListener(Configuration config, EquivalenceClassDatabase classdb) {
        this.config = config;
        this.classdb = classdb;
    }

    @Override
    public void matches(Record r1, Record r2, double confidence) {
        String id1 = this.getIdentity(r1);
        String id2 = this.getIdentity(r2);
        this.classdb.addLink(id1, id2);
    }

    @Override
    public void batchDone() {
        this.classdb.commit();
    }

    private String getIdentity(Record r2) {
        for (Property p2 : this.config.getIdentityProperties()) {
            Iterator<String> i$ = r2.getValues(p2.getName()).iterator();
            if (!i$.hasNext()) continue;
            String v2 = i$.next();
            return v2;
        }
        throw new RuntimeException("No identity found in record [" + PrintMatchListener.toString(r2) + "]");
    }
}

