/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.genetic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.priv.garshol.duke.ConfigWriter;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.DataSource;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.InMemoryLinkDatabase;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.LinkKind;
import no.priv.garshol.duke.LinkStatus;
import no.priv.garshol.duke.Processor;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.genetic.ConsoleOracle;
import no.priv.garshol.duke.genetic.ExemplarsTracker;
import no.priv.garshol.duke.genetic.GeneticConfiguration;
import no.priv.garshol.duke.genetic.GeneticPopulation;
import no.priv.garshol.duke.genetic.LinkFileOracle;
import no.priv.garshol.duke.genetic.Oracle;
import no.priv.garshol.duke.genetic.Pair;
import no.priv.garshol.duke.matchers.MatchListener;
import no.priv.garshol.duke.matchers.PrintMatchListener;
import no.priv.garshol.duke.matchers.TestFileListener;
import no.priv.garshol.duke.utils.LinkDatabaseUtils;

public class GeneticAlgorithm {
    private Configuration config;
    private GeneticPopulation population;
    private Database database;
    private Map<String, Record> secondary;
    private InMemoryLinkDatabase testdb;
    private double best;
    private boolean active;
    private boolean scientific;
    private Oracle oracle;
    private String outfile;
    private Map<GeneticConfiguration, Double> sciencetracker;
    private int threads;
    private int generations;
    private int questions;
    private boolean sparse;
    private int skipgens;
    private int asked;

    public GeneticAlgorithm(Configuration config, String testfile, boolean scientific) throws IOException {
        this.config = config;
        this.population = new GeneticPopulation(config);
        this.generations = 100;
        this.questions = 10;
        this.testdb = new InMemoryLinkDatabase();
        this.testdb.setDoInference(true);
        this.scientific = scientific;
        this.threads = 1;
        if (!scientific) {
            this.oracle = new ConsoleOracle();
            if (testfile != null) {
                LinkDatabaseUtils.loadTestFile(testfile, (LinkDatabase)this.testdb);
            } else {
                this.active = true;
            }
        } else {
            this.active = true;
            this.oracle = new LinkFileOracle(testfile);
            this.sciencetracker = new HashMap<GeneticConfiguration, Double>();
        }
    }

    public void setGenerations(int generations) {
        this.generations = generations;
    }

    public void setPopulation(int population) {
        this.population.setSize(population);
    }

    public void setQuestions(int questions) {
        this.questions = questions;
    }

    public void setConfigOutput(String output) {
        this.outfile = output;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setSparse(boolean sparse) {
        this.sparse = sparse;
    }

    public void setLinkFile(String linkfile) throws IOException {
        if (this.scientific || !this.active || this.oracle instanceof LinkFileOracle) {
            throw new DukeConfigException("Have no use for link file");
        }
        ((ConsoleOracle)this.oracle).setLinkFile(linkfile);
    }

    public void run() {
        RecordIterator it;
        Collection<DataSource> sources = this.config.isDeduplicationMode() ? this.config.getDataSources() : this.config.getDataSources(1);
        this.database = this.config.getDatabase(true);
        for (DataSource src : sources) {
            it = src.getRecords();
            while (it.hasNext()) {
                this.database.index((Record)it.next());
            }
        }
        this.database.commit();
        if (!this.config.isDeduplicationMode() && this.active) {
            this.secondary = new HashMap<String, Record>();
            for (DataSource src : this.config.getDataSources(2)) {
                it = src.getRecords();
                while (it.hasNext()) {
                    Record r2 = (Record)it.next();
                    this.secondary.put(this.getid(r2), r2);
                }
            }
        }
        this.population.create();
        for (int gen = 0; gen < this.generations; ++gen) {
            System.out.println("===== GENERATION " + gen);
            this.evolve(gen);
        }
    }

    public void evolve(int gen_no) {
        List<GeneticConfiguration> pop = this.population.getConfigs();
        ExemplarsTracker tracker = null;
        if (this.active) {
            Comparator<Pair> comparator = gen_no == 0 ? new FindCorrectComparator() : new DisagreementComparator();
            tracker = new ExemplarsTracker(this.config, comparator);
        }
        for (GeneticConfiguration cfg : pop) {
            double f2 = this.evaluate(cfg, tracker);
            cfg.setFNumber(f2);
            System.out.print("  " + f2);
            if (f2 > this.best) {
                System.out.println("\nNEW BEST!\n");
                this.best = f2;
            }
            if (this.scientific) {
                System.out.println("  (actual: " + this.sciencetracker.get(cfg) + ")");
                continue;
            }
            System.out.println();
        }
        this.population.sort();
        double fsum = 0.0;
        double lbest = -1.0;
        GeneticConfiguration best = null;
        for (GeneticConfiguration cfg : pop) {
            fsum += cfg.getFNumber();
            if (!(cfg.getFNumber() > lbest)) continue;
            lbest = cfg.getFNumber();
            best = cfg;
        }
        System.out.println("BEST: " + lbest + " AVERAGE: " + fsum / (double)pop.size());
        for (GeneticConfiguration cfg : this.population.getConfigs()) {
            System.out.print(cfg.getFNumber() + " ");
        }
        System.out.println();
        if (this.active && this.skipgens == 0) {
            this.askQuestions(tracker);
            if (this.sparse) {
                if (gen_no > 9) {
                    this.skipgens = 3;
                } else if (gen_no > 1) {
                    this.skipgens = 1;
                }
            }
        } else if (this.skipgens > 0) {
            --this.skipgens;
        }
        if (this.scientific) {
            double devsum = 0.0;
            fsum = 0.0;
            lbest = -1.0;
            for (GeneticConfiguration cfg : pop) {
                double real = this.sciencetracker.get(cfg);
                devsum += Math.abs(cfg.getFNumber() - real);
                fsum += real;
                if (!(real > lbest)) continue;
                lbest = real;
            }
            System.out.println("ACTUAL BEST: " + this.sciencetracker.get(best) + " ACTUAL AVERAGE: " + fsum / (double)pop.size());
            System.out.println("AVERAGE DEVIATION: " + devsum / (double)pop.size());
            System.out.println("QUESTIONS ASKED: " + this.asked);
            System.out.println();
            this.sciencetracker.clear();
        }
        if (this.outfile != null) {
            try {
                Configuration b2 = this.population.getBestConfiguration().getConfiguration();
                ConfigWriter.write(b2, this.outfile);
            }
            catch (IOException e2) {
                System.err.println("ERROR: Cannot write to '" + this.outfile + "': " + e2);
            }
        }
        if (this.active && this.population.getBestConfiguration().getFNumber() == this.population.getWorstConfiguration().getFNumber()) {
            return;
        }
        int size = pop.size();
        ArrayList<GeneticConfiguration> nextgen = new ArrayList<GeneticConfiguration>(size);
        for (GeneticConfiguration cfg : pop.subList(0, (int)((double)size * 0.02))) {
            nextgen.add(new GeneticConfiguration(cfg));
        }
        for (GeneticConfiguration cfg : pop.subList(0, (int)((double)size * 0.03))) {
            nextgen.add(new GeneticConfiguration(cfg));
        }
        int start = (int)((double)size * 0.25);
        for (GeneticConfiguration cfg : pop.subList(0, start)) {
            nextgen.add(new GeneticConfiguration(cfg));
        }
        for (GeneticConfiguration cfg : pop.subList(0, start)) {
            nextgen.add(new GeneticConfiguration(cfg));
        }
        int remaining = pop.size() - nextgen.size();
        for (GeneticConfiguration cfg : pop.subList(start, start + remaining)) {
            nextgen.add(new GeneticConfiguration(cfg));
        }
        if (nextgen.size() > size) {
            nextgen = nextgen.subList(0, size);
        }
        for (GeneticConfiguration cfg : nextgen) {
            if (Math.random() <= 0.75) {
                cfg.mutate();
                continue;
            }
            cfg.mateWith(this.population.pickRandomConfig());
        }
        this.population.setNewGeneration(nextgen);
    }

    private double evaluate(GeneticConfiguration config, MatchListener listener) {
        System.out.println(config);
        Configuration cconfig = config.getConfiguration();
        Processor proc = new Processor(cconfig, this.database);
        TestFileListener eval = this.makeEval(cconfig, this.testdb, proc);
        eval.setPessimistic(!this.active);
        proc.addMatchListener(eval);
        TestFileListener seval = null;
        if (this.scientific) {
            seval = this.makeEval(cconfig, ((LinkFileOracle)this.oracle).getLinkDatabase(), proc);
            seval.setPessimistic(true);
            proc.addMatchListener(seval);
        }
        proc.setThreads(this.threads);
        if (listener != null) {
            proc.addMatchListener(listener);
        }
        if (cconfig.isDeduplicationMode()) {
            proc.linkRecords(cconfig.getDataSources());
        } else {
            proc.linkRecords(cconfig.getDataSources(2), false);
        }
        if (seval != null) {
            this.sciencetracker.put(config, seval.getFNumber());
        }
        return eval.getFNumber();
    }

    private TestFileListener makeEval(Configuration cfg, LinkDatabase testdb, Processor proc) {
        TestFileListener eval = new TestFileListener(testdb, cfg, false, proc, false, false);
        eval.setQuiet(true);
        return eval;
    }

    public GeneticConfiguration getBestConfiguration() {
        return this.population.getBestConfiguration();
    }

    public GeneticPopulation getPopulation() {
        return this.population;
    }

    private void askQuestions(ExemplarsTracker tracker) {
        int count2 = 0;
        for (Pair pair : tracker.getExemplars()) {
            if (this.testdb.inferLink(pair.id1, pair.id2) != null) continue;
            Record r1 = this.database.findRecordById(pair.id1);
            if (r1 == null) {
                r1 = this.secondary.get(pair.id1);
            }
            Record r2 = this.database.findRecordById(pair.id2);
            System.out.println();
            PrintMatchListener.prettyCompare(r1, r2, pair.counter, "Possible match", this.config.getProperties());
            LinkKind kind = this.oracle.getLinkKind(pair.id1, pair.id2);
            Link link = new Link(pair.id1, pair.id2, LinkStatus.ASSERTED, kind, 1.0);
            this.testdb.assertLink(link);
            if (++count2 != this.questions) continue;
            break;
        }
        this.asked += count2;
    }

    private String getid(Record r2) {
        for (String propname : r2.getProperties()) {
            if (!this.config.getPropertyByName(propname).isIdProperty()) continue;
            return r2.getValue(propname);
        }
        return null;
    }

    class DisagreementComparator
    implements Comparator<Pair> {
        DisagreementComparator() {
        }

        @Override
        public int compare(Pair p1, Pair p2) {
            int size = GeneticAlgorithm.this.population.size();
            return this.getScore(p2) - this.getScore(p1);
        }

        private int getScore(Pair pair) {
            int size = GeneticAlgorithm.this.population.size();
            return (size - pair.counter) * (size - (size - pair.counter));
        }
    }

    static class FindCorrectComparator
    implements Comparator<Pair> {
        FindCorrectComparator() {
        }

        @Override
        public int compare(Pair p1, Pair p2) {
            return p2.counter - p1.counter;
        }
    }
}

