/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.genetic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.genetic.Pair;
import no.priv.garshol.duke.matchers.AbstractMatchListener;

public class ExemplarsTracker
extends AbstractMatchListener {
    private Map<Pair, Pair> exemplars;
    private Configuration config;
    private Comparator comparator;

    public ExemplarsTracker(Configuration config, Comparator comparator) {
        this.config = config;
        this.exemplars = new HashMap<Pair, Pair>();
        this.comparator = comparator;
    }

    @Override
    public synchronized void matches(Record r1, Record r2, double confidence) {
        Pair key = new Pair(this.getid(r1), this.getid(r2));
        Pair counter = this.exemplars.get(key);
        if (counter == null) {
            this.exemplars.put(key, key);
            counter = key;
        }
        ++counter.counter;
    }

    public Collection<Pair> getExemplars() {
        ArrayList<Pair> sorted = new ArrayList<Pair>(this.exemplars.size());
        sorted.addAll(this.exemplars.keySet());
        Collections.sort(sorted, this.comparator);
        return sorted;
    }

    private String getid(Record r2) {
        for (String propname : r2.getProperties()) {
            if (!this.config.getPropertyByName(propname).isIdProperty()) continue;
            return r2.getValue(propname);
        }
        return null;
    }
}

