/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.util.Collection;
import no.priv.garshol.duke.Cleaner;
import no.priv.garshol.duke.CompactRecord;
import no.priv.garshol.duke.ModifiableRecord;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.ColumnarDataSource;

public class RecordBuilder {
    private ColumnarDataSource source;
    private ModifiableRecord record;

    public RecordBuilder(ColumnarDataSource source) {
        this.source = source;
    }

    public void newRecord() {
        this.record = new CompactRecord();
    }

    public boolean isRecordEmpty() {
        return this.record.isEmpty();
    }

    public void addValue(String column, String value) {
        Collection<Column> cols = this.source.getColumn(column);
        if (cols == null || cols.isEmpty()) {
            return;
        }
        Column col = cols.iterator().next();
        this.addValue(col, value);
    }

    public void addValue(Column col, String value) {
        if (value == null || value.equals("")) {
            return;
        }
        String prop = col.getProperty();
        Cleaner cleaner = col.getCleaner();
        if (col.isSplit()) {
            for (String v2 : col.split(value)) {
                if (cleaner != null) {
                    v2 = cleaner.clean(v2);
                }
                if (v2 == null || v2.equals("")) continue;
                this.record.addValue(prop, v2);
            }
        } else {
            if (cleaner != null) {
                value = cleaner.clean(value);
            }
            if (value != null && !value.equals("")) {
                this.record.addValue(prop, value);
            }
        }
    }

    public void setValue(String column, String value) {
        Collection<Column> cols = this.source.getColumn(column);
        Column col = cols.iterator().next();
        this.setValue(col, value);
    }

    public void setValue(Column col, String value) {
        if (col.getCleaner() != null) {
            value = col.getCleaner().clean(value);
        }
        if (value == null || value.equals("")) {
            return;
        }
        this.record.addValue(col.getProperty(), value);
    }

    public Record getRecord() {
        return this.record;
    }
}

