/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;

public class InMemoryDatabase
implements Database {
    private Configuration config;
    private Map<String, Record> idindex = new HashMap<String, Record>();
    private Collection<Record> records = new ArrayList<Record>();

    @Override
    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    @Override
    public void setOverwrite(boolean overwrite) {
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public void index(Record record) {
        for (Property p2 : this.config.getIdentityProperties()) {
            Collection<String> values = record.getValues(p2.getName());
            if (values == null) continue;
            for (String id : values) {
                this.idindex.put(id, record);
            }
        }
        this.records.add(record);
    }

    @Override
    public Record findRecordById(String id) {
        return this.idindex.get(id);
    }

    @Override
    public Collection<Record> findCandidateMatches(Record record) {
        return this.records;
    }

    @Override
    public void commit() {
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "InMemoryDatabase";
    }
}

