/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.comparators.GeopositionComparator;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;

public class GeoProperty {
    private Property prop;
    private SpatialContext spatialctx;
    private SpatialStrategy strategy;

    public GeoProperty(Property prop) {
        this.prop = prop;
        this.spatialctx = SpatialContext.GEO;
        int maxlevels = 11;
        GeohashPrefixTree grid = new GeohashPrefixTree(this.spatialctx, maxlevels);
        this.strategy = new RecursivePrefixTreeStrategy((SpatialPrefixTree)grid, prop.getName());
    }

    public String getName() {
        return this.prop.getName();
    }

    public IndexableField[] createIndexableFields(String value) {
        return this.strategy.createIndexableFields((Shape)this.parsePoint(value));
    }

    public Filter geoSearch(String value) {
        GeopositionComparator comp = (GeopositionComparator)this.prop.getComparator();
        double dist = comp.getMaxDistance();
        double degrees2 = DistanceUtils.dist2Degrees((double)dist, (double)6371008.7714);
        Circle circle = this.spatialctx.makeCircle(this.parsePoint(value), degrees2);
        SpatialArgs args = new SpatialArgs(SpatialOperation.Intersects, (Shape)circle);
        return this.strategy.makeFilter(args);
    }

    private Point parsePoint(String point) {
        int comma = point.indexOf(44);
        if (comma == -1) {
            return null;
        }
        float lat = Float.valueOf(point.substring(0, comma)).floatValue();
        float lng = Float.valueOf(point.substring(comma + 1)).floatValue();
        return this.spatialctx.makePoint((double)lng, (double)lat);
    }
}

