/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.databases.KeyFunction;

public abstract class AbstractBlockingDatabase
implements Database {
    protected Configuration config;
    protected Collection<KeyFunction> functions = new ArrayList<KeyFunction>();
    protected Map<String, Record> idmap;
    protected Map<KeyFunction, NavigableMap> func_to_map = new HashMap<KeyFunction, NavigableMap>();
    protected int window_size = 5;

    @Override
    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    @Override
    public void setOverwrite(boolean overwrite) {
    }

    public void setWindowSize(int window_size) {
        this.window_size = window_size;
    }

    public void setKeyFunctions(Collection<KeyFunction> functions2) {
        this.functions = functions2;
    }

    public Collection<KeyFunction> getKeyFunctions() {
        return this.functions;
    }

    protected void indexById(Record record) {
        for (Property idprop : this.config.getIdentityProperties()) {
            for (String id : record.getValues(idprop.getName())) {
                this.idmap.put(id, record);
            }
        }
    }

    @Override
    public Record findRecordById(String id) {
        return this.idmap.get(id);
    }

    @Override
    public Collection<Record> findCandidateMatches(Record record) {
        HashSet<Record> candidates = new HashSet<Record>();
        for (KeyFunction keyfunc : this.functions) {
            int added_this_way;
            int added;
            Map.Entry start;
            NavigableMap blocks = this.getBlocks(keyfunc);
            String key = keyfunc.makeKey(record);
            Map.Entry entry = start = blocks.ceilingEntry(key);
            if (start == null || (added = this.addBlock(candidates, start)) > this.window_size * 2) continue;
            entry = blocks.lowerEntry(entry.getKey());
            for (added_this_way = added / 2; entry != null && added_this_way < this.window_size; added_this_way += this.addBlock(candidates, entry)) {
                entry = blocks.lowerEntry(entry.getKey());
            }
            entry = blocks.higherEntry(start.getKey());
            for (added_this_way = added / 2; entry != null && added_this_way < this.window_size; added_this_way += this.addBlock(candidates, entry)) {
                entry = blocks.higherEntry(entry.getKey());
            }
        }
        return candidates;
    }

    @Override
    public void commit() {
    }

    @Override
    public void close() {
    }

    public NavigableMap getBlocks(KeyFunction keyfunc) {
        NavigableMap map = this.func_to_map.get(keyfunc);
        if (map == null) {
            map = this.makeMap(keyfunc);
            this.func_to_map.put(keyfunc, map);
        }
        return map;
    }

    protected abstract int addBlock(Collection<Record> var1, Map.Entry var2);

    protected abstract NavigableMap makeMap(KeyFunction var1);
}

