/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.priv.garshol.duke.Cleaner;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.ConfigurationImpl;
import no.priv.garshol.duke.DataSource;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.PropertyImpl;
import no.priv.garshol.duke.cleaners.ChainedCleaner;
import no.priv.garshol.duke.datasources.CSVDataSource;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.ColumnarDataSource;
import no.priv.garshol.duke.datasources.JDBCDataSource;
import no.priv.garshol.duke.datasources.JNDIDataSource;
import no.priv.garshol.duke.datasources.NTriplesDataSource;
import no.priv.garshol.duke.datasources.SparqlDataSource;
import no.priv.garshol.duke.utils.ObjectUtils;
import no.priv.garshol.duke.utils.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ConfigLoader {
    public static Configuration load(String file) throws IOException, SAXException {
        ConfigurationImpl cfg = new ConfigurationImpl();
        XMLReader parser = XMLReaderFactory.createXMLReader();
        parser.setContentHandler(new ConfigHandler(cfg));
        if (file.startsWith("classpath:")) {
            String resource = file.substring("classpath:".length());
            ClassLoader cloader = Thread.currentThread().getContextClassLoader();
            InputStream istream = cloader.getResourceAsStream(resource);
            parser.parse(new InputSource(istream));
        } else {
            parser.parse(file);
        }
        return cfg;
    }

    private static Object instantiate(String classname) {
        try {
            Class<?> klass = Class.forName(classname);
            return klass.newInstance();
        }
        catch (Exception e2) {
            throw new DukeConfigException("Couldn't instantiate class " + classname + ": " + e2);
        }
    }

    private static class ConfigHandler
    extends DefaultHandler {
        private ConfigurationImpl config;
        private List<Property> properties;
        private double low;
        private double high;
        private String name;
        private boolean idprop;
        private boolean ignore_prop;
        private Comparator comparator;
        private Property.Lookup lookup;
        private Set<String> keepers;
        private int groupno;
        private Map<String, Object> objects;
        private DataSource datasource;
        private Object currentobj;
        private Database database;
        private boolean keep;
        private StringBuffer content;

        private ConfigHandler(ConfigurationImpl config) {
            this.config = config;
            this.properties = new ArrayList<Property>();
            this.objects = new HashMap<String, Object>();
            this.keepers = new HashSet<String>();
            this.content = new StringBuffer();
            this.keepers.add("threshold");
            this.keepers.add("maybe-threshold");
            this.keepers.add("name");
            this.keepers.add("low");
            this.keepers.add("high");
            this.keepers.add("comparator");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.keepers.contains(localName)) {
                this.keep = true;
                this.content.setLength(0);
            } else if (localName.equals("property")) {
                String type = attributes.getValue("type");
                this.idprop = type != null && type.equals("id");
                this.ignore_prop = type != null && type.equals("ignore");
                this.low = 0.5;
                this.high = 0.5;
                this.comparator = null;
                this.lookup = Property.Lookup.DEFAULT;
                if (attributes.getValue("lookup") != null) {
                    this.lookup = (Property.Lookup)((Object)ObjectUtils.getEnumConstantByName(Property.Lookup.class, attributes.getValue("lookup").toUpperCase()));
                }
            } else if (localName.equals("csv")) {
                this.datasource = new CSVDataSource();
                this.currentobj = this.datasource;
            } else if (localName.equals("jdbc")) {
                this.datasource = new JDBCDataSource();
                this.currentobj = this.datasource;
            } else if (localName.equals("jndi")) {
                this.datasource = new JNDIDataSource();
                this.currentobj = this.datasource;
            } else if (localName.equals("sparql")) {
                this.datasource = new SparqlDataSource();
                this.currentobj = this.datasource;
            } else if (localName.equals("ntriples")) {
                this.datasource = new NTriplesDataSource();
                this.currentobj = this.datasource;
            } else if (localName.equals("data-source")) {
                this.datasource = (DataSource)ConfigLoader.instantiate(attributes.getValue("class"));
                this.currentobj = this.datasource;
            } else if (localName.equals("column")) {
                if (!(this.datasource instanceof ColumnarDataSource)) {
                    throw new DukeConfigException("Column inside data source which does not support it: " + this.datasource);
                }
                String name = attributes.getValue("name");
                if (name == null) {
                    throw new DukeConfigException("Column with no name");
                }
                String property = attributes.getValue("property");
                String prefix = attributes.getValue("prefix");
                String cleanername = attributes.getValue("cleaner");
                Cleaner cleaner = this.makeCleaner(cleanername);
                Column c2 = new Column(name, property, prefix, cleaner);
                String spliton = attributes.getValue("split-on");
                if (spliton != null) {
                    c2.setSplitOn(spliton);
                }
                ((ColumnarDataSource)this.datasource).addColumn(c2);
            } else if (localName.equals("param")) {
                if (this.currentobj == null) {
                    throw new DukeConfigException("Trying to set parameter " + attributes.getValue("name") + " but no current object");
                }
                ObjectUtils.setBeanProperty(this.currentobj, attributes.getValue("name"), attributes.getValue("value"), this.objects);
            } else if (localName.equals("group")) {
                ++this.groupno;
                if (this.groupno == 1 && !this.config.getDataSources().isEmpty()) {
                    throw new DukeConfigException("Cannot have groups in deduplication mode");
                }
                if (this.groupno == 3) {
                    throw new DukeConfigException("Record linkage mode only supports two groups");
                }
            } else if (localName.equals("object")) {
                String klass = attributes.getValue("class");
                String name = attributes.getValue("name");
                this.currentobj = ConfigLoader.instantiate(klass);
                this.objects.put(name, this.currentobj);
            } else if (localName.equals("database")) {
                String klass = attributes.getValue("class");
                if (klass == null) {
                    klass = "no.priv.garshol.duke.LuceneDatabase";
                }
                this.database = (Database)ConfigLoader.instantiate(klass);
                this.currentobj = this.database;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.keep) {
                this.content.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (localName.equals("threshold")) {
                this.config.setThreshold(Double.parseDouble(this.content.toString()));
            } else if (localName.equals("maybe-threshold")) {
                this.config.setMaybeThreshold(Double.parseDouble(this.content.toString()));
            } else if (localName.equals("name")) {
                this.name = this.content.toString();
            } else if (localName.equals("property")) {
                if (this.idprop) {
                    this.properties.add(new PropertyImpl(this.name));
                } else {
                    PropertyImpl p2 = new PropertyImpl(this.name, this.comparator, this.low, this.high);
                    if (this.ignore_prop) {
                        p2.setIgnoreProperty(true);
                    }
                    p2.setLookupBehaviour(this.lookup);
                    this.properties.add(p2);
                }
            } else if (localName.equals("low")) {
                this.low = Double.parseDouble(this.content.toString());
            } else if (localName.equals("high")) {
                this.high = Double.parseDouble(this.content.toString());
            } else if (localName.equals("comparator")) {
                this.comparator = (Comparator)this.objects.get(this.content.toString());
                if (this.comparator == null) {
                    this.comparator = (Comparator)ConfigLoader.instantiate(this.content.toString());
                }
            } else if (localName.equals("csv") || localName.equals("jdbc") || localName.equals("jndi") || localName.equals("ntriples") || localName.equals("sparql") || localName.equals("data-source")) {
                this.config.addDataSource(this.groupno, this.datasource);
                this.datasource = null;
                this.currentobj = null;
            } else if (localName.equals("object")) {
                this.currentobj = null;
            } else if (localName.equals("database")) {
                this.config.setDatabase(this.database);
            }
            if (this.keepers.contains(localName)) {
                this.keep = false;
            } else if (localName.equals("duke") && this.groupno > 0 && this.groupno != 2) {
                throw new DukeConfigException("Record linkage mode requires exactly 2 groups; should you be using deduplication mode?");
            }
        }

        @Override
        public void endDocument() {
            this.config.setProperties(this.properties);
        }

        private Cleaner makeCleaner(String value) {
            if (value == null) {
                return null;
            }
            String[] names = StringUtils.split(value);
            Cleaner[] cleaners = new Cleaner[names.length];
            for (int ix = 0; ix < cleaners.length; ++ix) {
                cleaners[ix] = this._makeCleaner(names[ix]);
            }
            if (cleaners.length == 1) {
                return cleaners[0];
            }
            return new ChainedCleaner(cleaners);
        }

        private Cleaner _makeCleaner(String name) {
            Cleaner cleaner = (Cleaner)this.objects.get(name);
            if (cleaner == null) {
                cleaner = (Cleaner)ConfigLoader.instantiate(name);
            }
            return cleaner;
        }
    }
}

