/*
 * Decompiled with CFR 0.152.
 */
package jsr166y;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import jsr166y.ThreadLocalRandom;
import jsr166y.TransferQueue;
import sun.misc.Unsafe;
import water.H2ORuntime;

public class LinkedTransferQueue<E>
extends AbstractQueue<E>
implements TransferQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    private static final boolean MP = H2ORuntime.availableProcessors() > 1;
    private static final int FRONT_SPINS = 128;
    private static final int CHAINED_SPINS = 64;
    static final int SWEEP_THRESHOLD = 32;
    volatile transient Node head;
    private volatile transient Node tail;
    private volatile transient int sweepVotes;
    private static final int NOW = 0;
    private static final int ASYNC = 1;
    private static final int SYNC = 2;
    private static final int TIMED = 3;
    private static final Unsafe UNSAFE;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long sweepVotesOffset;

    private boolean casTail(Node cmp, Node val) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, cmp, val);
    }

    private boolean casHead(Node cmp, Node val) {
        return UNSAFE.compareAndSwapObject(this, headOffset, cmp, val);
    }

    private boolean casSweepVotes(int cmp, int val) {
        return UNSAFE.compareAndSwapInt(this, sweepVotesOffset, cmp, val);
    }

    static <E> E cast(Object item) {
        return (E)item;
    }

    private E xfer(E e2, boolean haveData, int how, long nanos) {
        block8: {
            Node pred;
            if (haveData && e2 == null) {
                throw new NullPointerException();
            }
            Node s2 = null;
            do {
                Node h2;
                Node p2 = h2 = this.head;
                while (p2 != null) {
                    Node n2;
                    boolean isData = p2.isData;
                    Object item = p2.item;
                    if (item != p2 && item != null == isData) {
                        if (isData == haveData) break;
                        if (p2.casItem(item, e2)) {
                            Node q2 = p2;
                            while (q2 != h2) {
                                Node n3 = q2.next;
                                if (this.head == h2 && this.casHead(h2, n3 == null ? q2 : n3)) {
                                    h2.forgetNext();
                                    break;
                                }
                                h2 = this.head;
                                if (h2 != null && (q2 = h2.next) != null && q2.isMatched()) continue;
                                break;
                            }
                            LockSupport.unpark(p2.waiter);
                            return LinkedTransferQueue.cast(item);
                        }
                    }
                    p2 = p2 != (n2 = p2.next) ? n2 : this.head;
                }
                if (how == 0) break block8;
                if (s2 != null) continue;
                s2 = new Node(e2, haveData);
            } while ((pred = this.tryAppend(s2, haveData)) == null);
            if (how != 1) {
                return this.awaitMatch(s2, pred, e2, how == 3, nanos);
            }
        }
        return e2;
    }

    private Node tryAppend(Node s2, boolean haveData) {
        Node t2;
        Node p2 = t2 = this.tail;
        while (true) {
            if (p2 == null && (p2 = this.head) == null) {
                if (!this.casHead(null, s2)) continue;
                return s2;
            }
            if (p2.cannotPrecede(haveData)) {
                return null;
            }
            Node n2 = p2.next;
            if (n2 != null) {
                Node u2;
                p2 = p2 != t2 && t2 != (u2 = this.tail) ? u2 : (p2 != n2 ? n2 : null);
                continue;
            }
            if (p2.casNext(null, s2)) break;
            p2 = p2.next;
        }
        if (p2 != t2) {
            while (!(this.tail == t2 && this.casTail(t2, s2) || (t2 = this.tail) == null || (s2 = t2.next) == null || (s2 = s2.next) == null || s2 == t2)) {
            }
        }
        return p2;
    }

    private E awaitMatch(Node s2, Node pred, E e2, boolean timed, long nanos) {
        long lastTime = timed ? System.nanoTime() : 0L;
        Thread w2 = Thread.currentThread();
        int spins = -1;
        Random randomYields = null;
        while (true) {
            Object item;
            if ((item = s2.item) != e2) {
                s2.forgetContents();
                return LinkedTransferQueue.cast(item);
            }
            if ((w2.isInterrupted() || timed && nanos <= 0L) && s2.casItem(e2, s2)) {
                this.unsplice(pred, s2);
                return e2;
            }
            if (spins < 0) {
                spins = LinkedTransferQueue.spinsFor(pred, s2.isData);
                if (spins <= 0) continue;
                randomYields = ThreadLocalRandom.current();
                continue;
            }
            if (spins > 0) {
                --spins;
                if (randomYields.nextInt(64) != 0) continue;
                Thread.yield();
                continue;
            }
            if (s2.waiter == null) {
                s2.waiter = w2;
                continue;
            }
            if (timed) {
                long now = System.nanoTime();
                if ((nanos -= now - lastTime) > 0L) {
                    LockSupport.parkNanos(this, nanos);
                }
                lastTime = now;
                continue;
            }
            LockSupport.park(this);
        }
    }

    private static int spinsFor(Node pred, boolean haveData) {
        if (MP && pred != null) {
            if (pred.isData != haveData) {
                return 192;
            }
            if (pred.isMatched()) {
                return 128;
            }
            if (pred.waiter == null) {
                return 64;
            }
        }
        return 0;
    }

    final Node succ(Node p2) {
        Node next = p2.next;
        return p2 == next ? this.head : next;
    }

    private Node firstOfMode(boolean isData) {
        Node p2 = this.head;
        while (p2 != null) {
            if (!p2.isMatched()) {
                return p2.isData == isData ? p2 : null;
            }
            p2 = this.succ(p2);
        }
        return null;
    }

    private E firstDataItem() {
        Node p2 = this.head;
        while (p2 != null) {
            Object item = p2.item;
            if (p2.isData) {
                if (item != null && item != p2) {
                    return LinkedTransferQueue.cast(item);
                }
            } else if (item == null) {
                return null;
            }
            p2 = this.succ(p2);
        }
        return null;
    }

    private int countOfMode(boolean data) {
        int count2 = 0;
        Node p2 = this.head;
        while (p2 != null) {
            Node n2;
            if (!p2.isMatched()) {
                if (p2.isData != data) {
                    return 0;
                }
                if (++count2 == Integer.MAX_VALUE) break;
            }
            if ((n2 = p2.next) != p2) {
                p2 = n2;
                continue;
            }
            count2 = 0;
            p2 = this.head;
        }
        return count2;
    }

    final void unsplice(Node pred, Node s2) {
        block6: {
            Node n2;
            s2.forgetContents();
            if (pred == null || pred == s2 || pred.next != s2 || (n2 = s2.next) != null && (n2 == s2 || !pred.casNext(s2, n2) || !pred.isMatched())) break block6;
            while (true) {
                Node h2;
                if ((h2 = this.head) == pred || h2 == s2 || h2 == null) {
                    return;
                }
                if (!h2.isMatched()) break;
                Node hn = h2.next;
                if (hn == null) {
                    return;
                }
                if (hn == h2 || !this.casHead(h2, hn)) continue;
                h2.forgetNext();
            }
            if (pred.next != pred && s2.next != s2) {
                while (true) {
                    int v2;
                    if ((v2 = this.sweepVotes) < 32) {
                        if (!this.casSweepVotes(v2, v2 + 1)) continue;
                        break block6;
                    }
                    if (this.casSweepVotes(v2, 0)) break;
                }
                this.sweep();
            }
        }
    }

    private void sweep() {
        Node s2;
        Node p2 = this.head;
        while (p2 != null && (s2 = p2.next) != null) {
            if (!s2.isMatched()) {
                p2 = s2;
                continue;
            }
            Node n2 = s2.next;
            if (n2 == null) break;
            if (s2 == n2) {
                p2 = this.head;
                continue;
            }
            p2.casNext(s2, n2);
        }
    }

    private boolean findAndRemove(Object e2) {
        if (e2 != null) {
            Node pred = null;
            Node p2 = this.head;
            while (p2 != null) {
                Object item = p2.item;
                if (p2.isData) {
                    if (item != null && item != p2 && e2.equals(item) && p2.tryMatchData()) {
                        this.unsplice(pred, p2);
                        return true;
                    }
                } else if (item == null) break;
                if ((p2 = p2.next) != (pred = p2)) continue;
                pred = null;
                p2 = this.head;
            }
        }
        return false;
    }

    public LinkedTransferQueue() {
    }

    public LinkedTransferQueue(Collection<? extends E> c2) {
        this();
        this.addAll(c2);
    }

    @Override
    public void put(E e2) {
        this.xfer(e2, true, 1, 0L);
    }

    @Override
    public boolean offer(E e2, long timeout, TimeUnit unit) {
        this.xfer(e2, true, 1, 0L);
        return true;
    }

    @Override
    public boolean offer(E e2) {
        this.xfer(e2, true, 1, 0L);
        return true;
    }

    @Override
    public boolean add(E e2) {
        this.xfer(e2, true, 1, 0L);
        return true;
    }

    @Override
    public boolean tryTransfer(E e2) {
        return this.xfer(e2, true, 0, 0L) == null;
    }

    @Override
    public void transfer(E e2) throws InterruptedException {
        if (this.xfer(e2, true, 2, 0L) != null) {
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    @Override
    public boolean tryTransfer(E e2, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.xfer(e2, true, 3, unit.toNanos(timeout)) == null) {
            return true;
        }
        if (!Thread.interrupted()) {
            return false;
        }
        throw new InterruptedException();
    }

    @Override
    public E take() throws InterruptedException {
        E e2 = this.xfer(null, false, 2, 0L);
        if (e2 != null) {
            return e2;
        }
        Thread.interrupted();
        throw new InterruptedException();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E e2 = this.xfer(null, false, 3, unit.toNanos(timeout));
        if (e2 != null || !Thread.interrupted()) {
            return e2;
        }
        throw new InterruptedException();
    }

    @Override
    public E poll() {
        return this.xfer(null, false, 0, 0L);
    }

    @Override
    public int drainTo(Collection<? super E> c2) {
        E e2;
        if (c2 == null) {
            throw new NullPointerException();
        }
        if (c2 == this) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while ((e2 = this.poll()) != null) {
            c2.add(e2);
            ++n2;
        }
        return n2;
    }

    @Override
    public int drainTo(Collection<? super E> c2, int maxElements) {
        E e2;
        int n2;
        if (c2 == null) {
            throw new NullPointerException();
        }
        if (c2 == this) {
            throw new IllegalArgumentException();
        }
        for (n2 = 0; n2 < maxElements && (e2 = this.poll()) != null; ++n2) {
            c2.add(e2);
        }
        return n2;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public E peek() {
        return this.firstDataItem();
    }

    @Override
    public boolean isEmpty() {
        Node p2 = this.head;
        while (p2 != null) {
            if (!p2.isMatched()) {
                return !p2.isData;
            }
            p2 = this.succ(p2);
        }
        return true;
    }

    @Override
    public boolean hasWaitingConsumer() {
        return this.firstOfMode(false) != null;
    }

    @Override
    public int size() {
        return this.countOfMode(true);
    }

    @Override
    public int getWaitingConsumerCount() {
        return this.countOfMode(false);
    }

    @Override
    public boolean remove(Object o2) {
        return this.findAndRemove(o2);
    }

    @Override
    public boolean contains(Object o2) {
        if (o2 == null) {
            return false;
        }
        Node p2 = this.head;
        while (p2 != null) {
            Object item = p2.item;
            if (p2.isData) {
                if (item != null && item != p2 && o2.equals(item)) {
                    return true;
                }
            } else if (item == null) break;
            p2 = this.succ(p2);
        }
        return false;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (E e2 : this) {
            s2.writeObject(e2);
        }
        s2.writeObject(null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        Object item;
        s2.defaultReadObject();
        while ((item = s2.readObject()) != null) {
            this.offer(item);
        }
    }

    static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f2 = Unsafe.class.getDeclaredField("theUnsafe");
                        f2.setAccessible(true);
                        return (Unsafe)f2.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e2) {
                throw new RuntimeException("Could not initialize intrinsics", e2.getCause());
            }
        }
    }

    static {
        try {
            UNSAFE = LinkedTransferQueue.getUnsafe();
            Class<LinkedTransferQueue> k2 = LinkedTransferQueue.class;
            headOffset = UNSAFE.objectFieldOffset(k2.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(k2.getDeclaredField("tail"));
            sweepVotesOffset = UNSAFE.objectFieldOffset(k2.getDeclaredField("sweepVotes"));
        }
        catch (Exception e2) {
            throw new Error(e2);
        }
    }

    final class Itr
    implements Iterator<E> {
        private Node nextNode;
        private E nextItem;
        private Node lastRet;
        private Node lastPred;

        private void advance(Node prev) {
            Node r2 = this.lastRet;
            if (r2 != null && !r2.isMatched()) {
                this.lastPred = r2;
            } else {
                Node b2 = this.lastPred;
                if (b2 == null || b2.isMatched()) {
                    this.lastPred = null;
                } else {
                    Node n2;
                    Node s2;
                    while ((s2 = b2.next) != null && s2 != b2 && s2.isMatched() && (n2 = s2.next) != null && n2 != s2) {
                        b2.casNext(s2, n2);
                    }
                }
            }
            this.lastRet = prev;
            Node p2 = prev;
            while (true) {
                Node s3;
                Node node = s3 = p2 == null ? LinkedTransferQueue.this.head : p2.next;
                if (s3 == null) break;
                if (s3 == p2) {
                    p2 = null;
                    continue;
                }
                Object item = s3.item;
                if (s3.isData) {
                    if (item != null && item != s3) {
                        this.nextItem = LinkedTransferQueue.cast(item);
                        this.nextNode = s3;
                        return;
                    }
                } else if (item == null) break;
                if (p2 == null) {
                    p2 = s3;
                    continue;
                }
                Node n3 = s3.next;
                if (n3 == null) break;
                if (s3 == n3) {
                    p2 = null;
                    continue;
                }
                p2.casNext(s3, n3);
            }
            this.nextNode = null;
            this.nextItem = null;
        }

        Itr() {
            this.advance(null);
        }

        @Override
        public final boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public final E next() {
            Node p2 = this.nextNode;
            if (p2 == null) {
                throw new NoSuchElementException();
            }
            Object e2 = this.nextItem;
            this.advance(p2);
            return e2;
        }

        @Override
        public final void remove() {
            Node lastRet = this.lastRet;
            if (lastRet == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            if (lastRet.tryMatchData()) {
                LinkedTransferQueue.this.unsplice(this.lastPred, lastRet);
            }
        }
    }

    static final class Node {
        final boolean isData;
        volatile Object item;
        volatile Node next;
        volatile Thread waiter;
        private static final long serialVersionUID = -3375979862319811754L;
        private static final Unsafe UNSAFE;
        private static final long itemOffset;
        private static final long nextOffset;
        private static final long waiterOffset;

        final boolean casNext(Node cmp, Node val) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, cmp, val);
        }

        final boolean casItem(Object cmp, Object val) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, cmp, val);
        }

        Node(Object item, boolean isData) {
            UNSAFE.putObject(this, itemOffset, item);
            this.isData = isData;
        }

        final void forgetNext() {
            UNSAFE.putObject(this, nextOffset, this);
        }

        final void forgetContents() {
            UNSAFE.putObject(this, itemOffset, this);
            UNSAFE.putObject(this, waiterOffset, null);
        }

        final boolean isMatched() {
            Object x2 = this.item;
            return x2 == this || x2 == null == this.isData;
        }

        final boolean isUnmatchedRequest() {
            return !this.isData && this.item == null;
        }

        final boolean cannotPrecede(boolean haveData) {
            Object x2;
            boolean d2 = this.isData;
            return d2 != haveData && (x2 = this.item) != this && x2 != null == d2;
        }

        final boolean tryMatchData() {
            Object x2 = this.item;
            if (x2 != null && x2 != this && this.casItem(x2, null)) {
                LockSupport.unpark(this.waiter);
                return true;
            }
            return false;
        }

        static {
            try {
                UNSAFE = LinkedTransferQueue.getUnsafe();
                Class<Node> k2 = Node.class;
                itemOffset = UNSAFE.objectFieldOffset(k2.getDeclaredField("item"));
                nextOffset = UNSAFE.objectFieldOffset(k2.getDeclaredField("next"));
                waiterOffset = UNSAFE.objectFieldOffset(k2.getDeclaredField("waiter"));
            }
            catch (Exception e2) {
                throw new Error(e2);
            }
        }
    }
}

