/*
 * Decompiled with CFR 0.152.
 */
package jsr166y;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import jsr166y.ForkJoinTask;
import sun.misc.Unsafe;

public abstract class CountedCompleter
extends ForkJoinTask<Void> {
    private static final long serialVersionUID = 5232453752276485070L;
    CountedCompleter completer;
    volatile int pending;
    private static final Unsafe U;
    private static final long PENDING;

    protected CountedCompleter(CountedCompleter completer, int initialPendingCount) {
        this.completer = completer;
        this.pending = initialPendingCount;
    }

    protected CountedCompleter(CountedCompleter completer) {
        this.completer = completer;
    }

    protected CountedCompleter() {
        this.completer = null;
    }

    public abstract void compute();

    public void onCompletion(CountedCompleter caller) {
    }

    public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
        return true;
    }

    public final CountedCompleter getCompleter() {
        return this.completer;
    }

    public final void setCompleter(CountedCompleter x2) {
        this.completer = x2;
    }

    public final int getPendingCount() {
        return this.pending;
    }

    public final void setPendingCount(int count2) {
        this.pending = count2;
    }

    public final void addToPendingCount(int delta) {
        int c2;
        while (!U.compareAndSwapInt(this, PENDING, c2 = this.pending, c2 + delta)) {
        }
    }

    public final boolean compareAndSetPendingCount(int expected, int count2) {
        return U.compareAndSwapInt(this, PENDING, expected, count2);
    }

    public final void tryComplete() {
        this.__tryComplete(this);
    }

    public final void __tryComplete(CountedCompleter caller) {
        CountedCompleter a2 = this;
        CountedCompleter s2 = caller;
        while (true) {
            int c2;
            if ((c2 = a2.pending) == 0) {
                a2.onCompletion(s2);
                s2 = a2;
                a2 = s2.completer;
                if (a2 != null) continue;
                s2.quietlyComplete();
                return;
            }
            if (U.compareAndSwapInt(a2, PENDING, c2, c2 - 1)) break;
        }
    }

    @Override
    public void complete(Void mustBeNull) {
        this.onCompletion(this);
        this.quietlyComplete();
        CountedCompleter p2 = this.completer;
        if (p2 != null) {
            p2.tryComplete();
        }
    }

    @Override
    void internalPropagateException(Throwable ex) {
        CountedCompleter a2;
        CountedCompleter s2 = a2 = this;
        while (a2.onExceptionalCompletion(ex, s2)) {
            s2 = a2;
            a2 = s2.completer;
            if (a2 == null || a2.status < 0) break;
            a2.recordExceptionalCompletion(ex);
        }
    }

    @Override
    protected final boolean exec() {
        this.compute();
        return false;
    }

    @Override
    public final Void getRawResult() {
        return null;
    }

    @Override
    protected final void setRawResult(Void mustBeNull) {
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f2 = Unsafe.class.getDeclaredField("theUnsafe");
                        f2.setAccessible(true);
                        return (Unsafe)f2.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e2) {
                throw new RuntimeException("Could not initialize intrinsics", e2.getCause());
            }
        }
    }

    static {
        try {
            U = CountedCompleter.getUnsafe();
            PENDING = U.objectFieldOffset(CountedCompleter.class.getDeclaredField("pending"));
        }
        catch (Exception e2) {
            throw new Error(e2);
        }
    }
}

