/*
 * Decompiled with CFR 0.152.
 */
package javatests;

import java.lang.reflect.Field;

public class TestSupport {
    public static void assertThat(boolean test, String message) {
        if (!test) {
            throw new AssertionError(message);
        }
    }

    public static void fail(String message) {
        throw new AssertionError(message);
    }

    public static void assertEquals(Object a2, Object b2, String message) {
        TestSupport.assertThat(a2.equals(b2), message + "[a.equals(b) failed]");
        TestSupport.assertThat(b2.equals(a2), message + "[b.equals(a) failed]");
    }

    public static void assertNotEquals(Object a2, Object b2, String message) {
        TestSupport.assertThat(!a2.equals(b2), message + "[not a.equals(b) failed]");
        TestSupport.assertThat(!b2.equals(a2), message + "[not b.equals(a) failed]");
    }

    public static Field getField(Class cls, String name) {
        try {
            Field f2 = cls.getDeclaredField(name);
            f2.setAccessible(true);
            return f2;
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class AssertionError
    extends RuntimeException {
        public AssertionError() {
        }

        public AssertionError(String message) {
            super(message);
        }

        public AssertionError(String message, Throwable cause) {
            super(message, cause);
        }

        public AssertionError(Throwable cause) {
            super(cause);
        }
    }
}

