/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.common;

import java.math.BigInteger;

final class TimeUtils {
    static final long MAX_SECONDS = 315576000000L;
    static final int MAX_NANOS = 999999999;
    static final long MILLIS_PER_SECOND = 1000L;
    static final long NANOS_PER_MILLI = 1000000L;
    static final long NANOS_PER_SECOND = 1000000000L;
    private static final BigInteger MAX_LONG_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG_VALUE = BigInteger.valueOf(Long.MIN_VALUE);

    private TimeUtils() {
    }

    static int compareLongs(long x2, long y2) {
        if (x2 < y2) {
            return -1;
        }
        if (x2 == y2) {
            return 0;
        }
        return 1;
    }

    static long checkedAdd(long x2, long y2) {
        BigInteger sum = BigInteger.valueOf(x2).add(BigInteger.valueOf(y2));
        if (sum.compareTo(MAX_LONG_VALUE) > 0 || sum.compareTo(MIN_LONG_VALUE) < 0) {
            throw new ArithmeticException("Long sum overflow: x=" + x2 + ", y=" + y2);
        }
        return x2 + y2;
    }
}

