/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.rabit.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import water.util.Pair;

public class AssignedRank {
    private int rank;
    private List<Integer> neighbours;
    private Pair<Integer, Integer> ring;
    private int parent;

    public AssignedRank(int rank, List<Integer> neighbours, Pair<Integer, Integer> ring, int parent) {
        this.rank = rank;
        this.neighbours = neighbours;
        this.ring = ring;
        this.parent = parent;
    }

    public ByteBuffer toByteBuffer(int worldSize) {
        ByteBuffer buffer = ByteBuffer.allocate(4 * (this.neighbours.size() + 6)).order(ByteOrder.nativeOrder());
        buffer.putInt(this.rank).putInt(this.parent).putInt(worldSize).putInt(this.neighbours.size());
        for (Integer n2 : this.neighbours) {
            buffer.putInt(n2);
        }
        buffer.putInt(this.ring._1() != -1 && this.ring._1() != this.rank ? this.ring._1() : -1);
        buffer.putInt(this.ring._2() != -1 && this.ring._2() != this.rank ? this.ring._2() : -1);
        buffer.flip();
        return buffer;
    }
}

